/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.service.rest.util;

import com.huawei.ism.tool.certbase.entitys.CertReqEntity;
import com.huawei.ism.tool.certbase.keytool.services.impls.CertificateManageService;
import com.huawei.ism.tool.certbase.utils.CertGenerateUtil;
import com.huawei.ism.tool.file.SecurityUtils;
import com.huawei.ism.tool.obase.utils.FileUtils;
import java.io.File;
import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CertsUtil {
    private static final Logger log = LoggerFactory.getLogger(CertsUtil.class);
    public static final String DEFAULT_CERT_ALIAS = "FusionServerTools";
    public static final boolean DEFAULT_ENABLE = true;
    public static final String DEFAULT_CERT_DIR_PATH = CertGenerateUtil.getDefaultCertPath();
    public static final String DEFAULT_CERT_FILE_PATH = CertGenerateUtil.getDefaultCertStoreLocation();
    public static final int DEFAULT_CERT_STOREPASS_SIZE = 32;
    private static final int CERT_VALIDITY_YEARS = 50;
    private static final CertificateManageService INSTANCE = new CertificateManageService();
    private static final char[] DEFAULT_CERT_STOREPASS = new char[32];
    private static final char BLANK = ' ';

    public static boolean generateDefaultSelfSignedCerts() {
        if (!CertsUtil.generateCerts(SecurityUtils.generatePassword(32))) {
            CertsUtil.clearDefaultSelfSignedCerts();
            log.error("generate default self sign cert failed.");
            return false;
        }
        return true;
    }

    public static void clearDefaultSelfSignedCerts() {
        FileUtils.deleteAllInFolder(DEFAULT_CERT_DIR_PATH);
    }

    public static boolean generateCerts(String password) {
        CertsUtil.clearDefaultSelfSignedCerts();
        File certDir = new File(DEFAULT_CERT_DIR_PATH);
        if (!certDir.exists() && !certDir.mkdirs()) {
            log.error("make cert dir failed.");
            return false;
        }
        CertsUtil.fillCertStorePass(password.toCharArray());
        CertReqEntity entity = ((CertReqEntity.CertReqEntityBuilder)((CertReqEntity.CertReqEntityBuilder)((CertReqEntity.CertReqEntityBuilder)CertReqEntity.builder().keyStoreFile(DEFAULT_CERT_FILE_PATH)).storePass(password)).keyPass(password)).validity(CertsUtil.calculateDaysInYears(50)).build();
        return INSTANCE.generateKeyStore(entity);
    }

    public static void fillCertStorePass(char[] storepass) {
        for (int i = 0; i < DEFAULT_CERT_STOREPASS.length; ++i) {
            CertsUtil.DEFAULT_CERT_STOREPASS[i] = storepass[i];
            storepass[i] = 32;
        }
    }

    public static String getCertStorePass() {
        String storepass = new String(DEFAULT_CERT_STOREPASS);
        Arrays.fill(DEFAULT_CERT_STOREPASS, ' ');
        return storepass;
    }

    private static int calculateDaysInYears(int years) {
        LocalDate today = LocalDate.now();
        LocalDate futureDate = today.plusYears(years);
        return (int)ChronoUnit.DAYS.between(today, futureDate);
    }

    private CertsUtil() {
    }
}

