/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.service.task.state.based.transition;

import com.huawei.ism.tool.service.task.state.based.Action;
import com.huawei.ism.tool.service.task.state.based.Condition;
import com.huawei.ism.tool.service.task.state.based.ExecuteContext;
import com.huawei.ism.tool.service.task.state.based.transition.Transition;
import com.huawei.ism.tool.service.task.state.based.transition.TransitionPath;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;

public class ChoicesTransitionPath<S extends Enum<S>, E extends Enum<E>>
implements TransitionPath<S, E> {
    private final S source;
    private final E event;
    private final List<Choice<S, E>> choices;

    @Override
    public Transition<S, E> evaluate(ExecuteContext<S, E> context) {
        for (Choice<S, E> choice : this.choices) {
            if (((Choice)choice).condition != null && !((Choice)choice).condition.matches(context)) continue;
            return choice;
        }
        return null;
    }

    public String toString() {
        return "CHOICES:" + this.source + "==<" + this.event + ">==>" + this.choices.stream().map(Choice::toString).collect(Collectors.joining(",", "[", "]"));
    }

    public ChoicesTransitionPath(S source, E event, List<Choice<S, E>> choices) {
        this.source = source;
        this.event = event;
        this.choices = choices;
    }

    public static class Choice<S extends Enum<S>, E extends Enum<E>>
    implements Transition<S, E> {
        private final int id;
        private final S target;
        @Nullable
        private final Condition<S, E> condition;
        @Nullable
        private final Action<S, E> action;
        @Nullable
        private final E errEvent;

        @Override
        public Optional<E> transit(ExecuteContext<S, E> context) {
            return this.action == null ? Optional.empty() : this.action.execute(context);
        }

        public String toString() {
            return this.target + (this.condition == null ? (this.action == null ? "" : "(A)") : (this.action == null ? "(C)" : "(C|A)")) + (this.errEvent == null ? "" : "(E:" + this.errEvent + ")") + ":" + this.id;
        }

        public Choice(int id, S target, @Nullable Condition<S, E> condition, @Nullable Action<S, E> action, @Nullable E errEvent) {
            this.id = id;
            this.target = target;
            this.condition = condition;
            this.action = action;
            this.errEvent = errEvent;
        }

        @Override
        public int id() {
            return this.id;
        }

        @Override
        public S target() {
            return this.target;
        }

        @Override
        @Nullable
        public E errEvent() {
            return this.errEvent;
        }
    }
}

