/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.uMate.common.model;

import com.huawei.uMate.common.CommonMethods;
import com.huawei.uMate.common.SystemConfig;
import com.huawei.uMate.common.UMateException;
import com.huawei.uMate.common.utils.ResUtil;
import com.huawei.uMate.common.utils.SecurityUtils;

public class SFTPModel {
    private static final String SFTP_IP_KEY = "SFTP_IP_Address";
    private static final String SFTP_PORT_KEY = "SFTP_Port";
    private static final String SFTP_USER_NAME_KEY = "SFTP_User_Name";
    private static final ResUtil RES = ResUtil.getInstance("common");
    private static char[] SFTP_PWD = null;
    private static String sftpPath = "./";
    private static String logPath = "log/sftp/server.log";
    private static String keyPath = "log/sftp/key.log";
    private static boolean ZERO_FLAG = false;

    public static void setZERO_FLAG(boolean ZERO_FLAG) {
        SFTPModel.ZERO_FLAG = ZERO_FLAG;
    }

    public static String getSFTP_IP() {
        String configValue = SystemConfig.createSystemConfig().getConfigVlaue(SFTP_IP_KEY);
        String string = configValue = configValue == null ? "" : configValue.trim();
        if (!SecurityUtils.isValidAndSafeIp(configValue)) {
            return "";
        }
        return configValue;
    }

    public static void setSFTP_IP(String IPAddress) throws UMateException {
        if (IPAddress.contains("Auto select")) {
            return;
        }
        String vlaue = IPAddress.replace(" ", "");
        if (ZERO_FLAG) {
            if (!CommonMethods.checkIPZero(IPAddress)) {
                SFTPModel.setZERO_FLAG(false);
                throw new UMateException(RES.getString("common.message.sftp.ip.invalid"));
            }
            SFTPModel.setZERO_FLAG(false);
        } else if (!CommonMethods.checkIP(IPAddress)) {
            throw new UMateException(RES.getString("common.message.sftp.ip.invalid"));
        }
        SystemConfig.createSystemConfig().setConfigVlaue(SFTP_IP_KEY, vlaue);
    }

    public static String getSFTP_SERVER_PORT() {
        int port = SystemConfig.createSystemConfig().getIntConfigValue(SFTP_PORT_KEY, 22);
        return String.valueOf(port > 0 ? port : 22);
    }

    public static void setSFTP_SERVER_PORT(String SFTPPort) throws UMateException {
        if (!CommonMethods.checkPort(SFTPPort, "SFTP")) {
            throw new UMateException("SFTP server port is invalid.");
        }
        SystemConfig.createSystemConfig().setConfigVlaue(SFTP_PORT_KEY, SFTPPort.trim());
    }

    public static String getSFTP_User() {
        String configVlaue = SystemConfig.createSystemConfig().getConfigVlaue(SFTP_USER_NAME_KEY);
        String string = configVlaue = configVlaue == null ? "" : configVlaue.trim();
        if (!SecurityUtils.isValidAndSafeUser(configVlaue)) {
            return "";
        }
        return configVlaue;
    }

    public static void setSFTP_User(String userName) throws UMateException {
        String trimmedUserName = userName.trim();
        if (trimmedUserName.isEmpty()) {
            throw new UMateException("SFTP server user name can not be empty.");
        }
        SystemConfig.createSystemConfig().setConfigVlaue(SFTP_USER_NAME_KEY, trimmedUserName);
    }

    public static String getPassword() {
        if (SFTP_PWD == null) {
            return "";
        }
        return new String(SFTP_PWD);
    }

    public static void setSFTP_PWD(char[] aPassword) throws UMateException {
        if (aPassword == null || aPassword.length == 0) {
            throw new UMateException("SFTP server password can not be empty.");
        }
        if (!SecurityUtils.isValidAndSafePassword(String.valueOf(aPassword))) {
            throw new UMateException("SFTP server password is invalid.");
        }
        SFTP_PWD = aPassword;
    }

    public static String getSftpPath() {
        return sftpPath;
    }

    public static void setSftpPath(String aSftpPath) {
        if (SecurityUtils.isValidAndSafePath(aSftpPath)) {
            sftpPath = aSftpPath;
        }
    }

    public static String getLogPath() {
        return logPath;
    }

    public static String getKeyPath() {
        return keyPath;
    }
}

