/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.uMate.common.rest;

import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.obase.entity.ClusterNode;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.entity.User;
import com.huawei.uMate.common.log.Logger;
import com.huawei.uMate.common.rest.RedfishConnestion;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;

public class BmcRedfishConnManagement {
    private static ConcurrentHashMap<String, RedfishConnestion> connectionPool = new ConcurrentHashMap();
    private static final Logger LOGGER = new Logger(BmcRedfishConnManagement.class);

    private BmcRedfishConnManagement() {
    }

    public static RedfishConnestion getRedFishConnection(ClusterNode clusterNode) {
        if (clusterNode == null || clusterNode.getBmcNode() == null) {
            return RedfishConnestion.EMPTY;
        }
        String poolKey = BmcRedfishConnManagement.getPoolKey(clusterNode);
        if (connectionPool.containsKey(poolKey) && connectionPool.get(poolKey) != null) {
            return connectionPool.get(poolKey);
        }
        return BmcRedfishConnManagement.createRedFishConnector(clusterNode);
    }

    private static RedfishConnestion createRedFishConnector(ClusterNode clusterNode) {
        RedfishConnestion restConn = new RedfishConnestion(clusterNode.getBmcNode().getIp(), clusterNode.getBmcNode().getRedFishPort(), clusterNode.getBmcNode().getLoginUser().getUserName(), clusterNode.getBmcNode().getLoginUser().getPassword());
        restConn.connect();
        connectionPool.put(BmcRedfishConnManagement.getPoolKey(clusterNode), restConn);
        return restConn;
    }

    public static ClusterNode createClusterNode(String ip, String port, String name, String passWord) {
        User user = new User();
        user.setUserName(name);
        user.setPassword(passWord);
        StringUtils.cleanPwd((String)passWord);
        DevNode devNode = new DevNode();
        devNode.setIp(ip);
        devNode.setRedFishPort(port);
        devNode.setLoginUser(user);
        ClusterNode clusterNode = new ClusterNode();
        clusterNode.setBmcNode(devNode);
        return clusterNode;
    }

    public static void releaseConnection(DevNode devNode) {
        if (devNode == null) {
            LOGGER.error("release connection error.devNode is null");
            return;
        }
        List clusterNodes = devNode.getClusterNodes();
        if (clusterNodes == null) {
            LOGGER.error("release connection error.clusterNodes is null");
            return;
        }
        clusterNodes.stream().forEach(node -> BmcRedfishConnManagement.releaseConnection(node));
    }

    public static void releaseConnection(ClusterNode clusterNode) {
        if (clusterNode == null || clusterNode.getBmcNode() == null) {
            return;
        }
        String poolKey = BmcRedfishConnManagement.getPoolKey(clusterNode);
        if (connectionPool.containsKey(poolKey) && connectionPool.get(poolKey) != null) {
            connectionPool.get(poolKey).release();
            connectionPool.remove(poolKey);
        }
    }

    private static String getPoolKey(ClusterNode clusterNode) {
        return clusterNode.getManagementIp() + "_" + clusterNode.getBmcNode().getIp();
    }
}

