/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.uMate.common.rest;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.huawei.ism.tool.base.utils.AESEncrypt;
import com.huawei.ism.tool.base.utils.StreamUtils;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.obase.connection.support.ConnUtils;
import com.huawei.ism.util.CommonUtil;
import com.huawei.uMate.HWDiscover.model.HWDiscoverModel;
import com.huawei.uMate.common.UMateException;
import com.huawei.uMate.common.log.Logger;
import com.huawei.uMate.common.rest.AllAcceptVerifier;
import com.huawei.uMate.common.rest.RedfishResult;
import com.huawei.uMate.common.rest.ReqConfig;
import com.huawei.uMate.common.rest.SimpleTrustManager;
import com.huawei.uMate.common.rest.https.HttpsCertManager;
import com.huawei.uMate.common.rest.services.IRedfishConnAttrService;
import com.huawei.uMate.common.rest.services.RedfishConnAttrService;
import com.huawei.uMate.common.utils.AppContext;
import com.huawei.uMate.common.utils.ResUtil;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.Flushable;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.net.SocketTimeoutException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Semaphore;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.FileUtils;
import org.apache.hc.client5.http.HttpHostConnectException;
import org.apache.hc.client5.http.classic.methods.HttpDelete;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpPatch;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.classic.methods.HttpUriRequest;
import org.apache.hc.client5.http.classic.methods.HttpUriRequestBase;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.entity.mime.MultipartEntityBuilder;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.socket.ConnectionSocketFactory;
import org.apache.hc.client5.http.ssl.SSLConnectionSocketFactory;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.ParseException;
import org.apache.hc.core5.http.URIScheme;
import org.apache.hc.core5.http.config.Registry;
import org.apache.hc.core5.http.config.RegistryBuilder;
import org.apache.hc.core5.http.io.SocketConfig;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.apache.hc.core5.pool.PoolConcurrencyPolicy;
import org.apache.hc.core5.pool.PoolReusePolicy;
import org.apache.hc.core5.util.Timeout;

public class RedfishConnestion {
    public static final RedfishConnestion EMPTY = null;
    public static final int DEFAULT_TIMEOUT = 60000;
    public static final int DEFAULT_TIMEOUT_SECOND = 60;
    public static final String NOT_FOUND = "404";
    public static final List<Integer> SUCCESS = Arrays.asList(200, 201, 202, 203, 204, 205, 206);
    public static final String SEP = ":";
    public static final String BAD_GATEWAY_MSG = "502 Bad Gateway";
    public static final String[] NEED_AUTH_TOKEN = new String[]{"X-Auth-Token is a required property", "There is no valid session established with the implementation", "token is None", "session has been removed", "Token required failed"};
    public static final String INTERNAL_ERROR = "-100";
    public static final String BASIC_AUTH_HEAD = "Basic ";
    public static final String GET = "GET";
    public static final String POST = "POST";
    public static final String PATCH = "PATCH";
    public static final String DELETE = "DELETE";
    public static final String NEED_REFRESH_SESSION = "current session has been removed";
    private static final Logger LOGGER = new Logger(RedfishConnestion.class);
    private static final ResUtil RES = ResUtil.getInstance("common");
    private static Semaphore EXEC_SEMAPHORE = new Semaphore(30);
    private IRedfishConnAttrService connAttrService = new RedfishConnAttrService();
    private String authHeader;
    private String authTokenId;
    private String destIp;
    private String destPort = "443";
    private CloseableHttpClient client;
    private ReqConfig config = new ReqConfig();
    private final Object lock = new Object();
    private String eTag;
    private String xAuthToken;
    private boolean isRequestToken = false;
    private String chassisId = "";

    public RedfishConnestion(HWDiscoverModel model) {
        this(model.getIPAddress(), StringUtils.isNULLStr((String)model.getHTTPSPort()) ? "443" : model.getHTTPSPort(), model.getUserName(), model.getUserPwd());
    }

    public ReqConfig getConfig() {
        return this.config;
    }

    public RedfishConnestion(String destIp, String destPort, String uName, String pwd) {
        String auth = uName + SEP + pwd;
        byte[] encodedAuth = Base64.encodeBase64(auth.getBytes(StandardCharsets.ISO_8859_1));
        this.authHeader = AESEncrypt.encrypt((String)(BASIC_AUTH_HEAD + new String(encodedAuth, StandardCharsets.UTF_8)));
        this.destIp = destIp;
        if (!StringUtils.isNULLStr((String)destPort)) {
            this.destPort = destPort;
        }
    }

    public String getChassisId() {
        return this.chassisId;
    }

    public void setChassisId(String chassisId) {
        this.chassisId = chassisId;
    }

    public String getAuthHeader() {
        return AESEncrypt.decrypt((String)this.authHeader);
    }

    private boolean initConn(String potocol) {
        try {
            RequestConfig defaultRequestConfig = RequestConfig.custom().setConnectTimeout(Timeout.ofSeconds(60L)).setConnectionRequestTimeout(Timeout.ofSeconds(60L)).build();
            SSLContext sslcontext = HttpsCertManager.getInstance().getSSLContext(potocol, AppContext.getInstance().isVerifyCert());
            SSLConnectionSocketFactory socketFactory = new SSLConnectionSocketFactory(sslcontext, (HostnameVerifier)new AllAcceptVerifier());
            Registry<ConnectionSocketFactory> socketFactoryRegistry = RegistryBuilder.create().register(URIScheme.HTTP.id, socketFactory).register(URIScheme.HTTPS.id, socketFactory).build();
            PoolingHttpClientConnectionManager connManager = new PoolingHttpClientConnectionManager(socketFactoryRegistry, PoolConcurrencyPolicy.STRICT, PoolReusePolicy.LIFO, Timeout.ofSeconds(60L), null, null, null);
            connManager.setDefaultSocketConfig(SocketConfig.custom().setSoTimeout(Timeout.ofSeconds(60L)).build());
            this.client = HttpClientBuilder.create().setConnectionManager(connManager).setDefaultRequestConfig(defaultRequestConfig).setConnectionManagerShared(true).build();
        }
        catch (Throwable e) {
            LOGGER.error("error to init", e);
            return false;
        }
        return true;
    }

    public void setDestIp(String destIp) {
        this.destIp = destIp;
    }

    public String getDestIp() {
        return this.destIp;
    }

    public boolean connect() {
        return this.connect(this.isRequestToken);
    }

    public boolean connect(boolean isRequestToken) {
        boolean initResult = this.initHttpClient();
        if (!isRequestToken || !initResult) {
            return initResult;
        }
        Map<String, String> result = this.connAttrService.queryAuthToken(this);
        this.xAuthToken = result.get("X-Auth-Token");
        this.authTokenId = result.get("Id");
        this.isRequestToken = isRequestToken;
        return !StringUtils.isNULLStr((String)this.xAuthToken);
    }

    private boolean initHttpClient() {
        String[] protocolPrefers;
        for (String protocol : protocolPrefers = AppContext.getInstance().getProtocolFromConfig()) {
            Optional<String> chooseProtocolOp = this.choosePreferedProtocol(protocol);
            if (!chooseProtocolOp.isPresent() || !this.initConn(chooseProtocolOp.get())) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Optional<String> choosePreferedProtocol(String protocol) {
        SSLContext context = null;
        SSLSocket socket = null;
        try {
            context = SSLContext.getInstance(protocol);
            SimpleTrustManager simpleTrustManager = new SimpleTrustManager();
            context.init(null, new TrustManager[]{simpleTrustManager}, SecureRandom.getInstanceStrong());
            SSLSocketFactory factory = context.getSocketFactory();
            socket = (SSLSocket)CommonUtil.convertObject((Object)factory.createSocket(), SSLSocket.class);
            socket.connect(new InetSocketAddress(this.destIp.replaceAll("[\\[\\]]", ""), (int)Integer.valueOf(this.destPort)), 60000);
            socket.setSoTimeout(60000);
            socket.startHandshake();
            Optional<String> optional = Optional.of(protocol);
            StreamUtils.closeResource(null, (Closeable)socket);
            return optional;
        }
        catch (Exception e) {
            LOGGER.error(String.format(Locale.ENGLISH, "protocol %s is not supported.", protocol));
        }
        finally {
            StreamUtils.closeResource(null, socket);
        }
        return Optional.empty();
    }

    public CloseableHttpClient createCloseableHttpClient() {
        if (this.client == null) {
            this.initHttpClient();
        }
        return this.client;
    }

    public RedfishResult executeGetAndCheck(String url) throws UMateException {
        RedfishResult result = this.executeGet(url);
        if (!result.isSuccess()) {
            throw new UMateException(RES.getString("config.check.device.query.error"));
        }
        return result;
    }

    public RedfishResult request(String method, String resource, Map<String, String> headersMap, Map<String, String> dataMap, ReqConfig config) {
        return this.request(method, resource, headersMap == null ? null : JSON.toJSONString(headersMap), JSON.toJSONString(dataMap), config);
    }

    public RedfishResult request(String method, String resource, String headersJson, String dataJson, ReqConfig configParam) {
        if (StringUtils.isNULLStr((String)method)) {
            return null;
        }
        LOGGER.info(String.format(Locale.ENGLISH, "##url : %s ##method : %s ##ip : %s", resource, method, this.destIp));
        ReqConfig validConfigParam = configParam == null ? this.config : configParam;
        RedfishResult result = this.doRequest(method, resource, headersJson, dataJson, validConfigParam);
        LOGGER.infoDefault(String.format(Locale.ROOT, "cmd %s retry times %s", resource, this.config.getTrTryTimes()), new String[0]);
        if (this.isNeedBreak(resource, validConfigParam, result)) {
            return result;
        }
        int tryTimes = validConfigParam.getTrTryTimes();
        for (int i = 0; i < tryTimes; ++i) {
            if (!this.waitAndReconn(this.isNeedAuthToken(result), !result.getResult().contains(NEED_REFRESH_SESSION)) || !(result = this.doRequest(method, resource, headersJson, dataJson, validConfigParam)).isSuccess()) continue;
            return result;
        }
        if (!result.isSuccess()) {
            LOGGER.warn(String.format(Locale.ENGLISH, "request:%s fail,msg:%s,method:%s", resource, result.getResultJSON(), method));
        }
        return result;
    }

    private boolean isNeedAuthToken(RedfishResult result) {
        for (int i = 0; i < NEED_AUTH_TOKEN.length; ++i) {
            if (!result.getResult().contains(NEED_AUTH_TOKEN[i])) continue;
            return true;
        }
        return false;
    }

    private boolean isNeedBreak(String resource, ReqConfig configParam, RedfishResult result) {
        return result.isSuccess() || RedfishResult.NOT_RETRY_ERROR.contains(result.getErrorCode()) || configParam.getTrTryTimes() <= 0 || StringUtils.isNULLStr((String)resource) || result.isPwdError();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean waitAndReconn(boolean isRequestTokenCur, boolean isRelease) {
        ConnUtils.sleep((int)5000);
        String releaseToken = this.authTokenId;
        try {
            Object object = this.lock;
            synchronized (object) {
                boolean reconnResult = this.connect(isRequestTokenCur || this.isRequestToken);
                LOGGER.info(String.format(Locale.ENGLISH, "device %s reconn result:%b", this.destIp, reconnResult));
                boolean bl = reconnResult;
                return bl;
            }
        }
        finally {
            if (isRelease) {
                if (this.isRequestToken) {
                    this.connAttrService.releaseSessionWithToken(this, releaseToken);
                }
                StreamUtils.closeResource(null, (Closeable)this.client);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private RedfishResult doRequest(String method, String resource, String headersJson, String dataJson, ReqConfig configParam) {
        RedfishResult result;
        block12: {
            result = new RedfishResult();
            CloseableHttpResponse response = null;
            HttpUriRequest request = null;
            try {
                EXEC_SEMAPHORE.acquire();
                request = this.createRequest(method, resource, headersJson, dataJson, configParam);
                Object object = this.lock;
                synchronized (object) {
                    response = this.client.execute(request);
                }
                int statusCode = response.getCode();
                if (configParam.isDownload() && SUCCESS.contains(statusCode)) {
                    this.handleResponse(result, response, configParam);
                } else {
                    this.handleResponse(result, response, statusCode);
                }
                Map<String, String> headersMap = result.getHeaders();
                this.eTag = headersMap.containsKey("ETag") ? headersMap.get("ETag") : headersMap.get("etag");
                EXEC_SEMAPHORE.release();
            }
            catch (SocketTimeoutException | HttpHostConnectException e) {
                LOGGER.error("error to connect host.", e);
                RedfishResult redfishResult = RedfishResult.createConnErrorResult();
                return redfishResult;
            }
            catch (Exception e2) {
                result.setSuccess(false);
                result.setErrorCode(INTERNAL_ERROR);
                LOGGER.error("error to execute get", e2);
                break block12;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                EXEC_SEMAPHORE.release();
                StreamUtils.closeResource(null, response);
            }
            StreamUtils.closeResource(null, (Closeable)response);
        }
        return result;
    }

    private HttpUriRequest createRequest(String method, String resource, String headers, String jsonData, ReqConfig configParam) throws UnsupportedEncodingException {
        HttpUriRequestBase request = null;
        String ipReal = this.destIp.contains(SEP) ? '[' + this.destIp + ']' : this.destIp;
        String resourceNew = String.format(Locale.ENGLISH, "https://%s:%s%s", ipReal, this.destPort, resource);
        switch (method) {
            case "GET": {
                StringBuilder urlResource = new StringBuilder(resourceNew);
                this.addParamUrl(jsonData, urlResource);
                request = new HttpGet(urlResource.toString());
                break;
            }
            case "POST": {
                request = new HttpPost(resourceNew);
                if (configParam.isUpload()) {
                    HttpEntity reqEntity = this.getFormDataHttpEntity(jsonData);
                    this.setEntityBody(reqEntity, request);
                    break;
                }
                this.setEntityBody(jsonData, request);
                break;
            }
            case "PATCH": {
                request = new HttpPatch(resourceNew);
                this.setEntityBody(jsonData, request);
                break;
            }
            case "DELETE": {
                request = new HttpDelete(resourceNew);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid HTTP method: " + method);
            }
        }
        if (this.authHeader != null && request != null) {
            request.setHeader("Authorization", this.getAuthHeader());
            this.addHeader(headers, request);
            Timeout timeout = this.getTimeout(configParam);
            request.setConfig(RequestConfig.custom().setConnectionRequestTimeout(timeout).setConnectTimeout(timeout).build());
        }
        return request;
    }

    private Timeout getTimeout(ReqConfig configParam) {
        return Timeout.ofSeconds((configParam == null ? this.config.getSocketTimeout() : configParam.getSocketTimeout()) / 1000);
    }

    private HttpEntity getFormDataHttpEntity(String jsonData) {
        JSONObject upgradeObject = JSON.parseObject(jsonData);
        String imgfile = upgradeObject.getString("imgfile");
        String fileName = imgfile.trim().substring(imgfile.trim().lastIndexOf("/") + 1);
        return MultipartEntityBuilder.create().addBinaryBody("imgfile", FileUtils.getFile(imgfile), ContentType.MULTIPART_FORM_DATA, fileName).build();
    }

    private void setEntityBody(HttpEntity reqEntity, HttpUriRequestBase request) {
        if (null != reqEntity) {
            request.setEntity(reqEntity);
        }
    }

    private void setEntityBody(String data, HttpUriRequestBase request) {
        if (!StringUtils.isNULLStr((String)data)) {
            request.setEntity(new StringEntity(data, Charset.forName("UTF-8")));
        }
    }

    private void addParamUrl(String data, StringBuilder urlResource) {
        if (StringUtils.isNULLStr((String)data)) {
            return;
        }
        JSONObject dataJson = JSONObject.parseObject(data);
        for (Map.Entry<String, Object> entry : dataJson.entrySet()) {
            Object val = entry.getValue();
            urlResource.append('&').append(entry.getKey()).append('=').append(val == null ? null : val.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addHeader(String headers, HttpUriRequest request) {
        try {
            if (StringUtils.isNULLStr((String)headers)) {
                this.addDefaultHeader(request);
                return;
            }
            JSONObject headerJson = JSONObject.parseObject(headers);
            Iterator<Map.Entry<String, Object>> iterator = headerJson.entrySet().iterator();
            while (iterator.hasNext()) {
                Object val;
                Map.Entry<String, Object> entry;
                request.addHeader(entry.getKey(), (val = (entry = iterator.next()).getValue()) == null ? null : val.toString());
            }
        }
        finally {
            if (request.getFirstHeader("If-Match") == null) {
                this.addRequestHeader(request);
            }
        }
    }

    private void addRequestHeader(HttpUriRequest request) {
        if (!StringUtils.isNULLStr((String)this.eTag)) {
            request.addHeader("If-Match", this.eTag);
        }
        if (!StringUtils.isNULLStr((String)this.xAuthToken)) {
            request.addHeader("X-Auth-Token", this.xAuthToken);
        }
    }

    public String geteTag() {
        return this.eTag;
    }

    private void addDefaultHeader(HttpUriRequest request) {
        if (!StringUtils.isNULLStr((String)this.eTag)) {
            request.addHeader("If-Match", this.eTag);
        }
        request.addHeader("content-type", "application/json");
    }

    private void handleResponse(RedfishResult result, CloseableHttpResponse response, int statusCode) throws IOException, ParseException {
        result.setStatusCode(String.valueOf(statusCode));
        String resultStr = EntityUtils.toString(response.getEntity(), "UTF-8");
        LOGGER.info(String.format(Locale.ENGLISH, "##ip %s  ##result : %s", this.destIp, resultStr));
        resultStr = resultStr == null ? null : resultStr.replace("\\/", "/");
        result.setResult(resultStr);
        try {
            boolean containsError;
            Header[] headers = response.getHeaders();
            HashMap<String, String> headersMap = new HashMap<String, String>();
            result.setHeaders(headersMap);
            for (Header header : headers) {
                headersMap.put(header.getName(), header.getValue());
            }
            JSONObject resultObj = resultStr == null ? null : JSONObject.parseObject(resultStr);
            boolean bl = containsError = resultObj == null ? false : resultObj.containsKey("error");
            if (containsError) {
                JSONObject error = resultObj.getJSONObject("error");
                result.setErrorCode(error.getString("code"));
                result.setErrorMsg(error.getString("message"));
            } else if (!SUCCESS.contains(statusCode)) {
                result.setErrorCode(String.valueOf(statusCode));
            }
            result.setSuccess(SUCCESS.contains(statusCode));
        }
        catch (JSONException je) {
            result.setErrorCode("-3");
            LOGGER.error(statusCode);
            if (je.getMessage().contains("502")) {
                result.setErrorMsg(BAD_GATEWAY_MSG);
            }
            LOGGER.error("error to handle response.", je);
        }
        catch (Exception e) {
            result.setSuccess(SUCCESS.contains(statusCode));
            if (!result.isSuccess()) {
                LOGGER.error("error to set.", e);
            }
            result.setResult(resultStr);
            result.setSuccess(SUCCESS.contains(statusCode));
        }
    }

    private void handleResponse(RedfishResult result, CloseableHttpResponse response, ReqConfig cfg) {
        LOGGER.info(String.format(Locale.ROOT, "Download log files from server.The download path is %s.", cfg.getDownloadPath()));
        boolean isSuccess = this.downloadISEServerLog(response, cfg.getDownloadPath());
        result.setSuccess(isSuccess);
        Header[] headers = response.getHeaders();
        HashMap<String, String> headersMap = new HashMap<String, String>();
        for (Header header : headers) {
            headersMap.put(header.getName(), header.getValue());
        }
        result.setHeaders(headersMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean downloadISEServerLog(CloseableHttpResponse response, String downloadPath) {
        boolean bl;
        InputStream in = null;
        FileOutputStream fos = null;
        try {
            in = response.getEntity().getContent();
            File file = FileUtils.getFile(downloadPath);
            fos = FileUtils.openOutputStream(file);
            int data = -1;
            byte[] tmp = new byte[1024];
            while ((data = in.read(tmp)) != -1) {
                fos.write(tmp, 0, data);
            }
            bl = true;
            StreamUtils.closeResource((Flushable)fos, (Closeable)fos);
        }
        catch (IOException e) {
            LOGGER.error("Download ISE server log files error.", e);
            boolean bl2 = false;
            return bl2;
        }
        finally {
            StreamUtils.closeResource(fos, fos);
            StreamUtils.closeResource(null, (Closeable)in);
        }
        StreamUtils.closeResource(null, (Closeable)in);
        return bl;
    }

    public RedfishResult executeGet(String url) {
        return this.request(GET, url, "", "", null);
    }

    public RedfishResult executeDelete(String url, ReqConfig configParam) {
        return this.request(DELETE, url, "", "", configParam);
    }

    public RedfishResult executeDelete(String url) {
        return this.request(DELETE, url, "", "", null);
    }

    public RedfishResult executeGet(String url, Map<String, String> data, Map<String, String> header) {
        ReqConfig cfg = this.config.clone();
        cfg.setConnectTimeout(60000).setSocketTimeout(60000);
        return this.request(GET, url, header, data, cfg);
    }

    public RedfishResult executePatch(String url, String dataJson, String headerJson) {
        return this.request(PATCH, url, headerJson, dataJson, null);
    }

    public RedfishResult executePatch(String url, String dataJson, String headerJson, int timeOut) {
        ReqConfig cfg = this.config.clone();
        cfg.setConnectTimeout(timeOut).setSocketTimeout(timeOut);
        return this.request(PATCH, url, headerJson, dataJson, null);
    }

    public RedfishResult executePatch(String url, Map<String, String> data, Map<String, String> header) {
        ReqConfig cfg = this.config.clone();
        cfg.setConnectTimeout(60000).setSocketTimeout(60000);
        return this.request(PATCH, url, header, data, cfg);
    }

    public RedfishResult executePost(String url, String dataJson) {
        return this.request(POST, url, "", dataJson, null);
    }

    public RedfishResult executePost(String url, Map<String, String> data, Map<String, String> header) {
        ReqConfig cfg = this.config.clone();
        cfg.setConnectTimeout(60000).setSocketTimeout(60000);
        return this.request(POST, url, header, data, cfg);
    }

    public RedfishResult executePost(String url, Map<String, String> data, Map<String, String> header, ReqConfig cfg) {
        return this.request(POST, url, header, data, cfg);
    }

    public void release() {
        try {
            if (this.isRequestToken) {
                this.connAttrService.releaseSessionWithToken(this, this.authTokenId);
            }
            StreamUtils.closeResource(null, (Closeable)this.client);
        }
        catch (Exception e) {
            LOGGER.error("release connection error.", e);
        }
    }

    public RedfishResult executePost(String url, String data, String header, ReqConfig cfg) {
        return this.request(POST, url, header, data, cfg);
    }

    public String toString() {
        return "RedfishConnestion{, destIp='" + this.destIp + '\'' + ", destPort='" + this.destPort + '\'' + ", eTag='" + this.eTag + '\'' + '}';
    }
}

