/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.uMate.common.ssh;

import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.uMate.common.SystemConfig;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ServerEndJudge {
    public static final String ACTIVE_IBMC = "Active iBMC";
    public static final String IBMC = "iBMC";
    public static final List<String> NOT_END_COMMANDS = Collections.unmodifiableList(Arrays.asList("smmget -l swi(.*) -d sel", "smmget -l blade(.*) -d sel", "\r\n", "ipmcget -d sel -v list"));
    private static final List<String> DFT_END_JUDGE = Collections.unmodifiableList(Arrays.asList(".*@.*:/#", "user name:", "PassWord:", "choice:", "COM#(1", "(Y|N):", "login:", "<.*>", "Password:", "-- More", "[Y/N]:", "Press ENTER to get started.", "Enter Password:", "Confirm Password:", "Error: The password is invalid.", "~ #", "@SMM:/#", "Your account is locked", "the login rule is not met.", "linux", "iMana", "$", "iBMC:/->", "Input"));
    private static final Set<String> DFT_CONTAIN_JUDGE = new HashSet<String>();
    private static final String[] DFT_END_REGIX_JUDGE = new String[]{"[\\s\\S]*FC.*_.*:.*>", "[\\s\\S]*\\[Y/N\\]:", "\\[.*\\]", "(Y\\|N):", "[\\s\\S]*iBMC:/->", "[\\s\\S]*Hi1710[\\s\\S]*\\$", "[\\s\\S]*@.*:.*>", "[\\s\\S]*Hi1710.*\\$", "user name:", "PassWord:", "choice:", "COM#\\(1", "\\(Y\\|N\\):", "login:", "<.*>", "\\[.*\\]", "Password:", "-- More", ".*FC.*_.*:.*>", ".*\\[Y/N\\]\\s*:", "Press ENTER to get started.", "Enter Password:", "Confirm Password:", "Error: The password is invalid.", ".*iBMC:/->", "Please input the username:", "Enter password:", "sftp-client>", "User\\(.*\\):", "OK to proceed\\? \\(yes, y, no, n\\): \\[no\\].*", "Host IP or Host Name:", "User Name:", "Protocol \\(scp \\| sftp\\):", "Remote Directory:", "SupportSave.*", "\\(y/n\\)", "ftp or sftp.*", "Login name:", "Enter host password for user.*", "Enter address.*(IPv4 or IPv6).*", "Enter a valid remote directory path.*", "IP Address/Hostname.*", "Eth.*\\[.*\\].*:", "activate this system setup.*\\(y/n\\):", "Fibre.*\\[.*\\].*:", "Gateway.*\\[.*\\].*:", "DHCP\\[.*\\].*:", ".*Use Control-C to exit.*", "R/D/E", "The currently logged user's passwd:", "Debug Shell[\\s\\S]*%", "LifeThres[\\s\\S]*%"};
    private static final String[] DFT_END_OS_JUDGE = new String[]{"linux.*:.*#", "root@", ".+Your Choice \\[.+\\]>", "Hit the Enter key to continue", "iMana", ".*@.*:/#", "~ #", "/tmp.*#", ".*@.*:.*>", "\\[.*\\]\\$", "\\[.*\\]\\#", ".*@.*:.*\\$", ".*bash-.*\\$", "Password:", "\u53e3\u4ee4\uff1a", "\u5bc6\u7801\uff1a", ".*:.*#", ".*:.*>", "\\$.*", ".*\\[.*\\]:", "R/D/E"};
    private static final String[] SPECFIC_END_JUDGE = ServerEndJudge.getSpecficJudge();

    private static String[] getSpecficJudge() {
        String spec = SystemConfig.createSystemConfig().getConfigVlaue("end_symbols");
        if (spec == null || spec.length() == 0) {
            return new String[0];
        }
        return spec.split(",");
    }

    public static boolean isSshFinish(String cmdResult, String expect, String cmd, String[] endKeyWhitelist) {
        int idx = cmdResult.indexOf("\n");
        if (idx < 0) {
            return false;
        }
        String sub = cmdResult.substring(idx).trim();
        if (!StringUtils.isNULLStr((String)expect)) {
            return ServerEndJudge.isContainsRegex(expect, sub);
        }
        for (String string : DFT_END_REGIX_JUDGE) {
            Pattern wp;
            Matcher matcher;
            if (endKeyWhitelist != null && Arrays.asList(endKeyWhitelist).contains(string) || !(matcher = (wp = Pattern.compile(string, 34)).matcher(sub)).find()) continue;
            return true;
        }
        for (String endSt : DFT_CONTAIN_JUDGE) {
            if (!sub.contains(endSt)) continue;
            return true;
        }
        for (String endJudge : DFT_END_JUDGE) {
            if (!sub.contains(endJudge)) continue;
            return true;
        }
        for (String string : DFT_END_OS_JUDGE) {
            if (endKeyWhitelist != null && Arrays.asList(endKeyWhitelist).contains(string) || !sub.matches(string) && !sub.contains(string) && !ServerEndJudge.isContainsRegex(string, sub)) continue;
            return true;
        }
        if (ServerEndJudge.isCommandEnd(cmd) && ServerEndJudge.isOSContainsIbmc(sub)) {
            return true;
        }
        for (String string : SPECFIC_END_JUDGE) {
            if (!sub.contains(string)) continue;
            return true;
        }
        return false;
    }

    private static boolean isCommandEnd(String cmd) {
        boolean isNotEndCommands = true;
        for (String endJudge : NOT_END_COMMANDS) {
            Pattern wp = Pattern.compile(endJudge, 34);
            Matcher matcher = wp.matcher(cmd);
            if (!matcher.find()) continue;
            isNotEndCommands = false;
        }
        return isNotEndCommands;
    }

    private static boolean isContainsRegex(String expect, String sub) {
        Pattern wp = Pattern.compile(expect);
        Matcher matcher = wp.matcher(sub);
        return matcher.find();
    }

    private static boolean isOSContainsIbmc(String sub) {
        boolean noActiveiBMC = !sub.trim().matches(ACTIVE_IBMC) && !sub.trim().contains(ACTIVE_IBMC);
        boolean hasiBMC = sub.trim().matches(IBMC) || sub.trim().contains(IBMC);
        return noActiveiBMC && hasiBMC;
    }

    public void addEndJudge(String[] endStr) {
        Collections.addAll(DFT_CONTAIN_JUDGE, endStr);
    }
}

