/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.uMate.common.utils;

import com.huawei.uMate.common.log.Logger;
import org.apache.commons.lang3.StringUtils;

public class VersionCompartor {
    private static final Logger LOGGER = new Logger(VersionCompartor.class);
    public static final String VER_SEP = "\\.";

    public static boolean isVersionInRange(String currentVersion, String startVersion, String endVersion) {
        return VersionCompartor.isVersionInRange(currentVersion, startVersion, endVersion, false);
    }

    public static boolean isVersionInRanges(String currentVersion, String startVersion, String endVersion) {
        return VersionCompartor.isVersionInRange(currentVersion, startVersion, endVersion, true);
    }

    public static boolean isVersionInRange(String currentVersion, String startVersion, String endVersion, boolean isIncludeEdge) {
        if (StringUtils.isEmpty(startVersion) || StringUtils.isEmpty(startVersion) && StringUtils.isEmpty(endVersion)) {
            return false;
        }
        String[] verInfo = currentVersion.split(VER_SEP);
        boolean isInRange = VersionCompartor.compareStart(currentVersion, startVersion, verInfo, isIncludeEdge);
        return isInRange &= VersionCompartor.compareEnd(currentVersion, endVersion, verInfo, isIncludeEdge);
    }

    private static boolean compareEnd(String currentVersion, String endVersion, String[] verInfo, boolean isIncludeEdge) {
        boolean isInRange = true;
        if (endVersion != null) {
            String[] verInfoEnd = endVersion.split(VER_SEP);
            if (verInfo.length == verInfoEnd.length) {
                isInRange = currentVersion.compareTo(endVersion) < 0;
            } else {
                boolean bl = isInRange = verInfo.length < verInfoEnd.length;
            }
            if (isIncludeEdge) {
                isInRange = isInRange || currentVersion.equals(endVersion);
            }
        }
        return isInRange;
    }

    private static boolean compareStart(String currentVersion, String startVersion, String[] verInfo, boolean isIncludeEdge) {
        boolean isInRange = true;
        if (startVersion != null) {
            String[] verInfoStart = startVersion.split(VER_SEP);
            if (verInfo.length == verInfoStart.length) {
                isInRange = currentVersion.compareTo(startVersion) > 0;
            } else {
                boolean bl = isInRange = verInfo.length > verInfoStart.length;
            }
            if (isIncludeEdge) {
                isInRange = isInRange || currentVersion.equals(startVersion);
            }
        }
        return isInRange;
    }

    public static boolean isVersionGreaterThan(String currentVersion, String targetVersion) {
        return VersionCompartor.isVersionInRange(currentVersion, targetVersion, null, false);
    }

    public static boolean isVersionGTEQWith(String currentVersion, String targetVersion) {
        return VersionCompartor.isVersionInRange(currentVersion, targetVersion, null, true);
    }

    public static boolean isVersionLowerThan(String currentVersion, String targetVersion) {
        return VersionCompartor.isVersionInRange(targetVersion, currentVersion, null, false);
    }

    public static boolean isVersionLTEQWith(String currentVersion, String targetVersion) {
        return VersionCompartor.isVersionInRange(targetVersion, currentVersion, null, true);
    }
}

