/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.protocol.factory;

import com.huawei.ism.tool.framework.pubservice.entity.DevNode;
import com.huawei.ism.tool.obase.connection.ICliConnection;
import com.huawei.ism.tool.obase.connection.SshConnectionManager;
import com.huawei.ism.tool.obase.entity.EntityUtils;
import com.huawei.ism.tool.obase.exception.ToolException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SshForwardConnector {
    private static final Logger LOGGER = LoggerFactory.getLogger(SshForwardConnector.class);
    private DevNode dev;

    public SshForwardConnector(DevNode dev2) {
        this.dev = dev2;
    }

    public ICliConnection getConnection() throws ToolException {
        com.huawei.ism.tool.obase.entity.DevNode devBase = EntityUtils.toOldDev(this.dev);
        return SshConnectionManager.getSshConnection(devBase, null, false, false);
    }

    public ICliConnection getConnectionForPwdWillExpireBreak() throws ToolException {
        com.huawei.ism.tool.obase.entity.DevNode devBase = EntityUtils.toOldDev(this.dev);
        return SshConnectionManager.getSshConnection(devBase, null, true, false);
    }

    public ICliConnection getConnectionNoException() {
        ICliConnection sshConn = null;
        com.huawei.ism.tool.obase.entity.DevNode devBase = EntityUtils.toOldDev(this.dev);
        try {
            sshConn = SshConnectionManager.getSshConnection(devBase, null, false, false);
        }
        catch (ToolException e) {
            LOGGER.error("Create SSH connection Failed: " + e);
            return null;
        }
        return sshConn;
    }

    public ICliConnection getConnectionForPwdWillExpireBreakNoException() {
        ICliConnection sshConn = null;
        com.huawei.ism.tool.obase.entity.DevNode devBase = EntityUtils.toOldDev(this.dev);
        try {
            sshConn = SshConnectionManager.getSshConnection(devBase, null, true, false);
        }
        catch (ToolException e) {
            LOGGER.error("Create SSH connection Failed: " + e);
            return null;
        }
        return sshConn;
    }
}

