/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.protocol.rest;

import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.utils.ApplicationContext;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.tool.protocol.rest.RestConnection;
import com.huawei.ism.tool.protocol.rest.RestConnectionManager;
import com.huawei.ism.tool.protocol.rest.entity.RequestInfo;
import com.huawei.ism.tool.protocol.rest.entity.ResponseInfo;
import com.huawei.ism.tool.protocol.utils.RestUtil;
import com.huawei.ism.tool.safe.SensitiveInfoFilter;
import com.huawei.json.JSONException;
import com.huawei.json.JSONObject;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CyberEngineRestConnection
extends RestConnection {
    private static final Logger log = LoggerFactory.getLogger(CyberEngineRestConnection.class);
    public static final int REST_CONN_PORT = 25081;
    private static final String QUERY_DEV_TYPE_INFO_URI = "version";
    private static final String QUERY_DEV_ESN = "system/esn";
    private static final List<String> NEED_RE_LOGIN_ERROR_CODE = Collections.unmodifiableList(Arrays.asList("04040183", "2099465"));

    public CyberEngineRestConnection(DevNode devNode) {
        super(devNode);
        String ip = RestUtil.processIPByURL(devNode.getIp());
        this.uri = String.format("https://%s:%s/v1/auth/token", ip, 25081);
    }

    @Override
    public String getBaseUrl() {
        String ip = RestUtil.processIPByURL(this.devNode.getIp());
        return String.format("https://%s:%s/v1/", ip, 25081);
    }

    public String getQueryDevTypeInfoUrl() {
        return this.getBaseUrl() + QUERY_DEV_TYPE_INFO_URI;
    }

    public String getQueryDevEsnUrl() {
        return this.getBaseUrl() + QUERY_DEV_ESN;
    }

    @Override
    public void logOut() {
    }

    @Override
    public void closeSession() {
        super.closeSession();
        RestConnectionManager.releaseContainerRestConnection(this.devNode);
    }

    @Override
    protected void setLoginParam(RequestInfo req) {
        req.addParam("userName", this.devNode.getLoginUser().getUserName());
        req.addParam("password", this.devNode.getLoginUser().getPassword());
        req.setHeader("Content-Type", "application/json");
    }

    @Override
    protected void createHeader(RequestInfo req, Map headerParam) {
        req.setHeader("X-Auth-Token", this.session.getToken());
        req.setHeader("Content-Type", "application/json");
        req.setHeader("Accept-Language", ApplicationContext.getInstance().getCurrentLanguage().getLanguage());
    }

    @Override
    protected boolean checkLoginResult(ResponseInfo resp) {
        if (resp == null) {
            return false;
        }
        String content = resp.getContent();
        if (StringUtils.isNULLStr(content)) {
            return false;
        }
        JSONObject json = new JSONObject(content);
        String errorCode = this.getJsonValue("errorCode", json);
        String token = this.getJsonValue("token", json);
        if (!StringUtils.isNULLStr(errorCode) && !errorCode.equals("0") || StringUtils.isNULLStr(token)) {
            log.info("login failed,resp={}", (Object)SensitiveInfoFilter.filter(content));
            return false;
        }
        this.session.setToken(token);
        return true;
    }

    @Override
    public boolean isNeedReLogin(ResponseInfo resp) {
        String content = resp.getContent();
        if (StringUtils.isNULLStr(content)) {
            return false;
        }
        JSONObject json = new JSONObject(content);
        try {
            JSONObject error = json.getJSONObject("errorCode");
            return error != null && NEED_RE_LOGIN_ERROR_CODE.contains(error);
        }
        catch (JSONException e) {
            log.error("dpa json parse error");
            return false;
        }
    }
}

