/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.protocol.rest;

import com.huawei.ism.tool.base.utils.FilePathUtils;
import com.huawei.ism.tool.base.utils.FileUtils;
import com.huawei.ism.tool.base.utils.StreamUtils;
import com.huawei.ism.tool.certbase.ssl.MyTrustSslSocketFactoryTool;
import com.huawei.ism.tool.channel.utils.HttpsPropUtils;
import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import com.huawei.ism.tool.framework.pubservice.exception.EncapsulatedRuntimeException;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.tool.protocol.rest.DownFileObserver;
import com.huawei.ism.tool.protocol.rest.MyCustSSLSocketFactory;
import com.huawei.ism.tool.protocol.rest.entity.RequestInfo;
import com.huawei.ism.tool.protocol.rest.entity.ResponseInfo;
import com.huawei.ism.tool.protocol.rest.entity.UnsupProtocolException;
import com.huawei.ism.tool.protocol.utils.RestUtil;
import com.huawei.ism.tool.safe.SensitiveInfoFilter;
import com.huawei.ism.tool.sdk.unified.log.filter.LogFilterMark;
import com.huawei.json.JSONException;
import com.huawei.json.JSONObject;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.lang3.StringUtils;
import org.apache.hc.client5.http.ClientProtocolException;
import org.apache.hc.client5.http.HttpRequestRetryStrategy;
import org.apache.hc.client5.http.auth.CredentialsProvider;
import org.apache.hc.client5.http.classic.methods.HttpUriRequestBase;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.cookie.BasicCookieStore;
import org.apache.hc.client5.http.cookie.CookieStore;
import org.apache.hc.client5.http.impl.auth.BasicCredentialsProvider;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.protocol.RedirectStrategy;
import org.apache.hc.client5.http.ssl.NoopHostnameVerifier;
import org.apache.hc.client5.http.ssl.SSLConnectionSocketFactory;
import org.apache.hc.client5.http.utils.DateUtils;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.HttpResponseInterceptor;
import org.apache.hc.core5.http.NoHttpResponseException;
import org.apache.hc.core5.http.ParseException;
import org.apache.hc.core5.http.URIScheme;
import org.apache.hc.core5.http.config.Registry;
import org.apache.hc.core5.http.config.RegistryBuilder;
import org.apache.hc.core5.http.io.EofSensorInputStream;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.message.BasicHeader;
import org.apache.hc.core5.http.message.StatusLine;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.pool.PoolConcurrencyPolicy;
import org.apache.hc.core5.pool.PoolReusePolicy;
import org.apache.hc.core5.ssl.SSLContexts;
import org.apache.hc.core5.ssl.TrustStrategy;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.TimeValue;
import org.apache.hc.core5.util.Timeout;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public class HttpSession {
    private static final String RIGHT_BRACKET = "]";
    private static final String LEFT_BRACKET = "[";
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(HttpSession.class);
    private static final int MAX_TOTOL_CON_NUM = 50;
    private static final int MAX_DEFAULT_CON_NUM = 20;
    private static final int READ_DATA_TIME_OUT = 300000;
    private static final int TIME_OUT_UNIT = 1000;
    private static final int MAX_TIME = 8192;
    private static final int HTTP_CONNECT_TIMEOUT = 30;
    private static final int HTTP_CONNECTION_REQUEST_TIMEOUT = 30;
    private static final int DOWN_BUFFER = 8192;
    private CloseableHttpClient httpClient;
    private String sessionID;
    private String token;
    private static HttpClientConnectionManager httpsManager = HttpSession.getHttpsManager();
    private static final String CONNECT_TIME_TO_LIVE = "tool.cert.connect.livetime";
    private static final TimeValue DEFAULT_CONNECT_TIME_TO_LIVE = TimeValue.of((long)5L, (TimeUnit)TimeUnit.MINUTES);
    private CookieStore cookieStore;
    private RequestConfig defaultRequestConfig;

    public HttpSession() {
    }

    private HttpSession(DevNode devNode, CookieStore cookieStore) throws NoSuchAlgorithmException, KeyManagementException, CertificateException, KeyStoreException {
        this(devNode, cookieStore, null);
    }

    private HttpSession(DevNode devNode, CookieStore cookieStore, HttpResponseInterceptor processor) throws NoSuchAlgorithmException, KeyManagementException, CertificateException, KeyStoreException {
        this.cookieStore = cookieStore;
        this.httpClient = this.getHttpsClient(devNode, processor);
        LOGGER.info("HttpClient is created successfully.");
    }

    public void setReadDataTimeout(int timeout) {
        this.defaultRequestConfig = RestUtil.buildRequestConfig(timeout);
    }

    public static HttpSession createNewSession(DevNode devNode) throws CertificateException {
        return HttpSession.createNewSession(devNode, (CookieStore)new BasicCookieStore());
    }

    public static HttpSession createNewSession(DevNode devNode, CookieStore cookieStore) throws CertificateException {
        return HttpSession.createNewSession(devNode, cookieStore, null);
    }

    public static HttpSession createNewSession(DevNode devNode, CookieStore cookieStore, HttpResponseInterceptor processor) throws CertificateException {
        try {
            return new HttpSession(devNode, cookieStore, processor);
        }
        catch (KeyManagementException e) {
            LOGGER.error("Key Management error.", (Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            LOGGER.error("No Such Algorithm error.", (Throwable)e);
        }
        catch (KeyStoreException e) {
            LOGGER.error("Key Store error.", (Throwable)e);
        }
        return null;
    }

    public static void closeSession(HttpSession session) {
        if (null != session) {
            session.close();
        }
    }

    public String getSessionID() {
        return this.sessionID;
    }

    public void setSessionID(String sessionID) {
        this.sessionID = sessionID;
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public ResponseInfo sendRequest1(RequestInfo req, boolean isLogging) throws IOException {
        return this.sendRequest1(req, isLogging, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResponseInfo sendRequest1(RequestInfo req, boolean isLogging, DownFileObserver downFileObserver) throws IOException {
        CloseableHttpResponse response = null;
        try {
            response = this.execRequest(req, isLogging);
        }
        catch (Exception e) {
            LOGGER.error("send cmd error:", (Throwable)e);
            throw e;
        }
        HttpEntity entity = response.getEntity();
        ContentType contentType = ContentType.parse((CharSequence)entity.getContentType());
        String type = contentType == null ? "" : contentType.getMimeType();
        ResponseInfo respInfo = new ResponseInfo();
        respInfo.setHeaders(response.getHeaders());
        respInfo.setLocale(response.getLocale());
        respInfo.setStatusLine(new StatusLine((HttpResponse)response));
        respInfo.setContentType(type);
        if (StringUtils.containsAny((CharSequence)type, (CharSequence[])new CharSequence[]{"7z", "zip", "octet-stream"})) {
            return this.getBinResponseInfo(response, respInfo, req.getLocationPath(), downFileObserver);
        }
        InputStreamReader inputStreamReader = null;
        BufferedReader bufferedReader = null;
        StringBuilder entityStringBuilder = null;
        String line = null;
        try {
            if (null != type) {
                if (type.indexOf("text/html") >= 0) {
                    respInfo.setContent(EntityUtils.toString((HttpEntity)entity));
                } else {
                    inputStreamReader = new InputStreamReader(response.getEntity().getContent(), "UTF-8");
                    bufferedReader = new BufferedReader(inputStreamReader, 8192);
                    entityStringBuilder = new StringBuilder();
                    while ((line = bufferedReader.readLine()) != null) {
                        entityStringBuilder.append(line);
                        respInfo.setContent(line);
                        respInfo.getContentMap().put("lastLine", line);
                    }
                    respInfo.setContent(entityStringBuilder.toString());
                }
            }
            respInfo = this.parseResponse(respInfo);
        }
        catch (ParseException e) {
            LOGGER.error("Parse response error.", (Throwable)e);
        }
        finally {
            StreamUtils.closeResource(null, inputStreamReader);
            StreamUtils.closeResource(null, bufferedReader);
        }
        return respInfo;
    }

    private ResponseInfo getBinResponseInfo(CloseableHttpResponse response, ResponseInfo respInfo, String locationDir, DownFileObserver downFileObserver) throws IOException {
        Header fileHeader = response.getFirstHeader("Content-Disposition");
        String locDir = com.huawei.ism.tool.obase.utils.ApplicationContext.getInstance().getTmpPath();
        if (!com.huawei.ism.tool.base.utils.StringUtils.isNULLStr((String)locationDir)) {
            File file = new File(locationDir);
            if (!file.exists()) {
                boolean makeDirsResult = file.mkdirs();
                LOGGER.info("create location dir {}, result {}", (Object)locationDir, (Object)makeDirsResult);
            }
            locDir = locationDir;
        }
        String filename = HttpSession.getFileName(fileHeader);
        String path = locDir + File.separator + filename;
        File resourceZipFile = FilePathUtils.checkFile((File)new File(path));
        LOGGER.info("downloading file {} to {}", (Object)filename, (Object)locDir);
        try (BufferedInputStream fis = new BufferedInputStream(response.getEntity().getContent());
             OutputStream fos = Files.newOutputStream(resourceZipFile.toPath(), new OpenOption[0]);){
            this.download(downFileObserver, fis, fos, response);
            respInfo.getContentMap().put(path, resourceZipFile.getCanonicalPath());
            respInfo.getContentMap().put("filePath", path);
        }
        catch (IOException e) {
            LOGGER.error("download file {} failed", (Object)resourceZipFile, (Object)e);
            throw e;
        }
        return respInfo;
    }

    private static String getFileName(@NotNull Header fileHeader) {
        return FileUtils.getFileName((String)fileHeader.getValue().split(fileHeader.getValue().contains("fileName=") ? "fileName=" : "filename=")[1]);
    }

    private void download(DownFileObserver downFileObserver, InputStream fis, OutputStream fos, CloseableHttpResponse response) throws IOException {
        int readLen = -1;
        byte[] buffer = new byte[8192];
        if (downFileObserver == null) {
            while (-1 != (readLen = fis.read(buffer))) {
                fos.write(buffer, 0, readLen);
            }
        } else {
            downFileObserver.init(response.getEntity().getContentLength(), new Date().getTime());
            while (-1 != (readLen = fis.read(buffer))) {
                fos.write(buffer, 0, readLen);
                downFileObserver.addSize(readLen);
            }
        }
    }

    public ResponseInfo parseResponse(ResponseInfo resp) {
        String content = resp.getContent();
        if (content == null || content.isEmpty()) {
            return resp;
        }
        Object dataObj = null;
        JSONObject errCodeJson = null;
        try {
            JSONObject json = this.getJsonContent(resp);
            if (json.has("error")) {
                errCodeJson = json.getJSONObject("error");
            } else if (json.has("result")) {
                Object obj = json.get("result");
                if (obj instanceof JSONObject) {
                    errCodeJson = (JSONObject)obj;
                }
            } else if (json.has("errorCode")) {
                errCodeJson = json;
            }
            this.parseErrorCodeJson(errCodeJson, resp);
            if (json.has("data")) {
                dataObj = json.get("data");
                resp.getContentMap().put("data", dataObj);
                if (dataObj instanceof JSONObject) {
                    this.parseJson2Map(resp, (JSONObject)dataObj);
                }
            }
        }
        catch (JSONException e) {
            LOGGER.error("json parse exception :" + (Object)((Object)e));
            LOGGER.error("response content: " + content);
            return resp;
        }
        return resp;
    }

    private JSONObject getJsonContent(ResponseInfo resp) {
        try {
            JSONObject ret = new JSONObject(resp.getContent());
            return ret;
        }
        catch (JSONException e) {
            LOGGER.error("ret parse exception :" + (Object)((Object)e));
            JSONObject ret = new JSONObject(resp.getContentMap().get("lastLine"));
            return ret;
        }
    }

    private void parseErrorCodeJson(JSONObject errCodeJson, ResponseInfo resp) {
        if (null == errCodeJson || null == resp || null == resp.getContentMap()) {
            return;
        }
        if (errCodeJson.has("code")) {
            resp.getContentMap().put("errorCode", errCodeJson.getLong("code"));
        }
        if (errCodeJson.has("errorCode")) {
            resp.getContentMap().put("errorCode", errCodeJson.getLong("errorCode"));
        }
        if (errCodeJson.has("description")) {
            resp.getContentMap().put("description", errCodeJson.get("description"));
        }
        if (errCodeJson.has("suggestion")) {
            resp.getContentMap().put("suggestion", errCodeJson.get("suggestion"));
        }
    }

    private void parseJson2Map(ResponseInfo resp, JSONObject jsonData) {
        if (null == jsonData) {
            return;
        }
        Iterator nameItr = jsonData.keys();
        while (nameItr.hasNext()) {
            String name = (String)nameItr.next();
            resp.getContentMap().put(name, jsonData.get(name));
        }
    }

    public ResponseInfo sendRequest(RequestInfo req) throws IOException {
        CloseableHttpResponse response = this.execRequest(req, true);
        HttpEntity entity = response.getEntity();
        ContentType contentType = ContentType.parse((CharSequence)entity.getContentType());
        String type = contentType == null ? "" : contentType.getMimeType();
        ResponseInfo respInfo = new ResponseInfo();
        respInfo.setHeaders(response.getHeaders());
        respInfo.setLocale(response.getLocale());
        respInfo.setStatusLine(new StatusLine((HttpResponse)response));
        respInfo.setContentType(type);
        if (null != type && type.indexOf("text") >= 0) {
            try {
                respInfo.setContent(EntityUtils.toString((HttpEntity)entity));
            }
            catch (ParseException e) {
                LOGGER.error("Parse response error.", (Throwable)e);
            }
        } else {
            this.abortReading(entity.getContent());
        }
        return respInfo;
    }

    public CloseableHttpResponse execRequest(RequestInfo req, boolean isLogging) throws IOException {
        try {
            HttpUriRequestBase uriRequest = req.toHttpUriRequest();
            if (this.defaultRequestConfig != null) {
                uriRequest.setConfig(this.defaultRequestConfig);
            }
            LOGGER.info("Sending {} request to {} ... ", (Object)uriRequest.getMethod(), (Object)req.getURL());
            if (isLogging) {
                LOGGER.info("request header is: {}", (Object)SensitiveInfoFilter.filter(req.getHeaderString()));
            }
            CloseableHttpResponse resp = this.httpClient.execute((ClassicHttpRequest)uriRequest);
            LOGGER.info("Received {} response successfully from {}.", (Object)uriRequest.getMethod(), (Object)req.getURL());
            return resp;
        }
        catch (ClientProtocolException e) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Unsupported protocol: " + req.getURL() + ".", (Throwable)e);
            }
            throw new UnsupProtocolException(e);
        }
        catch (IOException e) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Failed to receive response from " + req.getURL() + ".", (Throwable)e);
            }
            throw e;
        }
    }

    private void abortReading(InputStream in) throws IOException {
        if (in instanceof EofSensorInputStream) {
            try {
                ((EofSensorInputStream)in).abort();
            }
            catch (Exception e) {
                LOGGER.error("Exception happened in :", (Throwable)e);
            }
            try {
                ((EofSensorInputStream)in).close();
            }
            catch (Exception e) {
                LOGGER.error("Exception happened in :", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String sentHttpRequest(boolean isHttpsConnection, RequestInfo req, int timeOut, int retryTimes) throws ToolException {
        String string;
        CloseableHttpResponse closeableHttpResponse = null;
        CloseableHttpClient closeableHttpclient = null;
        HttpEntity httpEntity = null;
        try {
            closeableHttpclient = isHttpsConnection ? HttpSession.createHttpsClient() : HttpClients.createDefault();
            HttpUriRequestBase httpRequest = null;
            httpRequest = req.toHttpUriRequest();
            httpRequest.setConfig(RequestConfig.custom().setConnectTimeout(Timeout.ofSeconds((long)(timeOut / 1000))).setConnectionRequestTimeout(Timeout.ofSeconds((long)(timeOut / 1000))).build());
            closeableHttpResponse = closeableHttpclient.execute((ClassicHttpRequest)httpRequest);
            httpEntity = closeableHttpResponse.getEntity();
            int status = closeableHttpResponse.getCode();
            if (status < 200 || status >= 300) {
                ToolException toolException = new ToolException();
                toolException.setDes("failed to connection");
                throw toolException;
            }
            String responseBody = EntityUtils.toString((HttpEntity)httpEntity, (String)"UTF-8");
            string = responseBody = responseBody == null ? "" : responseBody;
            EntityUtils.consumeQuietly((HttpEntity)httpEntity);
        }
        catch (IOException | ParseException e) {
            if (retryTimes <= 0) {
                ToolException toolException = new ToolException("failed to connection", e);
                throw toolException;
            }
            int newRetryTimes = retryTimes - 1;
            LOGGER.info("retry url:{} in {} seconds.", (Object)req.getURL(), (Object)3);
            HttpSession.silentSleep(3, TimeUnit.SECONDS);
            String string2 = HttpSession.sentHttpRequest(isHttpsConnection, req, timeOut, newRetryTimes);
            return string2;
        }
        try {
            if (closeableHttpclient == null) return string;
            closeableHttpclient.close();
            return string;
        }
        catch (IOException e) {
            LOGGER.error("failed to close closeableHttpclient. {}", (Throwable)e);
        }
        return string;
        finally {
            EntityUtils.consumeQuietly(httpEntity);
            try {
                if (closeableHttpclient != null) {
                    closeableHttpclient.close();
                }
            }
            catch (IOException e) {
                LOGGER.error("failed to close closeableHttpclient. {}", (Throwable)e);
            }
        }
    }

    public static CloseableHttpClient createHttpsClient() {
        return HttpClients.custom().setConnectionManager(httpsManager).setConnectionManagerShared(true).build();
    }

    private static HttpClientConnectionManager getHttpsManager() {
        SSLContext sslContext;
        LOGGER.info("init httpsManager once");
        TrustStrategy trustStrategy = HttpSession.getTrustStrategy();
        try {
            sslContext = SSLContexts.custom().loadTrustMaterial(null, trustStrategy).setProtocol("TLSv1.2").build();
        }
        catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException e) {
            throw new EncapsulatedRuntimeException("initSslsf error.");
        }
        SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
        Registry registry = RegistryBuilder.create().register("https", (Object)sslsf).build();
        PoolingHttpClientConnectionManager tmpCM = new PoolingHttpClientConnectionManager(registry);
        tmpCM.setMaxTotal(200);
        tmpCM.setDefaultMaxPerRoute(20);
        return tmpCM;
    }

    private static TrustStrategy getTrustStrategy() {
        TrustStrategy trustStrategy = new TrustStrategy(){

            public boolean isTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
                return true;
            }
        };
        return trustStrategy;
    }

    public static void silentSleep(int time, TimeUnit timeUnit) {
        try {
            timeUnit.sleep(time);
        }
        catch (InterruptedException e) {
            LOGGER.error("silentSleep error on:{}", (Throwable)e);
        }
    }

    public void close() {
        if (null != this.httpClient) {
            try {
                this.httpClient.close();
            }
            catch (IOException e) {
                LOGGER.error("HttpClient is closed error.", (Throwable)e);
            }
            this.sessionID = null;
        }
        LOGGER.info("HttpClient is closed successfully.");
    }

    public CloseableHttpClient getHttpsClient(DevNode devNode) throws NoSuchAlgorithmException, KeyManagementException, CertificateException, KeyStoreException {
        return this.getHttpsClient(devNode, null);
    }

    private CloseableHttpClient getHttpsClient(DevNode devNode, HttpResponseInterceptor processor) throws NoSuchAlgorithmException, KeyManagementException, CertificateException, KeyStoreException {
        TrustManager[] trustManagerArray;
        SSLContext sslcontext = SSLContext.getInstance("TLSv1.2");
        if (devNode.isVerifyCertificate()) {
            trustManagerArray = MyTrustSslSocketFactoryTool.getMySslX509TrustManager((String)this.getCertPath());
        } else {
            TrustManager[] trustManagerArray2 = new TrustManager[1];
            trustManagerArray = trustManagerArray2;
            trustManagerArray2[0] = new SimpleTrustManager();
        }
        sslcontext.init(null, trustManagerArray, SecureRandom.getInstanceStrong());
        MyCustSSLSocketFactory socketFactory = new MyCustSSLSocketFactory(sslcontext, devNode);
        Registry socketFactoryRegistry = RegistryBuilder.create().register(URIScheme.HTTP.id, (Object)socketFactory).register(URIScheme.HTTPS.id, (Object)socketFactory).build();
        PoolingHttpClientConnectionManager connManager = new PoolingHttpClientConnectionManager(socketFactoryRegistry, PoolConcurrencyPolicy.STRICT, PoolReusePolicy.LIFO, this.getConnectTimeToLive(), null, null, null);
        connManager.setDefaultMaxPerRoute(20);
        connManager.setMaxTotal(50);
        BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
        HttpClientBuilder httpClientBuilder = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connManager).setDefaultCookieStore(this.cookieStore).setDefaultCredentialsProvider((CredentialsProvider)credsProvider).setRedirectStrategy((RedirectStrategy)new NoRedirectStrategy()).setDefaultRequestConfig(RestUtil.buildRequestConfig()).setRetryStrategy((HttpRequestRetryStrategy)new RetryStrategy(5, TimeValue.ofSeconds((long)1L))).setDefaultHeaders(Collections.singletonList(new BasicHeader("User-Agent", (Object)"Apache-HttpClient")));
        if (processor != null) {
            httpClientBuilder.addResponseInterceptorFirst(processor);
        }
        return httpClientBuilder.build();
    }

    public CloseableHttpClient createSSLClientWithTwoWayAuth(DevNode devNode, String PFXFile, String clientCertPassword) throws NoSuchAlgorithmException, KeyManagementException, CertificateException, KeyStoreException, ToolException {
        SSLContext sslcontext = SSLContext.getInstance("TLSv1.2");
        sslcontext.init(HttpSession.getKeyManagers(clientCertPassword, PFXFile), MyTrustSslSocketFactoryTool.getMySslX509TrustManager((String)this.getCertPath()), SecureRandom.getInstanceStrong());
        MyCustSSLSocketFactory socketFactory = new MyCustSSLSocketFactory(sslcontext, devNode);
        Registry socketFactoryRegistry = RegistryBuilder.create().register(URIScheme.HTTPS.id, (Object)socketFactory).build();
        PoolingHttpClientConnectionManager connManager = new PoolingHttpClientConnectionManager(socketFactoryRegistry, PoolConcurrencyPolicy.STRICT, PoolReusePolicy.LIFO, this.getConnectTimeToLive(), null, null, null);
        connManager.setDefaultMaxPerRoute(20);
        connManager.setMaxTotal(50);
        BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
        HttpClientBuilder httpClientBuilder = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connManager).setDefaultCookieStore(this.cookieStore).setDefaultCredentialsProvider((CredentialsProvider)credsProvider).setRedirectStrategy((RedirectStrategy)new NoRedirectStrategy()).setDefaultRequestConfig(RestUtil.buildRequestConfig()).setRetryStrategy((HttpRequestRetryStrategy)new RetryStrategy(5, TimeValue.ofSeconds((long)1L))).setDefaultHeaders(Collections.singletonList(new BasicHeader("User-Agent", (Object)"Apache-HttpClient")));
        return httpClientBuilder.build();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static KeyManager[] getKeyManagers(String keyValue, String PFXFile) throws ToolException {
        if (com.huawei.ism.tool.base.utils.StringUtils.isNULLStr((String)keyValue)) {
            LOGGER.error("create KeyManagers error for password is NULL.");
            throw new ToolException("the PFX password is null.");
        }
        try (BufferedInputStream is = new BufferedInputStream(Files.newInputStream(Paths.get(PFXFile, new String[0]), new OpenOption[0]));){
            String alg = KeyManagerFactory.getDefaultAlgorithm();
            KeyManagerFactory factory = KeyManagerFactory.getInstance(alg);
            KeyStore ks = KeyStore.getInstance("pkcs12");
            ks.load(is, keyValue.toCharArray());
            factory.init(ks, keyValue.toCharArray());
            KeyManager[] keyManagerArray = factory.getKeyManagers();
            return keyManagerArray;
        }
        catch (Exception e) {
            LOGGER.error("Failed to load the certificate key, the PFX file and the password are incorrect.{}", (Object)LogFilterMark.INSENSITIVE, (Object)e);
            throw new ToolException("Failed to load the certificate key, the PFX file and the password are incorrect.", e);
        }
    }

    private TimeValue getConnectTimeToLive() {
        int minute;
        String valueFromConf = ApplicationContext.getInstance().getAppConfigNoExcept(CONNECT_TIME_TO_LIVE);
        if (valueFromConf == null) {
            return DEFAULT_CONNECT_TIME_TO_LIVE;
        }
        try {
            minute = Integer.parseInt(valueFromConf);
        }
        catch (NumberFormatException ex) {
            LOGGER.error("The connectTimeToLive value from config is invalid, use default instead.");
            return DEFAULT_CONNECT_TIME_TO_LIVE;
        }
        if (minute <= 0 && minute != -1 || minute > 300) {
            return DEFAULT_CONNECT_TIME_TO_LIVE;
        }
        return TimeValue.of((long)minute, (TimeUnit)TimeUnit.MINUTES);
    }

    private String getCertPath() {
        File certDir = new File(ApplicationContext.getInstance().getCurrWorkPath() + HttpsPropUtils.getCertFileDir());
        if (!certDir.exists() || !certDir.isDirectory()) {
            return "";
        }
        try {
            return certDir.getCanonicalPath();
        }
        catch (IOException e) {
            LOGGER.error("getCertPath error.");
            return "";
        }
    }

    public CloseableHttpClient getHttpClient() {
        return this.httpClient;
    }

    public CookieStore getCookieStore() {
        return this.cookieStore;
    }

    public static class RetryStrategy
    implements HttpRequestRetryStrategy {
        private static final int TOO_MANY_REQUESTS_STATUS = 429;
        private static final int SERVICE_UNAVAILABLE_STATUS = 503;
        private final int maxRetries;
        private final TimeValue defaultRetryInterval;
        private final Set<Integer> retriableCodes;

        protected RetryStrategy(int maxRetries, TimeValue defaultRetryInterval, Collection<Integer> codes) {
            Args.notNegative((int)maxRetries, (String)"maxRetries");
            Args.notNegative((long)defaultRetryInterval.getDuration(), (String)"defaultRetryInterval");
            this.maxRetries = maxRetries;
            this.defaultRetryInterval = defaultRetryInterval;
            this.retriableCodes = new HashSet<Integer>(codes);
        }

        public RetryStrategy(int maxRetries, TimeValue defaultRetryInterval) {
            this(maxRetries, defaultRetryInterval, Arrays.asList(429, 503));
        }

        public boolean retryRequest(HttpRequest httpRequest, IOException exception, int execCount, HttpContext httpContext) {
            if (execCount > this.maxRetries) {
                LOGGER.error("Retried {} times and reaches the upper limit.", (Object)execCount);
                return false;
            }
            if (exception instanceof NoHttpResponseException) {
                LOGGER.error("NoHttpResponseException occurred and retryed {} times", (Object)execCount);
                return true;
            }
            return false;
        }

        public boolean retryRequest(HttpResponse httpResponse, int execCount, HttpContext httpContext) {
            return execCount <= this.maxRetries && this.retriableCodes.contains(httpResponse.getCode());
        }

        public TimeValue getRetryInterval(HttpResponse httpResponse, int i, HttpContext httpContext) {
            TimeValue retryAfter;
            block4: {
                Header header = httpResponse.getFirstHeader("Retry-After");
                if (header == null) {
                    return this.defaultRetryInterval;
                }
                retryAfter = null;
                String value = header.getValue();
                try {
                    retryAfter = TimeValue.ofSeconds((long)Long.parseLong(value));
                }
                catch (NumberFormatException var9) {
                    LOGGER.error("The format of the delay response time is incorrect.");
                    Date retryAfterDate = DateUtils.parseDate((String)value);
                    if (retryAfterDate == null) break block4;
                    retryAfter = TimeValue.ofMilliseconds((long)(retryAfterDate.getTime() - System.currentTimeMillis()));
                }
            }
            if (TimeValue.isPositive((TimeValue)retryAfter)) {
                return retryAfter;
            }
            return this.defaultRetryInterval;
        }
    }

    private static class NoRedirectStrategy
    implements RedirectStrategy {
        private NoRedirectStrategy() {
        }

        public boolean isRedirected(HttpRequest httpRequest, HttpResponse httpResponse, HttpContext httpContext) throws HttpException {
            return false;
        }

        public URI getLocationURI(HttpRequest httpRequest, HttpResponse httpResponse, HttpContext httpContext) throws HttpException {
            return null;
        }
    }

    private static class SimpleTrustManager
    implements X509TrustManager {
        private SimpleTrustManager() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    }
}

