/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.protocol.rest;

import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.tool.protocol.rest.PostRequest;
import com.huawei.ism.tool.protocol.rest.entity.RequestInfo;
import com.huawei.ism.tool.protocol.rest.entity.UrlFormatException;
import com.huawei.json.JSONObject;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import org.apache.hc.client5.http.classic.methods.HttpPut;
import org.apache.hc.client5.http.classic.methods.HttpUriRequestBase;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PutRequest
extends RequestInfo {
    private static final Logger log = LoggerFactory.getLogger(PutRequest.class);
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(PostRequest.class);

    public PutRequest(String url) {
        super(url);
    }

    public PutRequest(String url, String encoding) {
        super(url, encoding);
    }

    @Override
    public HttpUriRequestBase getHttpUriRequest(String encoding) throws UrlFormatException {
        HttpPut httpPut;
        try {
            httpPut = new HttpPut(this.normalizeUrl(this.getURL()));
        }
        catch (IllegalArgumentException | URISyntaxException e) {
            log.error("Invalid url is: {} ", (Object)this.getURL());
            throw new UrlFormatException(e);
        }
        try {
            if (this.getParams().size() != 0) {
                JSONObject json = this.generateJson(this.getParams());
                httpPut.setEntity((HttpEntity)new StringEntity(json.toString(), Charset.forName(encoding)));
            }
        }
        catch (Exception e) {
            LOGGER.error("Url encoded form entity error.", (Throwable)e);
        }
        return httpPut;
    }
}

