/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.protocol.tlv.impl;

import com.huawei.ism.tlv.TLVUtils;
import com.huawei.ism.tlv.bean.Param;
import com.huawei.ism.tlv.bean.Record;
import com.huawei.ism.tlv.docoder.ParamType;
import com.huawei.ism.tlv.lang.IsmInteger;
import com.huawei.ism.tlv.lang.UnsignedInt32;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.tool.protocol.tlv.ShakeHandRunable;
import com.huawei.ism.tool.protocol.tlv.TLVConnectionImpl;
import com.huawei.ism.tool.protocol.tlv.exception.TLVException;
import com.huawei.ism.tool.protocol.tlv.impl.AbstractConnection;
import com.huawei.ism.util.NetUtil;
import java.util.List;
import java.util.Properties;
import org.slf4j.Logger;

public class MasterTlvConn
extends AbstractConnection {
    public static final long OM_OPCODE_USER_LOGOUT = 55847813122L;
    public static final long OM_OPCODE_USER_LOGIN = 55847813121L;
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(MasterTlvConn.class);
    private DevNode devNode;
    private String connectedIp;
    private String loginUser;
    private String userId;
    private boolean connected = false;

    public MasterTlvConn(DevNode devNode) {
        this.devNode = devNode;
        this.loginUser = devNode.getLoginUser().getUserName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        try {
            if (this.getOmConn() == null || !this.isConnected()) {
                return;
            }
            Param paramUserId = new Param(1, ParamType.STRING, this.userId);
            Param paramScope = new Param(71, ParamType.ENUM, (IsmInteger)new UnsignedInt32(0));
            List paramList = TLVUtils.paramList((Param[])new Param[]{paramUserId, paramScope});
            this.getOmConn().invoke(55847813122L, paramList);
            ToolLoggerFactory.getLogger(this.getClass()).info("close connection" + this.connectedIp + " finished");
        }
        catch (Exception e) {
            ToolLoggerFactory.getLogger(this.getClass()).error("", (Throwable)e);
        }
        finally {
            this.connected = false;
            if (null != this.getOmConn()) {
                this.getOmConn().close();
                this.setOmConn(null);
            }
        }
    }

    @Override
    public void connect() throws TLVException {
        Properties prop = new Properties();
        prop.put("USER_NAME", this.loginUser);
        String loginPwd = this.devNode.getLoginUser().getPassword();
        prop.put("USER_WORD", loginPwd);
        prop.put("PORT", "8080");
        prop.put("TIME_OUT_PROPERTY", "30");
        prop.put("CONN_PROTOCOL", "1");
        String masterIP = this.devNode.getIp();
        boolean isAuthenticate = this.authenticate(prop, masterIP);
        if (!isAuthenticate) {
            prop.put("CONN_PROTOCOL", "0");
            isAuthenticate = this.authenticate(prop, masterIP);
        }
        if (!isAuthenticate) {
            throw new TLVException("authenticate error.");
        }
        this.connected = true;
        Thread shakeHand = new Thread(new ShakeHandRunable(this, 55847813125L));
        shakeHand.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread thread, Throwable throwable) {
                LOGGER.error(thread.getName() + ":" + throwable.getMessage());
            }
        });
        shakeHand.setName("tlv-shakeHandThread-->" + this.connectedIp);
        shakeHand.start();
    }

    public void reConnect() throws TLVException {
        try {
            this.connect();
        }
        catch (TLVException te) {
            ToolLoggerFactory.getLogger(this.getClass()).error("reconnect to dev " + this.connectedIp + "error, throw exception", (Throwable)te);
            throw te;
        }
    }

    @Override
    public boolean isConnected() {
        return this.connected;
    }

    public boolean isSocketConnected() {
        TLVConnectionImpl tlvImpl = this.getOmConn();
        return tlvImpl != null && tlvImpl.isConnected();
    }

    private boolean authenticate(Properties prop, String ip) {
        String loginPwd;
        prop.put("IP_OR_NAME", ip);
        LOGGER.info("create standyby tlv connection ,cur props is: ip:{}", (Object)ip);
        this.setOmConn(new TLVConnectionImpl());
        if (null != this.devNode) {
            this.getOmConn().setSocks5Proxy(this.devNode.getSocks5Proxy());
            this.getOmConn().setSshForwardNodes(this.devNode.getSshForwardList());
        }
        this.getOmConn().setSessionKey(0L);
        try {
            this.getOmConn().init(prop);
        }
        catch (TLVException e) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error("create tlv connection to" + ip + "failed", (Throwable)e);
            }
            return false;
        }
        boolean authSuccess = false;
        if (null == this.devNode) {
            return authSuccess;
        }
        if (Integer.valueOf(prop.getProperty("CONN_PROTOCOL")) == 0) {
            loginPwd = this.devNode.getLoginUser().getPassword();
            authSuccess = this.authenticate(loginPwd, prop);
            LOGGER.info("create standyby tlv by no ssl no encrypt connection ,result is: {}", (Object)authSuccess);
        }
        if (Integer.valueOf(prop.getProperty("CONN_PROTOCOL")) == 1) {
            loginPwd = this.devNode.getLoginUser().getPassword();
            authSuccess = this.authenticate(loginPwd, prop);
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("create standyby tlv by ssl no encrypt connection ,result is: " + authSuccess);
            }
            loginPwd = null;
        }
        return authSuccess;
    }

    private boolean authenticate(String encryptPwd, Properties prop) throws TLVException {
        LOGGER.info("Begin connect to device by TLV.");
        try {
            String localIP = NetUtil.queryLocalIP((String)prop.getProperty("IP_OR_NAME"));
            Param paramUser = new Param(2, ParamType.STRING, this.loginUser);
            Param paramPass = new Param(65, ParamType.STRING, encryptPwd);
            Param paramLocalIp = new Param(67, ParamType.STRING, localIP);
            Param paramScope = new Param(71, ParamType.ENUM, (IsmInteger)new UnsignedInt32(0));
            List params = TLVUtils.paramList((Param[])new Param[]{paramUser, paramPass, paramLocalIp, paramScope});
            Record record = this.getOmConn().invoke(55847813121L, params);
            if (record == null) {
                LOGGER.error("connect to device by TLV failed. record is null.");
                return false;
            }
            this.userId = record.getParamStrValue(1);
            long sessKey = ((IsmInteger)record.getParamValue(68)).longValue();
            this.getOmConn().setSessionKey(sessKey);
        }
        catch (Exception e) {
            LOGGER.error("TLV authenticate exception.", (Throwable)e);
            return false;
        }
        LOGGER.info("Connect to device by TLV success.");
        return true;
    }
}

