# -*- coding: UTF-8 -*-

import functools

from com.huawei.ism.tool.devicepatch.utils import DevicePatchUtil
from com.huawei.ism.tool.obase.utils import ManualConfigItemMgr

INGORE_PRECHECK_CONFIG = "ignore.precheck.items"


def ignore_precheck(func):
    @functools.wraps(func)
    def wrapper(*args, **kw):
        check_res = func(*args, **kw)
        if check_res[0]:
            return check_res

        ignore_flag = IgnoreCheck(*args, **kw).ignore_precheck()
        if ignore_flag:
            return True, "", None
        return check_res
    return wrapper


class IgnoreCheck:
    """
    忽略补丁前检查项处理：检查项不通过时才需要调用该类，如果没用忽略检查项的配置，
    则需要在ignoreitem.txt文件增加配置；
    如果存在配置且为yes，则忽略所有检查项；
    """
    def __init__(self, data_dict):
        self.data_dict = data_dict
        self.log = self.data_dict.get("logger")
        self.dev = data_dict.get("dev")
        self.dev_ip = self.dev.getIp()

    def ignore_precheck(self):
        if not ManualConfigItemMgr.getInstance().getItem(
                self.dev_ip, INGORE_PRECHECK_CONFIG):
            ManualConfigItemMgr.getInstance().addItem(
                self.dev_ip, INGORE_PRECHECK_CONFIG, "no", "")
            self.log.info("ignore precheck config is none and add.")
            return False

        if ManualConfigItemMgr.getInstance().expected(
                self.dev_ip, INGORE_PRECHECK_CONFIG, "yes") \
                and self.ignore_choose():
            self.log.info("ignore precheck result is true.")
            return True

        return False

    def ignore_choose(self):
        choose = DevicePatchUtil.showIgnoreWarningDialog()
        # choose是用户选择的结果，True选择的“忽略”，False选择的是“取消”
        self.log.info("[precheck] User choose: %s." % str(choose))
        if choose:
            return True
        return False


def check_result(check_res, msg_list):
    if not check_res[0]:
        msg_list.append(check_res[1])
