# -*- coding: UTF-8 -*-

from com.huawei.ism.exception import IsmException
from com.huawei.ism.tlv import TLVUtils
from com.huawei.ism.tlv.bean import Param
from com.huawei.ism.tlv.docoder import ParamType
from com.huawei.ism.tlv.lang import UnsignedInt32
from com.huawei.ism.tool.protocol.tlv.cmds import CommandConstans
from com.huawei.ism.tool.protocol.tlv.exception import TLVException
from java.lang import Exception as JException

from cbb.frame.base import baseUtil
from cbb.frame.base import constants
from cbb.frame.base.constants import CMD_DEFAULT_TIMEOUT
from cbb.frame.util import CheckTypeMsg
from cbb.frame.util import checkUtils


# 执行入口
def execute(dataDict):
    return InstallPatchCheck().execute(dataDict)


class InstallPatchCheck():

    def __init__(self):
        pass

    def execute(self, dataDict):
        self.resource = dataDict.get("resource")
        self.logger = dataDict.get("logger")
        dataDict['checkType'] = "POSTCHECK"
        CheckTypeMsg.checkTypeMsg(dataDict)

        dev = dataDict.get("dev")
        supportUpgPatch = dev.isSupportUpgradingPatch()
        upgPatchPath = dev.getUpgradeSetInfo().getUpgPatchPackageFile().getPath()
        if not supportUpgPatch or upgPatchPath == None or upgPatchPath == "":
            return (True, "")
        ##执行升级后检查
        checkUtils.updateItemProgress(dataDict, "InstallPatchProgresCheck", 1)
        result = self.progressCheck(dataDict)
        checkUtils.updateItemProgress(dataDict, "InstallPatchProgresCheck", 100)
        # 删除上次显示的进度条信息
        checkUtils.updateMsgAferRetry(dataDict, "InstallPatchProgresCheck")
        self.updateUi(result, dataDict)
        return checkUtils.isAllItemsPassed(dataDict, dataDict['UI_POSTCHCK_UPDATE_MSG'], "postcheck")

    """
        查询升级检查项，并更新界面
    """

    def updateUi(self, rec, dataDict):
        resource = dataDict.get("resource")
        dev = dataDict.get("dev")
        uiObserver = dataDict.get("uiObserver")
        logger = dataDict.get("logger")
        UI_POSTCHCK_UPDATE_MSG = dataDict['UI_POSTCHCK_UPDATE_MSG']

        resState = rec[0]
        suggession = rec[1]
        logger.info("install patch result:%s" % (resState))

        if resState == True:
            # 补丁安装成功
            itemState = 3
            suggession = resource.getString("InstallPatchProgresCheck.pass")
        else:
            # 执行出错
            itemState = 4

        itemMsg = {
            "id": 0,
            ##检查项名称，类型String
            "name": resource.getString("InstallPatchProgresCheck"),
            ## 0等待检查, 1正在检查, 2警告, 3通过 ,4不通过
            "status": itemState,
            "ctrl": "ALL",
            ##修复建议
            "suggession": suggession
        }

        UI_POSTCHCK_UPDATE_MSG.get("checkitems").append(itemMsg)

        uiObserver.postMsg(dev, UI_POSTCHCK_UPDATE_MSG)

    def checkUpgradeStatusIsNomarl(self, status):
        """
        功能说明：检查升级中的状态是不是正常的
        输入：升级状态
        输出：bool检查结果False/True
        """
        ###检查升级状态是不是处于回退阶段
        if constants.OM_MSG_OP_UPD_LST_SYS_PROGRESS.UPD_ROLLBACKING == status or constants.OM_MSG_OP_UPD_LST_SYS_PROGRESS.UPD_ROLLBACK_SUCCESS == status or constants.OM_MSG_OP_UPD_LST_SYS_PROGRESS.UPD_ROLLBACK_FAIL == status or constants.OM_MSG_OP_UPD_LST_SYS_PROGRESS.UPD_UPD_FAIL == status:
            return False

        return True

    def checkUpgradeStatusIsUpgrade(self, status):
        """
        功能说明：检查升级中的状态是不是升级中和升级成功
        输入：升级状态
        输出：bool检查结果False/True
        """
        ###检查升级状态是否处于升级中和升级成功
        if constants.OM_MSG_OP_UPD_LST_SYS_PROGRESS.UPD_UPDING == status or constants.OM_MSG_OP_UPD_LST_SYS_PROGRESS.UPD_UPD_SUCCESS == status:
            return True
        return False

    """
        执行升级前检查，并更新界面
    """

    def progressCheck(self, dataDict):
        resource = dataDict.get("resource")
        logger = dataDict.get("logger")
        protocalContext = dataDict.get("protocalContext")
        tlvCon = protocalContext.get("TLV")

        dev = dataDict.get("dev")
        hotPathPkgVersion = dev.getUpgradeSetInfo().getUpgPatchPkgVersion()
        logger.info("[InstallPatchCheckWithTlv] hotPathPkgVersion:" + str(hotPathPkgVersion))

        status = None
        # 查询是否启动安装补丁（2分钟超时）
        BEFORE_PATCH_BASE_VALUE = 0
        while True:
            # 查询升级进度
            BEFORE_PATCH_BASE_VALUE = BEFORE_PATCH_BASE_VALUE + 1
            if BEFORE_PATCH_BASE_VALUE > constants.BEFORE_PATCH_POLL_TIMES:
                logger.info("check patch start is timeout, the time:%s." % str(BEFORE_PATCH_BASE_VALUE))
                return (False, resource.getString("install.hotpatch.failed"))  # 安装补丁失败

            rec = tlvCon.invoke(CommandConstans.OM_MSG_OP_LST_SYS_UPSTAT, TLVUtils.paramList(), CMD_DEFAULT_TIMEOUT)
            if (None != rec):
                logger.info("upgrade process:" + str(rec))
                status = rec.getParamIntValue(3).intValue()
            if status == constants.OM_MSG_OP_UPD_LST_SYS_PROGRESS.UPD_UPDING:
                break
            if status == constants.OM_MSG_OP_UPD_LST_SYS_PROGRESS.UPD_UPD_SUCCESS:
                # 查询补丁版本是否为最新的
                flag, hotPatchCurVersion = self.getHotPatchVer(tlvCon)
                if hotPathPkgVersion == hotPatchCurVersion:
                    return (True, "")
            baseUtil.safeSleep(constants.BEFORE_PATCH_POLL_INTERVAL)
            checkUtils.updateItemProgressNoDelay(dataDict, "InstallPatchProgresCheck", BEFORE_PATCH_BASE_VALUE)

        checkUtils.updateItemProgress(dataDict, "InstallPatchProgresCheck", 20)

        DEVEICE_UP_FALLD_BASE_VALUE = 0  # 轮询计数器
        while (constants.OM_MSG_OP_UPD_LST_SYS_PROGRESS.UPD_UPD_SUCCESS != status):
            try:
                DEVEICE_UP_FALLD_BASE_VALUE = DEVEICE_UP_FALLD_BASE_VALUE + 1
                if DEVEICE_UP_FALLD_BASE_VALUE > constants.UPGRADE_PACKAGE_POLL_TIMES:
                    logger.info("Upgrade patch is timeout, the time:%s." % str(DEVEICE_UP_FALLD_BASE_VALUE))
                    return (False, resource.getString("install.hotpatch.failed"))
                # 查询升级进度
                rec = tlvCon.invoke(CommandConstans.OM_MSG_OP_LST_SYS_UPSTAT, TLVUtils.paramList(), CMD_DEFAULT_TIMEOUT)
                if (None != rec):
                    logger.info("upgrade process:" + str(rec))
                    status = rec.getParamIntValue(3).intValue()
                    process = rec.getParamIntValue(4).intValue()
                    checkUtils.updateItemProgressNoDelay(dataDict, "InstallPatchProgresCheck", process)
                ###升级状态检查
                if not self.checkUpgradeStatusIsUpgrade(status):
                    ##查询升级详情
                    logger.info("system status is not in upgrading, status is:" + str(status))
                    if not self.checkUpgradeStatusIsNomarl(status):
                        logger.info("system status is not normal.")
                    ##查询升级详细信息
                    recs = tlvCon.getBatch(CommandConstans.OM_OPCODE_UPGRADE_LST_EXEINFO, TLVUtils.paramList(),
                                           CMD_DEFAULT_TIMEOUT)
                    logger.info("upgrade atoms:%s" % recs)
                    for rec in recs:
                        itemState = rec.getParamStrValue(1)
                        errorKey = rec.getParamStrValue(2)
                        logger.info("upgrade atom itemState:" + itemState)
                        errorKeyList = errorKey.split(":")
                        errorKeyListLen = len(errorKeyList)

                        if "1" != itemState:  # 表示没有失败
                            continue
                        try:
                            if errorKeyListLen >= 2:
                                firstCommaLoc = errorKey.find(":")  # 第一个冒号前为key值，后面为错误详情参数，此方法避免参数中存在冒号
                                msgKey = errorKey[:firstCommaLoc]
                                errParam = errorKey[firstCommaLoc + 1:]  # 冒号之后为错误参数信息
                                parseErrorInfoRet = self.parseAtomInfo(errParam)
                                logger.info("msgKey: %s parseErrorInfoRet:%s" % (msgKey, parseErrorInfoRet))
                                errorInfo = resource.getString(msgKey) % parseErrorInfoRet
                            else:
                                errorInfo = resource.getString(errorKey)
                            errMsg = errorInfo + '\n' + resource.getString("install.hotpatch.failed")
                            return (False, errMsg)
                        except:
                            logger.info("parse atom info failed:%s" % errorInfo)
                            errMsg = resource.getString("install.hotpatch.failed")
                            return (False, errMsg)
                baseUtil.safeSleep(constants.UPGRADE_PACKAGE_POLL_INTERVAL)
            except (Exception, JException), e:
                logger.error("device upgrade query progress error" + str(e))
                # 第一个原子执行时间较长，会抛出该错误码，继续执行查询
                if isinstance(e, TLVException):
                    if constants.OM_OPERATE_FAIL_CODE == e.getErrorId():
                        continue
                if not self.checkDevReboot(dataDict):
                    errMsg = resource.getString("upgrade.rebooterr.2")
                    return (False, errMsg)
                else:
                    continue

        # 查询补丁版本是否为最新的
        flag, hotPatchCurVersion = self.getHotPatchVer(tlvCon)
        logger.info("[InstallPatchCheckWithTlv] hotPatchCurVersion:" + str(hotPatchCurVersion))
        if hotPathPkgVersion != hotPatchCurVersion:
            return (False, resource.getString("install.hotpatch.failed"))
        return (True, "")

    def getHotPatchVer(self, tlvCon):
        msgParam0 = Param(0, ParamType.UNSIGN_INT, UnsignedInt32(3))
        recs = tlvCon.getBatch(CommandConstans.OM_MSG_OP_LST_VER, TLVUtils.paramList(msgParam0), CMD_DEFAULT_TIMEOUT)
        self.logger.info(
            "[InstallPatchCheckWithTlv]execute cmd(%s) and result:%s" % (str(CommandConstans.OM_MSG_OP_LST_VER), recs))
        rec = recs.get(1)
        hotPatchVersion = rec.getParamStrValue(4)
        if not hotPatchVersion:
            return (True, '--')
        return (True, hotPatchVersion)

    """
    重新建连接
    """

    def checkDevReboot(self, dataDict):
        protocalContext = dataDict.get("protocalContext")
        logger = dataDict.get("logger")
        tlvCon = protocalContext.get("TLV")

        logger.info("entrance dev reboot monitor function.")
        ##重连超时UPGRADE_REBOOT_AFTER_CONNECT_TIMEOUT，如果连接成功则返回，如果全部没有连接成功在返回失败
        tlvCon.close()
        rebootAfterConnectSuc = False
        for times in range(0, constants.UPGRADE_REBOOT_AFTER_CONNECT_TIMES):
            times += 1
            try:
                tlvCon.reConnect()
                rebootAfterConnectSuc = True
                break
            except IsmException, ismE:
                baseUtil.safeSleep(constants.UPGRADE_REBOOT_AFTER_CONNECT_INTERVAL)
                logger.error("caught IsmException:dev reboot after(times:%s) connect error：%s" % (str(times), ismE))
            except (Exception, JException), e:
                baseUtil.safeSleep(constants.UPGRADE_REBOOT_AFTER_CONNECT_INTERVAL)
                logger.error("caught excepntion:dev reboot after(times:%s) connect error:%s " % (str(times), e))
        logger.info("device reboot moniter finished . isOK:" + str(rebootAfterConnectSuc))
        return rebootAfterConnectSuc

    def parseAtomInfo(self, errParam):
        """
                描述：转换升级原子信息
                原子错误信息格式：参数1,参数2
                参数之间用逗号隔开
                参数：errParam：错误信息字符串
                返回：解析后的错误信息参数元组
        """
        errDetailParas = errParam.split(",")
        return tuple(errDetailParas)
