#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2020~ All rights reserved.
import os
import sys


class InfoCollectConst(object):
    class ConstError(TypeError):
        pass

    class CaseError(ConstError):
        pass

    def __setattr__(self, key, value):
        if key in self.__dict__:
            raise self.ConstError("Can't change const {} value. ".format(key))

        if not key.isupper():
            raise self.CaseError(
                "Const key {} must be all in upper case.".format(key)
            )
        self.__dict__[key] = value


const = InfoCollectConst()

const.ERR_CODE_MEMORY_INSUFFICIENT = 1073747216
const.ERR_CODE_TASK_CONFLICTING = 1073747214

const.SUPPORT_COLLECT_HOSTINFO_BY_STOR_ULTRAPATH_START_VER = tuple(
    map(int, "21.06.056".split("."))
)

const.SUPPORT_COLLECT_HOST_INFO_BY_STORAGE_SYS_START_VER = "V500R007C70"
const.SUPPORT_COLLECT_HOST_INFO_BY_SYS_C60SPC300 = "V500R007C60SPC300"
const.NEED_UPG_EVAL_AND_SUPPORTING_HOSTINFO_COLLECT_VERS = (
    "V500R007C61",
    "V300R006C61",
    "V500R007C62",
)

const.SUPPORT_COLLECT_HOST_INFO_BY_STORAGE_C60SPH305 = "V500R007C60SPH305"

const.ERR_KEY_COLLECT_HOST_INFO_GENERIC_ERROR = (
    "collect.host.info.generic.error"
)

const.ERR_KEY_COLLECT_HOST_INFO_MEMORY_INSUFFICIENT_ERROR = (
    "collect.host.info.memory.insufficient.error"
)

const.ERR_KEY_COLLECT_HOST_INFO_TASK_CONFLICTING_ERROR = (
    "collect.host.info.task.conflicting.error"
)

const.ERR_KEY_NO_NEED_COLLECT = "collect.host.info.no.need.to.collect"

const.ERR_KEY_NEED_INSTALL_PATCH_TO_COLLECT = (
    "collect.host.info.need_install_hot_patch"
)

const.ERR_KEY_COLLECT_HOST_INFO_PART_FAIL = "collect.host.info.part.fail"

const.ERR_KEY_REST_REQUEST_ERROR = "collect.host.info.rest.request.error"


const.ERR_KEY_COLLECT_HOST_INFO_PARAMS_ERROR = (
    "collect.host.info.parameter.error"
)

const.ERR_KEY_QUERY_SCRIPT_UPLOAD_PATH_FAILED = (
    "query.host.collect.script.upload.path.failed"
)

const.ERR_KEY_QUERY_ALL_ETH_PORTS_FAILED = "query.all.eth.ports.failed"
const.ERR_KEY_CREATE_CTRL_CONN_FAILED = "create.controller.connection.failed"
const.ERR_KEY_QUERY_LOCAL_NODE_ID_FAILED = "query.local.node.id.failed"
const.ERR_KEY_UPLOAD_SCRIPT_FAILED = "upload.host.info.collect.script.failed"
const.ERR_KEY_QUERY_COLLECT_STATUS_FAILED = (
    "query.host.collect.pkg.progress.failed"
)
const.ERR_KEY_QUERY_PKG_DOWNLOAD_PATH_FAILED = (
    "query.host.collect.pkg.download.path.failed"
)
const.ERR_KEY_DOWNLOAD_COLLECTED_FILE_FAILED = (
    "download.host.collected.file.failed"
)
const.ERR_KEY_NOTIFY_STORAGE_DEL_PKG_FAILED = (
    "notify.storage.delete.host.pkg.failed"
)
const.ERR_KEY_NOTIFY_STORAGE_START_COLLECT_FAILED = (
    "notify.storage.start.collect.host.pkg.failed"
)
const.ERR_KEY_COLLECT_HOST_INFO_TIMED_OUT = "collect.host.info.timed.out"

const.ERR_KEY_QUERY_HYPER_METRO_PAIR_FAILED = "query.hyper.metro.pair.failed"

const.ERR_KEY_QUERY_HOST_LUN_FAILED = "query.host.lun.failed"

const.REST_CMD_GET_UPLOAD_PATH = "get_upload_path"

const.REST_CMD_START_HOST_INFO_COLLECTION = "start_host_info_collection"

const.REST_CMD_GET_HOST_INFO_COLLECTION_PROGRESS = (
    "get_host_info_collection_progress"
)


const.REST_CMD_GET_DOWNLOAD_PKG = "get_download_pkg"

const.REST_CMD_DELETE_PACKAGE = "delete_package"

const.SHOW_HYPER_METRO_PAIR_CMD = (
    r"show hyper_metro_pair general |"
    r"filterRow column=Type predict=equal_to "
    r"value=LUN |filterColumn "
    r"include columnList=Local\sID,WWN"
)

const.SHOW_HOST_LUN_CMD = r"show host lun host_id={}"
# 主机信息收集脚本包存放于：
# 工具下面的： packages\toolkit\host\infocollect
const.HOST_INFO_COLLECT_SCRIPT_PATH_NAME = os.path.sep.join(
    ["packages", "toolkit", "host", "infocollect", "host_info_collect.zip"]
)
const.UPGRADE_CHECK_COMPONENT_PKG_PATH = os.path.sep.join(
    ["..", "upgradeEvaluation", "packages"]
)
const.UPGRADE_CHECK_COMPONENT_PKG_PATTERN = "upgrade_check_component*.tar.gz"

const.UPGRADE_CHECK_COMPONENT_MAIN_YML_FILE_PATTERN = os.path.join(
    "upgrade_check-*", "vars", "main.yml"
)

const.HOST_INFO_COLLECT_SCENE_PARAMS_FILE_NAME = "scene_params.txt"
const.HOST_INFO_COLLECT_UPLOAD_ZIP_FILE_NAME = "hostinfo_collect_all.zip"
const.HOST_INFO_UPLOAD_ZIP_FILE_NAMES = [
    "host_info_collect.zip",
    "host_info_collect.zip.cms",
    "host_info_collect.zip.crl",
    "scene_params.txt",
]

const.HOST_INFO_COLLECT_SAVE_DIR = "hostinfo"
const.HOST_INFO_COLLECT_PKG_NAME = "hostInfo.tgz"
const.ZIP_FILE_REL_PATH = os.path.join("OSM", "hostinfo", "data")
const.HOST_INFO_COLLECT_SUCCESS_MARK = "self_define_cmd_checkinfo"

const.COLLECT_STATUS_DOING = "0"
const.COLLECT_STATUS_DONE = "1"

# Smartkit 场景化参数和 InfoGrab 离线采集脚本 场景参数的映射关系。
const.HOST_INFO_COLLECT_SCENE_PARAM_MAP = {"Upgrade Check": "-scene upgrade"}

# 下载目录:
const.HOST_COLLECT_C60_FILE_PATH = "/OSM/hostinfo/script/initiator_list.json"

# V5R7C60SPH305查询启动器的debug命令。
const.HOST_INFO_QUERY_INI_DEBUG = "tgt list initiator"

sys.modules[__name__] = const

const.UP_MODE_ROLL = "ROLL"  # 滚动升级模式
const.UP_MODE_APOLLO = "APOLLO"  # 内核&固件升级模式