# -*- coding: UTF-8 -*-

from cbb.frame.tlv import adTlvUtil
from cbb.frame.context import contextUtil
import common
import functools


def handleFailureForRetry(func):
    '''
    @summary: 检查项失败后重新执行时进行扩容前预处理
    '''
    @functools.wraps(func)
    def inner(context, *args, **kwargs):
        if not context.get("succ", True):
            tlv = contextUtil.getTlv(context)
            logger = common.getLogger(context.get("logger"), __file__)
            oldCtrlNum = contextUtil.getItem(context, "ctrlNum")
            if oldCtrlNum is not None:
                logger.logInfo("start to pre-processing...")
                # 扩容前预处理，禁转发，打开通道等
                adTlvUtil.preExpansion(tlv, oldCtrlNum, logger)
        func(context, *args, **kwargs)
    return inner
