# coding:utf-8
"""
@Copyright (C) Huawei Technologies Co., LTD. 2019 - 2020
@version: SmartKit V200R006C00
@time: 2019/07/18 
@file: recommendDae.py
@function: 
@modify: 
"""
from cbb.frame.context import contextUtil
from cbb.common.conf.v6HighEnd.fullBayConf import EXP_DAE_CONF
from cbb.common.conf.v6HighEnd.fullBayConf import EXP_DAE_CONF_FOR_DORADO_18000_NVME
from cbb.common.conf.v6HighEnd.fullBayConf import EXP_DAE_SYM_BAY_PAIRS
from cbb.common.conf.v6HighEnd.fullBayConf import EXP_DAE_SYM_BAY_PAIRS_FOR_DORADO_18000_NVME


def recommendDaes(existingBayNames, existingDaeNames, expDaeNum,
                  daeEnclosureType='SMART', backendNetMode='non_share', context=""):
    """硬盘框（柜）推荐位置算法：
    1）1个系统柜时，从下往上依次扩满系统柜；然后优先增加1级级联磁盘柜，再从左至右增加2级级联磁盘柜。
    2）2个系统柜时，优先对称地在两个系统柜从上往上扩满系统柜，再对称增加1级级联磁盘柜，最后对称增加二级级联磁盘柜；

    :param existingBayNames: 已有的柜名称。
    :param existingDaeNames: 已有磁盘框ID（如果修改过，则是修改前的ID）
    :param expDaeNum: 要扩容的硬盘框个数。
    :param daeEnclosureType: 硬盘框类型： 'SMART' or 'SAS'.
    :param backendNetMode: 后端组网类型：共享或者非共享，即 'share' or 'non_share'
    :param context: 上下文
    :return: 新扩容硬盘框推荐位置，以命名元组对象返回(Refer cbb/common/conf/v6HighEnd/fullBayConf.py) list
    """
    curSysBayNames = list(filter(lambda bayName: bayName and isinstance(bayName, str)
                                                 and 'SMB' in bayName.upper(),
                                 existingBayNames))
    curSysBayNum = len(curSysBayNames)
    allSupportDaes = EXP_DAE_CONF.get(daeEnclosureType, {}).get(backendNetMode, [])

    if curSysBayNum == 1:
        allFreeNewDaes = filter(lambda dae: dae.name not in existingDaeNames and dae.bayName[3] == "0",
                                allSupportDaes)
        return allFreeNewDaes[:expDaeNum]

    sortedDaes = []
    daeNumPerBay = EXP_DAE_SYM_BAY_PAIRS.get(daeEnclosureType, {}).get(backendNetMode, {}).get('daeNumPerBay', 8)
    allBayPairs = EXP_DAE_SYM_BAY_PAIRS.get(daeEnclosureType, {}).get(backendNetMode, {}).get(curSysBayNum, [])
    # OceanStor Dorado 18000 V6 NVMe型号6.1.5RC1以后扩扩大规格,单引擎支持45个框
    if context and contextUtil.getItem(context, "is_exp_spec_dorado_dev"):
        allSupportDaes = EXP_DAE_CONF_FOR_DORADO_18000_NVME
        allBayPairs = EXP_DAE_SYM_BAY_PAIRS_FOR_DORADO_18000_NVME.get(curSysBayNum, [])
    sysBayNamePairs = allBayPairs[0]
    diskBayNameParis = allBayPairs[1:]

    smb_daes_list = []
    for i in range(curSysBayNum):
        smbDaes = list(filter(lambda dae: dae.bayName == sysBayNamePairs[i], allSupportDaes))
        smb_daes_list.append(smbDaes)

    for i in range(daeNumPerBay):
        [sortedDaes.append(smb_daes[i]) for smb_daes in smb_daes_list]

    pairSelectDaesList = []
    for diskBayNamePair in diskBayNameParis:
        for i in range(curSysBayNum):
            daesFromBay = list(filter(lambda dae: dae.bayName == diskBayNamePair[i], allSupportDaes))
            pairSelectDaesList.append(daesFromBay)
    for pairTuple in pairSelectDaesList:
        [sortedDaes.append(pairTuple[i]) for i in range(daeNumPerBay)]

    allFreeNewDaes = filter(lambda dae: dae.name not in existingDaeNames,
                            sortedDaes)
    retRecommendDaes = allFreeNewDaes[:expDaeNum]
    return retRecommendDaes
