﻿# -*- coding: UTF-8 -*-
'''
设置各个FRU，更换时的时间限制
'''
from common import BaseFactory
from common import FuncFactory
from cbb.frame.base.config import CONTROLLER_TIME_LIMIT_V5
from cbb.frame.context import contextUtil
from cbb.frame.rest import restData
from cbb.frame.rest import restUtil

DEFAUL_TIME_LIMIT = "5"
TIME_LIMIT_5300V3_5500V3_POWER_FAN_BBU = "3"
TIME_LIMIT_5600V3_5800V3_6800V3_6900V3_CONTROLLER = "10"
TIME_LIMIT_2800V5_5300V5_5500V5_CONTROLLER = "3"


def execute(context, param):
    try:
        proModel = FuncFactory.getSystemProductType(context)

        if proModel in (BaseFactory.const.SYSMODEL["5X00V3"],
                        BaseFactory.const.SYSMODEL["V3_3U_ENGINE"],
                        BaseFactory.const.SYSMODEL["V3_6U_ENGINE"],
                        BaseFactory.const.SYSMODEL["V3_18000"]):
            param = str(param)
            execfunc = globals()[param]
            if None == execfunc:
                raise Exception("in-existed func: " + param)
            if not callable(execfunc):
                raise Exception("in-callable func: " + param)
            timeLimitInfo = execfunc(context)

            context['retData'] = timeLimitInfo
        else:
            context['retData'] = ""

        return
    except Exception as ex:
        BaseFactory.exception.handler(context, ex)
        return


def power(context):
    selRowKey = "input_selectfru_frutab"
    timeLimit = timeLimitFor_Power_BBU_Fan(context, selRowKey)
    return timeLimit


def bbu(context):
    timeLimit = "3"
    info = BaseFactory.lang.getDesc(context, FuncFactory.LangKey.CONFIRM_REPLACE_DONE_TIME_LIMIT_DEFAULT_INFO,
                                    timeLimit)
    return info


def fan(context):
    selRowKey = "input_selectfru_fanSelectedRow"
    timeLimit = timeLimitFor_Power_BBU_Fan(context, selRowKey, restData.Enum.ObjEnum.FAN)
    return timeLimit


def manageFanCtrlBoard(context):
    selRowKey = "input_selectfru_fanSelectedRow"
    timeLimit = timeLimitFor_Power_BBU_Fan(context, selRowKey)
    return timeLimit


def controller(context):
    timeLimit = DEFAUL_TIME_LIMIT
    productModel = contextUtil.getProductModel(context)
    if productModel in CONTROLLER_TIME_LIMIT_V5:
        timeLimit = TIME_LIMIT_2800V5_5300V5_5500V5_CONTROLLER
    info = BaseFactory.lang.getDesc(context, FuncFactory.LangKey.CONFIRM_REPLACE_DONE_CONTROLLER_TIME_LIMIT_INFO,
                                    timeLimit)
    appendInfo = BaseFactory.lang.getDesc(context,
                                          FuncFactory.LangKey.CONFIRM_REPLACE_DONE_CONTROLLER_APPEND_TIME_LIMIT_INFO)
    if info is not None and appendInfo:
        info = info + appendInfo
    return info


def disk(context):
    info = BaseFactory.lang.getDesc(context, FuncFactory.LangKey.CONFIRM_REPLACE_DONE_DISK_TIME_LIMIT_INFO,
                                    DEFAUL_TIME_LIMIT)
    return info


def manageBoard(context):
    proModel = FuncFactory.getSystemProductType(context)
    if proModel == BaseFactory.const.SYSMODEL["5X00V3"]:
        return ""
    else:
        info = BaseFactory.lang.getDesc(context, FuncFactory.LangKey.CONFIRM_REPLACE_DONE_TIME_LIMIT_DEFAULT_INFO,
                                        DEFAUL_TIME_LIMIT)
        return info


def defaultTimeLimit(context):
    '''
            返回默认的限制时间
    '''
    info = BaseFactory.lang.getDesc(context, FuncFactory.LangKey.CONFIRM_REPLACE_DONE_TIME_LIMIT_DEFAULT_INFO,
                                    DEFAUL_TIME_LIMIT)
    return info


def timeLimitFor_Power_BBU_Fan(context, selRowKey, fruType=None):
    '''
            盘控一体环境：控制框3分钟，硬盘框5分钟
    '''
    timeLimit = DEFAUL_TIME_LIMIT
    selRow = BaseFactory.json.toDict(context.get(selRowKey))
    parentType = selRow["parentType"]
    parentType = int(parentType)
    parentId = selRow["parentID"]
    proModel = FuncFactory.getSystemProductType(context)

    if proModel == BaseFactory.const.SYSMODEL["5X00V3"]:
        if parentType == restData.Enum.ObjEnum.ENCLOSURE:
            # 框的逻辑类型必须为控制框
            tempRec = FuncFactory.getFruInfo(context, parentType, parentId)
            logicType = restUtil.Tlv2Rest.getRecordValue(tempRec, restData.Hardware.Enclosure.LOGIC_TYPE)

            if logicType == restData.Enum.EnclosureTypeEnum.CTRL:
                timeLimit = TIME_LIMIT_5300V3_5500V3_POWER_FAN_BBU
    isFan2u = FuncFactory.is2U_Fan(context, fruType, selRow["id"])
    if isFan2u and fruType is restData.Enum.ObjEnum.FAN:
        info = BaseFactory.lang.getDesc(context,
                                        FuncFactory.LangKey.CONFIRM_REPLACE_DONE_TIME_LIMIT_DEFAULT_INFO_FOR_BUNDLE_FRU,
                                        timeLimit)
        return info
    else:
        info = BaseFactory.lang.getDesc(context, FuncFactory.LangKey.CONFIRM_REPLACE_DONE_TIME_LIMIT_DEFAULT_INFO,
                                        timeLimit)
        return info
