# coding=utf-8
from cbb.business.operate.fru.common import BaseFactory
from cbb.business.operate.fru.common import FuncFactory
from cbb.frame.rest import restData
from cbb.frame.rest import restUtil

# 保存级联板key值
NORMAL_EXP_MODULES = "normal_exp_modules"


def execute(context, enc_id, pre_check=True):
    """检查硬盘框更换前后的级联模块状态是否一致

    :param context: 上下文
    :param enc_id: 硬盘框ID
    :param pre_check: 更换前检查标记
    :return:
    """
    # 更换前检查，保存硬盘框下在位且正常的级联模块信息
    if pre_check:
        normal_exp_modules = getNormalExpModuleOnEnc(context, enc_id)
        BaseFactory.log.info(context, "list of normal expansion modules before: %s" % str(normal_exp_modules))
        BaseFactory.persist.setModule(context, NORMAL_EXP_MODULES, normal_exp_modules)
        BaseFactory.result.setResultPass(context)
        return

    # 更换后检查
    else:
        BaseFactory.log.info(context, "====Post Check Normal Expansion Module Start====")
        normal_exp_modules_before = BaseFactory.persist.getModule(context, NORMAL_EXP_MODULES)
        BaseFactory.log.info(context, "normal Expansion Module before is :%s" % str(normal_exp_modules_before))
        # 如果更换前硬盘框下不存在正常的级联模块，直接通过
        if not normal_exp_modules_before:
            BaseFactory.result.setResultPass(context)
            return

        # 获取更换后所有正常级联模块
        normal_exp_modules_after = getNormalExpModuleOnEnc(context)
        BaseFactory.log.info(context, "normal Expansion Module after is :%s" % str(normal_exp_modules_after))

        # 检查是否有更换前正常，更换后不正常的级联模块，如果有则不通过
        abnormal_exp_modules = [exp for exp in normal_exp_modules_before if exp not in normal_exp_modules_after]
        if abnormal_exp_modules:
            BaseFactory.result.setResultFailByKey(context, FuncFactory.LangKey.EXPBOARD_STATUS_NOT_COINCIDENT,
                                                  ", ".join(abnormal_exp_modules))
            BaseFactory.log.error(context, "====Post Check Normal Expansion Module End Fail====")
            return

        # 否则正常通过。
        BaseFactory.result.setResultPass(context)
        BaseFactory.log.info(context, "====Post Check Normal Expansion Module End Pass====")
        return


def getNormalExpModuleOnEnc(context, enc_id=None):
    """获取系统中所有的（或某个硬盘框下）在位且状态正常的级联模块的location列表

    :param context: 上下文
    :param enc_id: 硬盘框ID
    :return:
    """
    all_exp_module = FuncFactory.getFruListInfo(
        context, restData.Enum.ObjEnum.EXPBOARD)

    condition0 = restUtil.Tlv2Rest.getCondition(
        restData.Hardware.Expboard.RUNNING_STATUS,
        restData.Enum.ConditionTypeEnum.EQ,
        restData.Enum.RunningStatusEnum.RUNNING)
    condition1 = restUtil.Tlv2Rest.getCondition(
        restData.Hardware.Expboard.HEALTH_STATUS,
        restData.Enum.ConditionTypeEnum.EQ,
        restData.Enum.HealthStatusEnum.NORMAL)

    if enc_id:
        condition2 = restUtil.Tlv2Rest.getCondition(
            restData.Hardware.Expboard.PARENT_ID,
            restData.Enum.ConditionTypeEnum.EQ,
            enc_id)
        condition_list = restUtil.Tlv2Rest.getConditionList(condition0,
                                                            condition1,
                                                            condition2)
    else:
        condition_list = restUtil.Tlv2Rest.getConditionList(condition0,
                                                            condition1)
    normal_exp_modules = \
        restUtil.Tlv2Rest.filter(all_exp_module, condition_list)

    return list(map(
        lambda x: restUtil.Tlv2Rest.getRecordValue(
            x, restData.PublicAttributes.LOCATION), normal_exp_modules))
