# -*- coding: UTF-8 -*-

from cbb.business.operate.fru.common import BaseFactory
from cbb.business.operate.fru.common import FuncFactory
from cbb.business.operate.fru.common import common
from cbb.business.operate.fru.common import constData
from cbb.frame.cli import cliUtil
from cbb.frame.context import contextUtil
import cbb.frame.base.config as config


def execute(context):
    """
    检查双活Pair状态是否正常
    :param context:
    :return:
    """
    # 2210/2200 V5 不支持双活
    product_model = contextUtil.getProductModel(context)
    if product_model in config.ULTRA_LOW_END_NEW:
        BaseFactory.result.setResultPass(context)
        return
    execute_check(context)


def execute_check(context):
    """检查双活Pair状态是否正常
    检查步骤：
    如果双活链路Running Status状态为正常/同步/暂停中，返回检查成功；
    恢复策略（1:Automatic;2:Manual;）
    Running Status（1:Normal;23:Synchronizing;100:To Be Synchronized;35:Invalid;41:Paused;93:Forced Start;94:Fault;0:--）

    :param context: python执行上下文
    :return: dict: 检查结果 ,格式：{"succ":True,"errMsg":"","suggestion":""}
    """
    errMsg = ""
    flag = True

    cli = contextUtil.getCli(context)
    LANG = contextUtil.getLang(context)

    cmd = "show hyper_metro_pair general|filterColumn include columnList=ID,Health\sStatus,Link\sStatus,Running\sStatus,Recovery\sPolicy"
    BaseFactory.log.info(context, "========== check hyper pair start ==========")
    checkRet = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
    if checkRet[0] is not True:
        BaseFactory.result.setResultFailByKey(
            context,
            FuncFactory.LangKey.QUERY_RESULT_ABNORMAL)
        return

    cliRet = checkRet[1]
    if cliUtil.queryResultWithNoRecord(cliRet):
        BaseFactory.result.setResultPass(context)
        return

    cliRetLinesList = cliUtil.getHorizontalCliRet(cliRet)

    for line in cliRetLinesList:
        Id = line.get("ID", "")
        healthStatus = line.get("Health Status", "")
        linkStatus = line.get("Link Status", "")
        runningStatus = line.get("Running Status", "")

        if healthStatus != constData.HyperPairStatus.STATUS_NORMAL:
            flag = False
            err,_ = common.getMsg(LANG, "hyper.metro.pair.health.status.abnormal", (Id, healthStatus))
            errMsg += err
            BaseFactory.log.error(context,
                                  "The health status of active-active pair [%s] is abnormal (health status: %s)."
                                  % (Id, healthStatus))

        if linkStatus not in (constData.HyperPairStatus.STATUS_LINK_UP, "Linkup"):
            flag = False
            err,_ = common.getMsg(LANG, "hyper.metro.pair.link.status.abnormal", (Id, linkStatus))
            errMsg += err
            BaseFactory.log.error(context, "The link status of active-active pair [%s] is abnormal (link status: %s)."
                                  % (Id, linkStatus))

        if runningStatus not in (
                constData.HyperPairStatus.STATUS_NORMAL, constData.HyperPairStatus.STATUS_SYNCHRONIZING, constData.HyperPairStatus.STATUS_PAUSE):
            flag = False
            err,_ = common.getMsg(LANG, "hyper.metro.pair.running.status.abnormal", (Id, runningStatus))
            errMsg += err
            BaseFactory.log.error(context,
                                  "The running status of active-active pair [%s] is abnormal (running status: %s)."
                                  % (Id, runningStatus))

    if not flag:
        _, sugesstion = common.getMsg(LANG, "check.hyper.metro.pair.running.status")
        BaseFactory.result.setResultFailByDesc(context, errMsg, sugesstion)
        return

    BaseFactory.result.setResultPass(context)
    return
