# -*- coding: UTF-8 -*-

import json

from cbb.frame.base import jsonUtil
from cbb.business.operate.fru.common.checkItem import compute_storage_common


def get_compute_host_info(context):
    """
    获取计算节点主机信息
    @param context: 上下文
    @return: 主机信息
    """
    compute_connection = compute_storage_common.get_compute_storage_fcv_connection(context)
    device_id = get_device_id(compute_connection)
    uri = "/fce/vm-management/v1/fc/{}/hosts".format(device_id)
    records = compute_storage_common.get_record_by_fcv_rest(context, uri)
    return records.get("data", {}).get("hostList", [])


def get_compute_port_info(context):
    """
    获取计算节点端口信息
    @param context: 上下文
    @return: 端口信息
    """
    fcv_device_id = compute_storage_common.get_fcv_device_id(context)
    uri = "/fce/device-manager/v1/device/{}/detail/tabs?type=networkPort".format(fcv_device_id)
    records = compute_storage_common.get_record_by_fcv_rest(context, uri)
    return records.get("data", {}).get("networkPort", [])


def get_compute_vm_info(context):
    """
    获取计算节点虚拟机信息
    @param context: 上下文
    @return: 虚拟机信息
    """
    compute_connection = compute_storage_common.get_compute_storage_fcv_connection(context)
    device_id = get_device_id(compute_connection)
    vm_info_list = list()
    # 虚拟机数量最大为1024， 单页最大查询数量为50, 最大页数为21
    for page_num in range(1, 22):
        uri = "/fce/vm-management/v1/fc/{}/vms?pageSize=50&pageNum={}&isTemplate=false". format(device_id, page_num)
        records = compute_storage_common.get_record_by_fcv_rest(context, uri)
        vm_info = records.get("data", {}).get("vmInfoList", [])
        if not vm_info:
            return vm_info_list
        vm_info_list.extend(vm_info)
    return vm_info_list


def get_normal_compute_host(context):
    """
    获取计算节点正常的主机
    @param context: 上下文
    @return: 正常的主机
    """
    host_info_list = get_compute_host_info(context)
    normal_host_info_dict = dict()
    for host_info in host_info_list:
        name = host_info.get("name")
        if host_info.get("status") == "normal":
            normal_host_info_dict[name] = host_info.get("status")
    return normal_host_info_dict


def get_linkup_compute_port(context):
    """
    获取计算节点linkup的端口
    @param context: 上下文
    @return: linkup的端口
    """
    port_info_list = get_compute_port_info(context)
    normal_host_info_dict = dict()
    for host_info in port_info_list:
        location = host_info.get("port")
        if host_info.get("status") == "Linkup":
            normal_host_info_dict[location] = host_info.get("status")
    return normal_host_info_dict


def get_normal_compute_vm(context):
    """
    获取计算节点normal的虚拟机
    @param context: 上下文
    @return: normal的虚拟机
    """
    vm_info_list = get_compute_vm_info(context)
    normal_host_info_dict = dict()
    for vm_info in vm_info_list:
        vm_id = vm_info.get("vmId")
        if vm_info.get("status") == "running":
            normal_host_info_dict[vm_id] = vm_info.get("status")
    return normal_host_info_dict


def get_device_id(compute_connection):
    """
    获取FCV的device_id
    @param compute_connection: rest连接
    @return: device_id
    """
    uri = "/fce/device-manager/v1/device/devices"
    param = {"deviceSubTypes": ["vrm"], "deviceTypes": ["hypervisor-manager"]}
    param_str = jsonUtil.dict2JsonStrByDumps(param)
    response_info = compute_connection.execPost(compute_connection.getBaseUrl() + uri, param_str)
    data_string = response_info.getContent()
    records = json.loads(data_string)
    if not compute_storage_common.is_right_response(records):
        raise Exception("fail to get device id.")
    for record in records.get("data", {}).get("dataList", []):
        if record.get("deviceMeta", {}).get("deviceModel") == "FusionComputeCluster":
            return record.get("deviceId")
    return ""
