# -*- coding: UTF-8 -*-
import json
from cbb.business.operate.fru.common import BaseFactory
from cbb.business.operate.fru.common import FuncFactory
from cbb.business.operate.expansion import common
from cbb.frame.context import contextUtil
from cbb.frame.rest import restData
from cbb.frame.rest import restUtil
from cbb.frame.base import baseUtil
from cbb.frame.base import config

from utils import Products

FRU_TYPE = {"NODE": 2, "CARD": 1, "PORT": 0}


def execute(context, fru_type, fru_id, location=""):
    """容器冗余检查
    :param context:
    :param fru_type:
    :param fru_id:
    :param location:
    :return:
    """
    try:
        product_model = contextUtil.getProductModel(context)
        product_version = FuncFactory.getProductVersion(context)
        if all([Products.compareVersion(product_version, "6.1.2RC1") < 0,
                product_model not in config.OCEAN_PROTECT]):
            BaseFactory.result.setResultPass(context)
            return
        if not all([baseUtil.isDoradoV6HighEnd(product_model),
                   fru_type == "NODE"]):
            # 判断是否有容器卡
            if not has_container_card(context, fru_type, fru_id):
                BaseFactory.result.setResultPass(context)
                return
        # 如果fru_type是PORT
        if FRU_TYPE.get(fru_type) == 0:
            param_dict = {"checkRedundancyType": FRU_TYPE.get(fru_type),
                          "redundancyPortName": location}
        elif FRU_TYPE.get(fru_type) == 1:
            param_dict = {"checkRedundancyType": FRU_TYPE.get(fru_type),
                          "redundancyCardId": fru_id}
        else:
            param_dict = {"checkRedundancyType": FRU_TYPE.get(fru_type),
                          "redundancyNodeId": fru_id}

        # 查询是否冗余
        if not is_redundancy(context, param_dict):
            lang = contextUtil.getLang(context)
            # 弹出提示框，提示是否影响业务
            dialog_util = context.get("dialogUtil")
            err_msg = common.getRes(lang, "whether_affect_business")
            result = dialog_util.showWarningDialog(err_msg)
            if result:
                BaseFactory.result.setResultPass(context)
                return
            BaseFactory.result.setResultFailByKey(
                context,
                FuncFactory.LangKey.FRU_CHECK_CONTAINER_REDUNDANCY_FAILED,
                location)
            return

        BaseFactory.result.setResultPass(context)
    except Exception as e:
        BaseFactory.log.error(context, "err_msg: {}".format(str(e)))
        BaseFactory.result.setResultFailByKey(
            context, FuncFactory.LangKey.EXEC_TLV_CMD_FAIL)


def has_container_card(context, fru_type, fru_id):
    """
    判断是否为容器卡
    """
    # 获取所有接口卡并过滤出容器卡
    all_intf_recs = FuncFactory.getFruListInfo(
        context, restData.Enum.ObjEnum.INTF_MODULE)
    # 如果是NODE
    if FRU_TYPE.get(fru_type) == 2:
        condition0 = restUtil.Tlv2Rest.getCondition(
            restData.Hardware.IntfModule.PARENT_ID,
            restData.Enum.ConditionTypeEnum.EQ,
            fru_id)
    # 如果是PORT和CARD
    else:
        condition0 = restUtil.Tlv2Rest.getCondition(
            restData.Hardware.IntfModule.ID,
            restData.Enum.ConditionTypeEnum.EQ,
            fru_id)
    condition1 = restUtil.Tlv2Rest.getCondition(
        restData.Hardware.IntfModule.MODEL,
        restData.Enum.ConditionTypeEnum.EQOR,
        restData.CONTAINER_CARD)
    conditions = restUtil.Tlv2Rest.getConditionList(condition0, condition1)
    container_cards = restUtil.Tlv2Rest.filter(all_intf_recs, conditions)
    return bool(container_cards)


def is_redundancy(context, param_dict):
    """
    检查是否冗余
    """
    params_str = restUtil.CommonRest.getParamsJsonStr(param_dict, False)
    cmd = "NET_GLOBAL/check_pod_redundance"
    rest = contextUtil.getRest(context)
    base_uri = rest.getBaseUri()
    rest_connection = rest.getRest()
    response_info = rest_connection.execPut(
        "{}{}".format(base_uri, cmd), params_str
    )
    data_string = response_info.getContent()
    record = json.loads(data_string)
    BaseFactory.log.info(context, "record: {}".format(str(record)))

    if not is_right_response(record):
        raise Exception("error response.")
    result = record.get("data", {}).get("redundancyCheckResult", "")
    return bool(int(result) == 1)


def is_right_response(record):
    """
    校验响应数据是否正确。
    :param record:
    :return:
    """
    err_info = restUtil.CommonRest.getErrInfo(record)
    if not err_info:
        return False
    err_code = restUtil.CommonRest.getRecordValue(
        err_info, restData.ErrorInfo.CODE
    )
    # 不支持该命令, 直接返回通过
    if str(err_code) == '-1':
        return True
    # 如果命令执行失败
    if str(err_code) != '0':
        return False
    return True
