# -*- coding: UTF-8 -*-
import traceback

from cbb.frame.base import baseUtil
from cbb.business.operate.fru.common import BaseFactory
from cbb.business.operate.fru.common import FuncFactory
from cbb.business.operate.fru.common import common
from cbb.frame.context import contextUtil

from cbb.business.checkitems.check_ipvsix_on_cross_intf_bonding import (
    CrossIntfBondCheck,
    RISK_SOFTWARE_VERSION,
)
from cbb.frame.base.exception import UnCheckException


def execute(context, port_list):
    """硬盘域空间图对象检查
    :param context:
    :return:
    """
    lang = contextUtil.getLang(context)
    logger = baseUtil.getLogger(contextUtil.getLogger(context), __file__)

    try:
        cli = contextUtil.getCli(context)
        p_model = str(context.get("dev").get("type")).strip()
        p_version_mem = str(context.get("dev").get("version")).strip()
        bond_port_check = CrossIntfBondCheck(
            cli, lang, logger, p_version_mem, p_model, port_list, True
        )
        logger.logInfo(
            "The product is model:{},version:{}, port_list:{}".format(
                p_model, p_version_mem, port_list)
        )
        risk_flag = bond_port_check.execute_check()
        logger.logInfo(
            "The risk_flag is:{}, RISK_SOFTWARE_VERSION:{}".format(
                risk_flag, RISK_SOFTWARE_VERSION)
        )
        # 检查通过
        if risk_flag:
            BaseFactory.result.setResultPass(context)
            return
        result_dict = dict()
        # 检查不通过
        if bond_port_check.is_sugges_patch is True:
            sug_msg = common.getMsg(
                lang, "software.cross.intf.bond.install.patch.sug",
                (p_version_mem, bond_port_check.suggess_patch_version),
            )[0]
        else:
            sug_msg = common.getMsg(
                lang, "software.cross.intf.bond.contact.engineer"
            )[0]
        err_msg_list = create_err_msg(logger, lang, bond_port_check)
        result_dict["flag"] = False
        result_dict["errMsg"] = "".join(err_msg_list)
        result_dict["suggestion"] = sug_msg
        contextUtil.handleFailure(context, result_dict)
        return
    except (UnCheckException, Exception):
        logger.logInfo(
            "error :{} ".format(traceback.format_exc())
        )
        BaseFactory.result.setResultFailByKey(
            context, FuncFactory.LangKey.FUNC_GET_INFO_Y_FAIL, None, None
        )


def create_err_msg(logger, lang, bond_port_check):
    """
    创建错误消息
    :param bond_port_check:
    :return:
    """
    err_msg_list = []
    # 存在物理口直接绑定跨卡绑定。
    if bond_port_check.physic_port_err_bond_name:
        err_key = "software.cross.intf.bond.physic.not.pass"
        params = ",".join(bond_port_check.physic_port_err_bond_name)
        err_msg_list.append(common.getMsg(lang, err_key, params)[0])
    logger.logInfo(
        "logical_port_err_logic_name:{}".format(
            bond_port_check.logical_port_err_logic_name)
    )
    # 存在逻辑端口带VLAN/不带VLAN跨卡绑定。
    if bond_port_check.logical_port_err_logic_name:
        err_key = "software.cross.intf.bond.logic.not.pass"
        params = ",".join(bond_port_check.logical_port_err_logic_name)
        err_msg_list.append(common.getMsg(lang, err_key, params)[0])
    logger.logInfo(
        "default_fg_err_port_list:{}".format(
            bond_port_check.default_fg_err_port_list)
    )
    # 存在漂移组默认逻辑端口跨卡绑定
    if bond_port_check.default_fg_err_port_list:
        err_key = "software.cross.intf.bond.default.fg.not.pass"
        params = ",".join(bond_port_check.default_fg_err_port_list)
        err_msg_list.append(common.getMsg(lang, err_key, params)[0])
    logger.logInfo(
        "fg_err_port_dict:{}".format(bond_port_check.fg_err_port_dict)
    )
    # 存在漂移组非默认逻辑端口跨卡绑定
    if bond_port_check.fg_err_port_dict:
        for fg, err_port_info in bond_port_check.fg_err_port_dict.items():
            err_key = "software.cross.intf.bond.fg.not.pass"
            params = (err_port_info.get("logic_ports"),
                      err_port_info.get("bond_names"))
            err_msg_list.append(common.getMsg(lang, err_key, params)[0])
    return err_msg_list
