# -*- coding: UTF-8 -*-

import json

from cbb.frame.cli import cliUtil
from cbb.frame.context import contextUtil
from cbb.frame.rest import restData
from cbb.frame.rest import restUtil
from cbb.frame.base import baseUtil
from cbb.business.operate.fru.common import common


def init_data(context, select_id):
    lang = contextUtil.getLang(context)
    logger = baseUtil.getLogger(context.get("logger"), __file__)
    try:
        rest = contextUtil.getRest(context)
        disks = json.loads(context.get(select_id))
        pre_disk_type_list = []
        pre_barcode_list = []
        post_barcode_list = []
        for d in disks:
            pre_disk_type_list.append(d.get("diskType"))
            pre_barcode_list.append(d.get("barcode"))

            disk_id = d.get("id")
            rec = restUtil.CommonRest.getDiskById(rest, disk_id)
            post_barcode_list.append(restUtil.CommonRest.
                                     getRecordValue(rec, restData.
                                                    RestCfg.Disk.BARCODE))

        pre_data = {
            "diskType": ",".join(pre_disk_type_list),
            "barcode": ",".join(pre_barcode_list),
        }

        post_data = {
            "diskType": ",".join(pre_disk_type_list),
            "barcode": ",".join(post_barcode_list),
        }

        context["retData_disk_finished_pre_replace_summary-info"] = \
            json.dumps(pre_data)
        context["retData_disk_finished_post_replace_summary-info"] = \
            json.dumps(post_data)

        contextUtil.setResult(context, True, "", "")
        cli = contextUtil.getCli(context)
        lan = contextUtil.getLang(context)
        cliUtil.closeTlvChannel(cli, lan)
        return

    except Exception as ex:
        logger.error("Init finish data error:%s" % str(ex))
        msg, sug = common.getMsg(lang, "execute.error")
        contextUtil.setResult(context, False, msg, sug)
        return
