﻿# -*- coding: UTF-8 -*-
import json
import re
from cbb.business.operate.fru.common import BaseFactory
from cbb.business.operate.fru.common import FuncFactory
from cbb.business.operate.fru.common import constData
from cbb.frame.rest import restUtil
from cbb.frame.rest import restData


def execute(context, objType, status, **kwargs):
    """提取的公共方法记录当前框下运行的备件信息

    :param context:
    :param objType: 备件类型可以是BBU,FAN,PORT
    :param status:  online, running, link_up
    :param kwargs:
    :return:
    """

    currentRunningObj = {}
    if kwargs and kwargs.get('rowKey'):
        rowKey = kwargs.get('rowKey')
    else:
        rowKey = constData.Keys.SELECTED_ROW

    jsonStr = context.get(rowKey)

    selRow = json.loads(jsonStr, encoding='utf8')
    BaseFactory.log.info(context, u"selRow={}".format(selRow))

    records = FuncFactory.getFruListInfo(context, objType)
    if kwargs and kwargs.get("location", ""):
        locationRe = kwargs.get("location", "") + '.*?'
    elif selRow.get(constData.Keys.NAME, ""):
        locationRe = selRow[constData.Keys.NAME] + '.*?'
    else:
        locationRe = selRow[constData.Keys.LOCATION] + '.*?'

    if kwargs and kwargs.get("condition_list"):
        condition_list = kwargs.get("condition_list")
        records = restUtil.Tlv2Rest.filter(records, condition_list)
    for linkedPort in records:
        location = restUtil.Tlv2Rest.getRecordValue(linkedPort, restData.PublicAttributes.LOCATION)
        reg = re.compile(locationRe)
        runningStatus = restUtil.Tlv2Rest.getRecordValue(linkedPort, restData.PublicAttributes.RUNNING_STATUS)
        if reg.search(location) is not None and runningStatus == status:
            #显示中英文
            currentRunningObj[location] = restUtil.Tlv2Rest.getStrEn(restData.EnumStr.StrRunningStatusEnum, status)
            BaseFactory.log.info(context, "currentRunningObj location=%s" % str(location))
    return currentRunningObj

'''
提取的公共方法记录特定健康状态和运行状态的备件信息
如果runningStatus为None，则不过滤返回所有运行状态的硬盘
如果runningStatus为None，则不过滤返回所有健康状态的硬盘
'''
def executeBy2Status(context, objType, runningStatus, healthStatus, **kwargs):
    """
    objType: 备件类型可以是Disk
    runningStatus: 对应的运行状态 Online
    healthStatus: 对应的运行状态 NORMAL
    """
    currentFruObj = {}
    if kwargs and kwargs.get('rowKey'):
        rowKey = kwargs.get('rowKey')
    else:
        rowKey = constData.Keys.SELECTED_ROW
    jsonStr = context.get(rowKey)
    selRow = json.loads(jsonStr, encoding='utf8')
    BaseFactory.log.info(context, u"selRow={}".format(selRow))

    records = FuncFactory.getFruListInfo(context, objType)
    locationRe = selRow[constData.Keys.NAME] + '.*?'
    for linkedPort in records:
        location = restUtil.Tlv2Rest.getRecordValue(linkedPort, restData.PublicAttributes.LOCATION)
        reg = re.compile(locationRe)
        fruRunningStatus = restUtil.Tlv2Rest.getRecordValue(linkedPort, restData.PublicAttributes.RUNNING_STATUS)
        fruHealthStatus = restUtil.Tlv2Rest.getRecordValue(linkedPort, restData.PublicAttributes.HEALTH_STATUS)
        logic_type = restUtil.Tlv2Rest.getRecordValue(
            linkedPort, restData.Hardware.Disk.LOGIC_TYPE)
        if (reg.search(location) is not None) and \
                runningStatus is None or fruRunningStatus == runningStatus and \
                    healthStatus is None or fruHealthStatus == healthStatus:
            # 状态信息列表
            currentFruObj[location] = []
            #显示中英文
            currentFruObj[location].append(restUtil.Tlv2Rest.getStrEn(restData.EnumStr.StrRunningStatusEnum, fruRunningStatus))
            currentFruObj[location].append(restUtil.Tlv2Rest.getStrEn(restData.EnumStr.StrHealthStatusEnum, fruHealthStatus))
            currentFruObj[location].append(str(logic_type))
            BaseFactory.log.info(context, "currentFruObj location=%s" % str(location))
    return currentFruObj
