# coding:utf-8
"""
@Copyright (C) Huawei Technologies Co., LTD. 2019 - 2020
@version: SmartKit V200R006C00
@time: 2019/07/18 
@file: fullBayConf.py
@function: 
@modify: 
"""
from collections import namedtuple

DiskEnclosure = namedtuple('DAE', ['bayName', 'name', 'locationU'])

"""
{diskEnclosureType:{bayNum: (bayNameTuple),
                    }
                
"""
EXP_BAY_CONF = {
    'SAS': {  # diskEnclosureType: SAS
        1: ('SMB0', 'DKB0_0'),
        2: ('SMB0', 'SMB1', 'DKB0_0', 'DKB1_0'),
        3: ('SMB0', 'SMB1', 'SMB2', 'DKB0_0', 'DKB1_0', 'DKB2_0'),
        4: ('SMB0', 'SMB1', 'SMB2', 'SMB3', 'DKB0_0', 'DKB1_0', 'DKB2_0', 'DKB3_0'),
    },
    'SMART': {  # diskEnclosureType: Smart
        'non_share': {  # Backend network organization mode.
            1: ('SMB0', 'DKB0_0', 'DKB0_1', 'DKB0_2'),  # sysBayNum: (sysBayAndDiskBayNameTuple)
            2: ('SMB0', 'DKB0_0', 'DKB0_1', 'DKB0_2',
                'SMB1', 'DKB1_0', 'DKB1_1', 'DKB1_2',),
            3: ('SMB0', 'DKB0_0', 'DKB0_1', 'DKB0_2',
                'SMB1', 'DKB1_0', 'DKB1_1', 'DKB1_2',
                'SMB2', 'DKB2_0', 'DKB2_1', 'DKB2_2',),
            4: ('SMB0', 'DKB0_0', 'DKB0_1', 'DKB0_2',
                'SMB1', 'DKB1_0', 'DKB1_1', 'DKB1_2',
                'SMB2', 'DKB2_0', 'DKB2_1', 'DKB2_2',
                'SMB3', 'DKB3_0', 'DKB3_1', 'DKB3_2',),
        },
        'share': {
            2: ('SMB0', 'DKB0_0', 'DKB0_1', 'DKB0_2',
                'SMB1', 'DKB1_0', 'DKB1_1', 'DKB1_2',),
            4: ('SMB0', 'DKB0_0', 'DKB0_1', 'DKB0_2',
                'SMB1', 'DKB1_0', 'DKB1_1', 'DKB1_2',
                'SMB2', 'DKB2_0', 'DKB2_1', 'DKB2_2',
                'SMB3', 'DKB3_0', 'DKB3_1', 'DKB3_2',)}
    }
}

SAS_DAE_START_U = list(range(1, 20, 2)) + list(range(31, 42, 2))
DAE_LOOP_NUM = list((map(lambda h: h[2:].upper(), map(hex, range(16)))))
SMART_DAE_START_U = [3, 7, 11, 15, 19, 31, 35, 39]

EXP_DAE_SYM_BAY_PAIRS = {
    'SAS':
        {
            'non_share':
                {
                    'daeNumPerBay': 16,
                    'diskBayPerSysBay': 1,
                    1: ['SMB0', 'DKB0_0'],
                    2: [('SMB0', 'SMB1'), ('DKB0_0', 'DKB1_0')],  # SysBayNum : bayPairList
                    3: [('SMB0', 'SMB1', 'SMB2'),
                        ('DKB0_0', 'DKB1_0', 'DKB2_0')],
                    4: [('SMB0', 'SMB1', 'SMB2', 'SMB3'),
                        ('DKB0_0', 'DKB1_0', 'DKB2_0', 'DKB3_0')]
                },
            'share': {},
        },
    'SMART':
        {
            'non_share':
                {
                    'daeNumPerBay': 8,
                    'diskBayPerSysBay': 3,
                    1: ['SMB0', 'DKB0_1', 'DKB0_0', 'DKB0_2'],
                    2: [('SMB0', 'SMB1'), ('DKB0_1', 'DKB1_1'), ('DKB0_0', 'DKB1_0'), ('DKB0_2', 'DKB1_2')],
                    3: [('SMB0', 'SMB1', 'SMB2'),
                        ('DKB0_1', 'DKB1_1', 'DKB2_1'),
                        ('DKB0_0', 'DKB1_0', 'DKB2_0'),
                        ('DKB0_2', 'DKB1_2', 'DKB2_2')],
                    4: [('SMB0', 'SMB1', 'SMB2', 'SMB3'),
                        ('DKB0_1', 'DKB1_1', 'DKB2_1', 'DKB3_1'),
                        ('DKB0_0', 'DKB1_0', 'DKB2_0', 'DKB3_0'),
                        ('DKB0_2', 'DKB1_2', 'DKB2_2', 'DKB3_2')]
                },
            'share': {
                'daeNumPerBay': 8,
                'diskBayPerSysBay': 1,
                2: [('SMB0', 'SMB1'), ('DKB0_0', 'DKB0_1')],
                4: [('SMB0', 'SMB1'), ('SMB2', 'SMB3'), ('DKB0_0', 'DKB2_0'), ('DKB0_1', 'DKB2_1')],
            },
        }
}

SAS_DAE_RANGE = range(EXP_DAE_SYM_BAY_PAIRS.get('SAS', {}).get('non_share', {}).get('daeNumPerBay', 0))
SMART_DAE_RANGE = range(EXP_DAE_SYM_BAY_PAIRS.get('SMART', {}).get('non_share', {}).get('daeNumPerBay', 0))

EXP_DAE_CONF = {
    'SAS': {
        'non_share': [DiskEnclosure('SMB0', 'DAE0%s0' % (DAE_LOOP_NUM[i]), SAS_DAE_START_U[i]) for i in SAS_DAE_RANGE] +
                     [DiskEnclosure('DKB0_0', 'DAE0%s1' % (DAE_LOOP_NUM[i]), SAS_DAE_START_U[i]) for i in
                      SAS_DAE_RANGE] +
                     [DiskEnclosure('SMB1', 'DAE1%s0' % (DAE_LOOP_NUM[i]), SAS_DAE_START_U[i]) for i in SAS_DAE_RANGE] +
                     [DiskEnclosure('DKB1_0', 'DAE1%s1' % (DAE_LOOP_NUM[i]), SAS_DAE_START_U[i]) for i in
                      SAS_DAE_RANGE] +
                     [DiskEnclosure('SMB2', 'DAE2%s0' % (DAE_LOOP_NUM[i]),
                                    SAS_DAE_START_U[i]) for i in
                      SAS_DAE_RANGE] +
                     [DiskEnclosure('DKB2_0', 'DAE2%s1' % (DAE_LOOP_NUM[i]),
                                    SAS_DAE_START_U[i]) for i in
                      SAS_DAE_RANGE] +
                     [DiskEnclosure('SMB3', 'DAE3%s0' % (DAE_LOOP_NUM[i]),
                                    SAS_DAE_START_U[i]) for i in
                      SAS_DAE_RANGE] +
                     [DiskEnclosure('DKB3_0', 'DAE3%s1' % (DAE_LOOP_NUM[i]),
                                    SAS_DAE_START_U[i]) for i in
                      SAS_DAE_RANGE],
    },
    'SMART':
        {'non_share':  # 非共享组网，1级级联配置在前面；
             [DiskEnclosure('SMB0', 'DAE0%s0' % i, SMART_DAE_START_U[i]) for i in SMART_DAE_RANGE] +
             [DiskEnclosure('DKB0_1', 'DAE0%s0' % DAE_LOOP_NUM[i + 8], SMART_DAE_START_U[i]) for i in SMART_DAE_RANGE] +
             [DiskEnclosure('DKB0_0', 'DAE0%s1' % i, SMART_DAE_START_U[i]) for i in SMART_DAE_RANGE] +
             [DiskEnclosure('DKB0_2', 'DAE0%s1' % DAE_LOOP_NUM[i + 8], SMART_DAE_START_U[i]) for i in SMART_DAE_RANGE] +

             [DiskEnclosure('SMB1', 'DAE1%s0' % i, SMART_DAE_START_U[i]) for i in SMART_DAE_RANGE] +
             [DiskEnclosure('DKB1_1', 'DAE1%s0' % DAE_LOOP_NUM[i + 8], SMART_DAE_START_U[i]) for i in SMART_DAE_RANGE] +
             [DiskEnclosure('DKB1_0', 'DAE1%s1' % i, SMART_DAE_START_U[i]) for i in SMART_DAE_RANGE] +
             [DiskEnclosure('DKB1_2', 'DAE1%s1' % DAE_LOOP_NUM[i + 8], SMART_DAE_START_U[i]) for i in SMART_DAE_RANGE] +

             [DiskEnclosure('SMB2', 'DAE2%s0' % i, SMART_DAE_START_U[i]) for i
              in SMART_DAE_RANGE] +
             [DiskEnclosure('DKB2_1', 'DAE2%s0' % DAE_LOOP_NUM[i + 8],
                            SMART_DAE_START_U[i]) for i in SMART_DAE_RANGE] +
             [DiskEnclosure('DKB2_0', 'DAE2%s1' % i, SMART_DAE_START_U[i]) for i
              in SMART_DAE_RANGE] +
             [DiskEnclosure('DKB2_2', 'DAE2%s1' % DAE_LOOP_NUM[i + 8],
                            SMART_DAE_START_U[i]) for i in SMART_DAE_RANGE] +

             [DiskEnclosure('SMB3', 'DAE3%s0' % i, SMART_DAE_START_U[i]) for i
              in SMART_DAE_RANGE] +
             [DiskEnclosure('DKB3_1', 'DAE3%s0' % DAE_LOOP_NUM[i + 8],
                            SMART_DAE_START_U[i]) for i in SMART_DAE_RANGE] +
             [DiskEnclosure('DKB3_0', 'DAE3%s1' % i, SMART_DAE_START_U[i]) for i
              in SMART_DAE_RANGE] +
             [DiskEnclosure('DKB3_2', 'DAE3%s1' % DAE_LOOP_NUM[i + 8],
                            SMART_DAE_START_U[i]) for i in SMART_DAE_RANGE],
         'share':  # 共享组网，1级级联配置在前面；
             [DiskEnclosure('SMB0', 'DAE0%s0' % DAE_LOOP_NUM[2 * i], SMART_DAE_START_U[i]) for i in SMART_DAE_RANGE] +
             [DiskEnclosure('SMB1', 'DAE0%s0' % DAE_LOOP_NUM[2 * i + 1], SMART_DAE_START_U[i]) for i in
              SMART_DAE_RANGE] +
             [DiskEnclosure('SMB2', 'DAE2%s0' % i, SMART_DAE_START_U[i]) for i in SMART_DAE_RANGE] +
             [DiskEnclosure('SMB3', 'DAE2%s0' % DAE_LOOP_NUM[i + 8], SMART_DAE_START_U[i]) for i in SMART_DAE_RANGE] +

             [DiskEnclosure('DKB0_0', 'DAE0%s1' % DAE_LOOP_NUM[2 * i], SMART_DAE_START_U[i]) for i in SMART_DAE_RANGE] +
             [DiskEnclosure('DKB0_1', 'DAE0%s1' % DAE_LOOP_NUM[2 * i + 1], SMART_DAE_START_U[i]) for i in
              SMART_DAE_RANGE] +

             [DiskEnclosure('DKB2_0', 'DAE2%s1' % i, SMART_DAE_START_U[i]) for i in SMART_DAE_RANGE] +
             [DiskEnclosure('DKB2_1', 'DAE2%s1' % DAE_LOOP_NUM[i + 8], SMART_DAE_START_U[i]) for i in SMART_DAE_RANGE]
         }
}

EXP_DAE_CONF_FOR_DORADO_18000_NVME = \
    [DiskEnclosure('SMB0', 'DAE0%s0' % DAE_LOOP_NUM[2 * i], SMART_DAE_START_U[i]) for i in SMART_DAE_RANGE] + [
        DiskEnclosure('SMB1', 'DAE0%s0' % DAE_LOOP_NUM[2 * i + 1], SMART_DAE_START_U[i]) for i in SMART_DAE_RANGE] + [
        DiskEnclosure('SMB2', 'DAE2%s0' % i, SMART_DAE_START_U[i]) for i in SMART_DAE_RANGE] + [
        DiskEnclosure('SMB3', 'DAE2%s0' % DAE_LOOP_NUM[i + 8], SMART_DAE_START_U[i]) for i in SMART_DAE_RANGE] + [

        DiskEnclosure('DKB0_0', 'DAE0%s1' % DAE_LOOP_NUM[2 * i], SMART_DAE_START_U[i]) for i in SMART_DAE_RANGE] + [
        DiskEnclosure('DKB0_1', 'DAE0%s1' % DAE_LOOP_NUM[2 * i + 1], SMART_DAE_START_U[i]) for i in SMART_DAE_RANGE] + [
        DiskEnclosure('DKB2_0', 'DAE2%s1' % i, SMART_DAE_START_U[i]) for i in SMART_DAE_RANGE] + [
        DiskEnclosure('DKB2_1', 'DAE2%s1' % DAE_LOOP_NUM[i + 8], SMART_DAE_START_U[i]) for i in SMART_DAE_RANGE] + [

        DiskEnclosure('DKB0_2', 'DAE0%s2' % DAE_LOOP_NUM[2 * i], SMART_DAE_START_U[i]) for i in SMART_DAE_RANGE] + [
        DiskEnclosure('DKB0_3', 'DAE0%s2' % DAE_LOOP_NUM[2 * i + 1], SMART_DAE_START_U[i]) for i in
        SMART_DAE_RANGE] + [
        DiskEnclosure('DKB2_2', 'DAE2%s2' % i, SMART_DAE_START_U[i]) for i in SMART_DAE_RANGE] + [
        DiskEnclosure('DKB2_3', 'DAE2%s2' % DAE_LOOP_NUM[i + 8], SMART_DAE_START_U[i]) for i in SMART_DAE_RANGE]

EXP_DAE_SYM_BAY_PAIRS_FOR_DORADO_18000_NVME = {
    2: [('SMB0', 'SMB1'), ('DKB0_0', 'DKB0_1'), ('DKB0_2', 'DKB0_3')],
    4: [('SMB0', 'SMB1'), ('SMB2', 'SMB3'), ('DKB0_0', 'DKB2_0'), ('DKB0_1', 'DKB2_1'), ('DKB0_2', 'DKB2_2'),
        ('DKB0_3', 'DKB2_3')]
}

EXP_DAE_LOC_CONF = {
    'SAS': {
        'non_share': {'SMB0': slice(16),
                      'DKB0_0': slice(16, 32),
                      'SMB1': slice(32, 48),
                      'DKB1_0': slice(48, 64),
                      'SMB2': slice(64, 80),
                      'DKB2_0': slice(80, 96),
                      'SMB3': slice(96, 112),
                      'DKB3_0': slice(112, 128),
                      },
    },
    'SMART':
        {'non_share':  # 非共享组网，1级级联配置在前面；
            {
                'SMB0': slice(8),
                'DKB0_1': slice(8, 16),
                'DKB0_0': slice(16, 24),
                'DKB0_2': slice(24, 32),

                'SMB1': slice(32, 40),
                'DKB1_1': slice(40, 48),
                'DKB1_0': slice(48, 56),
                'DKB1_2': slice(56, 64),

                'SMB2': slice(64, 72),
                'DKB2_1': slice(72, 80),
                'DKB2_0': slice(80, 88),
                'DKB2_2': slice(88, 96),

                'SMB3': slice(96, 104),
                'DKB3_1': slice(104, 112),
                'DKB3_0': slice(112, 120),
                'DKB3_2': slice(120, 128),
            },
            'share':  # 共享组网，1级级联配置在前面；
                {
                    'SMB0': slice(8),
                    'SMB1': slice(8, 16),
                    'SMB2': slice(16, 24),
                    'SMB3': slice(24, 32),

                    'DKB0_0': slice(32, 40),
                    'DKB0_1': slice(40, 48),
                    'DKB2_0': slice(48, 56),
                    'DKB2_1': slice(56, 64),
                }
        }
}
