# -*- coding: UTF-8 -*-
# Copyright (c) Huawei Technologies Co., Ltd. 2012-. All rights reserved.

# 控制器名称在单引擎上对应的节点号
CTRL_NAME_TO_NODE_MAP = {
    "A": 0,
    "B": 1,
    "C": 2,
    "D": 3
}


def get_node_by_ctrl(is_high_end, ctrl_id):
    """通过控制器ID，获取对应的节点ID

    :param is_high_end: 是否V6高端
    :param ctrl_id: 控制器ID
    :return:
    """
    if not ctrl_id or len(ctrl_id) < 2:
        return False, ""
    eng_id = int(ctrl_id[:-1])
    ctrl_name = ctrl_id[1]
    if is_high_end:
        node_id = eng_id * 4 + CTRL_NAME_TO_NODE_MAP.get(ctrl_name)
    else:
        node_id = eng_id * 2 + CTRL_NAME_TO_NODE_MAP.get(ctrl_name)
    return True, str(node_id)


def get_node_id_by_ctrl_id(ctrl_id, engine_height):
    eng_id = int(ctrl_id[:-1])
    ctrl_name = ctrl_id[1]
    node_id = eng_id * engine_height + CTRL_NAME_TO_NODE_MAP.get(ctrl_name)
    return str(node_id)
