# -*- coding: UTF-8 -*-
"""
仅封装装换之前的接口，不单独实现接口
专门用于将不纯粹的接口（含有java调用）包装为可以单独Mock的接口
允许在方法内部import，防止import扩散，不利于单元测试。
"""
from cbb.frame.dsl import adapter as dsl_adapter


def get_system_version(context):
    from cbb.frame.cli.cliUtil import getSystemVersion
    return getSystemVersion(dsl_adapter.get_con(context, conn_to_ctrl=False),
                            dsl_adapter.get_lang(context))


def get_system_version_with_ret(context):
    from cbb.frame.cli.cliUtil import get_system_version_with_ret
    return get_system_version_with_ret(dsl_adapter.get_con(context, conn_to_ctrl=False),
                                       dsl_adapter.get_lang(context))


def compare_version(version1, version2):
    from utils import Products
    return Products.compareVersion(version1, version2)


def is_digital_ver(device_version):
    from utils import Products
    return Products.isDigitalVer(device_version)
