# -*- coding: UTF-8 -*-

"""
功能：自动选择rest or tlv 连接
"""
from cbb.frame.base import baseUtil
from cbb.frame.context import contextUtil


class ResourceType():
    """ 连接类型的枚举 """
    REST = "restImpl"
    TLV = "tlvImpl"


class ResourceSelector():
    """ 连接类型的选择器 """
    def __init__(self, context):
        self.logger = contextUtil.getLogger(context)
        self.devVersion = contextUtil.getCurVersion(context)
        self.devType = contextUtil.getDevType(context)

    def commonSelector(self):
        """ rest和TLV连接的通用选择器方法 """
        self.logger.info("commonSelector devType=%s, "
                         "devVersion=%s" % (self.devType, self.devVersion))
        if baseUtil.isSupportRest(self.devType, self.devVersion):
            self.logger.info("user rest adapter.")
            return ResourceType.REST
        else:
            self.logger.info("user tlv adapter.")
            return ResourceType.TLV

    def hostLinkSelector(self):
        """ 查询主机链路信息的rest和TLV连接的选择器方法 """
        if baseUtil.isSupportRest(self.devType, self.devVersion):
            return ResourceType.REST
        else:
            return ResourceType.TLV
