# -*- coding: UTF-8 -*-
import baseUtil

# 分发包后状态轮询次数
UPLOAD_PACKAGE_POLL_TIMES = 27 * 6
# 分发包后状态轮询间隔时间
UPLOAD_PACKAGE_POLL_INTERVAL = 10

# 下发升级命令后状态轮询次数
UPGRADE_PACKAGE_POLL_TIMES = 60 * 12
# 下发修复命令后状态轮询次数
REPAIR_POLL_TIMES = 6 * 3

# 下发升级命令后状态轮询间隔时间
UPGRADE_PACKAGE_POLL_INTERVAL = 10

# 升级后是否启动安装补丁的轮询次数(2分钟)
BEFORE_PATCH_POLL_TIMES = 12
# 升级后是否启动安装补丁轮询间隔时间
BEFORE_PATCH_POLL_INTERVAL = 10

# 系统异常重启后工具重连次数
UPGRADE_REBOOT_AFTER_CONNECT_TIMES = 90
# 系统异常重启后工具重连间隔时间
UPGRADE_REBOOT_AFTER_CONNECT_INTERVAL = 30

# 执行TLV命令默认超时时间
CMD_DEFAULT_TIMEOUT = 60 * 5

# 执行分发检查项包的超时时间21分钟
DISTRIBUTE_PKG_TIMEOUT = 21*60

# 设置小补丁升级间隔时间，范围是0.5~300，单位：秒
SET_HOTPATCH_INTERVAL = "set.hotpatch.interval"

# OM处理失败错误码
OM_OPERATE_FAIL_CODE = 1077949004
# 补丁包安全上限，以Byte为单位
PATCH_SAFE_SIZE_V3R3 = 32 * 1024 * 1024

RESULT_NOCHECK = "NOCHECK"
RESULT_NOSUPPORT = "NOSUPPORT"
RESULT_WARNING = "WARNING"


class PATCH_TYPE:
    HOT_PATCH = 'HOT'


class CMO_EXE_UPD_MSGTYPE:
    ASL_PATCH_MSGTYPE = 9
    HOT_PATCH_MSGTYPE = 7


class TLV_CMD:
    OM_MSG_OP_LST_VER = 8599109735  # 获取系统版本号
    EXC_UPD = 8599117931
    OM_MSG_OP_GET_PACKAGE_UPLOADPATH = 8599109754
    OM_MSG_OP_UPD_LST_SYS_PROGRESS = 8599109744
    OM_MSG_OP_NOTIFY_PACKAGE_PATH = 8599117947
    OM_MSG_OP_UPD_LIST_DETAILINFO = 8599150995
    OM_MSG_OP_UPD_GET_DISK_RESULT = 8599117939
    OM_MSG_OP_UPD_DISK_FIRMWARE = 8599117938
    GET = 55834574848
    GET_BATCH_NEXT = 55834624000  # 批量查询对象


class TLV_OM_OBJ_E:
    SYSTEM = 201
    FAN_CTRL_MODULE = 306


class CheckStatus:
    PASS = 0
    NOTPASS = 1
    NOCHECK = 2
    EXECUTING = 3
    SUCCEED = 4
    FAILED = 5


class TLV_PACKAGE_TYPE:
    UPG_PATCH = 7  # 升级中补丁包
    ASL_PATCH_PKG = 5
    HOT_PATCH_PKG = 3
    PARALLEL_PKG = 4
    SYS_UPGRADE_PKG = 1  # 系统升级包类型
    POWER_BBU_PKG = 10  # 电源BBU升级包
    POWER_BBU_PKG_DORADO = 11  # Dordao 的电源BBU升级包


class OM_MSG_OP_UPD_LST_SYS_PROGRESS:
    UPD_READY = 0  # 初始化状态
    UPD_DLDING = 4  # 下载中
    UPD_DLD_SUCCESS = 5  # 下载成功
    UPD_DLD_FAIL = 6  # 下载失败
    UPD_UPDING = 10  # 升级中
    UPD_UPD_SUCCESS = 11  # 升级成功
    UPD_UPD_FAIL = 12  # 升级失败
    UPD_ROLLBACKING = 13  # 回滚中
    UPD_ROLLBACK_SUCCESS = 14  # 回滚成功
    UPD_ROLLBACK_FAIL = 15  # 回滚失败


# 升级前检查类型
SYS_UPG_CHECK_TYPE = {
    'FAST': 'FastUpgrade',
    'ROLL_ONLINE': 'RollUpgradePreCheck',
    'ROLL_OFFLINE': 'OfflinePreCheck',
}

DISK_UPG_CHECK_TYPE = {
    'ONLINE': 'OnlineDiskUpgPreCheck',
    'OFFLINE': 'OfflineDiskUpgPreCheck'
}


class CheckStatusInspect:
    PASS = "0"
    NOTPASS = "1"
    NOCHECK = "2"
    NO_SUPPORT = "3"
    WARNING = "4"

    @staticmethod
    def getMergeStatus(allStatus):
        if CheckStatusInspect.NOTPASS in allStatus:
            return False
        if CheckStatusInspect.NOCHECK in allStatus:
            return RESULT_NOCHECK
        if CheckStatusInspect.WARNING in allStatus:
            return RESULT_WARNING
        if CheckStatusInspect.NO_SUPPORT in allStatus:
            return RESULT_NOSUPPORT
        return True

    @staticmethod
    def getMergeStatusByPath(allStatus):
        if False in allStatus:
            return False
        if CheckStatusInspect.NOTPASS in allStatus:
            return False
        if RESULT_NOCHECK in allStatus:
            return RESULT_NOCHECK
        if RESULT_WARNING in allStatus:
            return True
        if RESULT_NOSUPPORT in allStatus:
            return RESULT_NOSUPPORT
        return True


class CheckResult:
    def __init__(self, status, cliRet=None, errMsg="", data=None):
        self.status = status
        self.cliRet = cliRet
        self.errMsg = errMsg
        self.data = data

    def toScriptResult(self):
        if not self.cliRet:
            self.cliRet = []
        return self.status, "\n".join(self.cliRet), self.errMsg

    @staticmethod
    def getMergeResult(allResultDict, lang):
        errKey2HostDict = {}
        for key, checkResult in allResultDict.items():
            errKey = checkResult[1]
            if not errKey:
                continue
            if errKey not in errKey2HostDict.keys():
                errKey2HostDict[errKey] = []
            errKey2HostDict[errKey].append(key)

        allStatus = map(lambda x: x[0], allResultDict.values())
        status = CheckStatusInspect.getMergeStatus(allStatus)
        errMsg = ""
        if errKey2HostDict:
            for errKey, hostIds in errKey2HostDict.items():
                errMsg += baseUtil.getMsg(lang, errKey, ", ".join(hostIds))
        return status, errMsg

    @staticmethod
    def getMergeResultStr(allResultDict, lang):
        errKey2HostDict = {}
        for key, checkResult in allResultDict.items():
            errKey = checkResult[1]
            if not errKey:
                continue
            if errKey not in errKey2HostDict.keys():
                errKey2HostDict[errKey] = []
            errKey2HostDict[errKey].append(key)

        allStatus = map(lambda x: x[0], allResultDict.values())
        status = CheckStatusInspect.getMergeStatusByPath(allStatus)
        errMsg = ""
        if errKey2HostDict:
            for errKey, hostIds in errKey2HostDict.items():
                errMsg += baseUtil.getPyResource(lang, errKey,
                                                 ", ".join(hostIds))
        return status, errMsg
