# coding:utf-8
"""
@version: Toolkit V200R006C00
@time: 2019/11/08
@file: sqlite_context.py
@function:
@modify:
"""
from cbb.frame.util import sqlite_util
from cbb.frame.cli import sqlite_config


def get_sqlite_conn_from_context(context, dev_sn, logger):
    """
    获取缓存中的数据库连接，如果不存在则创建连接并放入缓存。
    设计是 每个设备一个数据库，context中缓存每个dev自己的连接。
    preinspect中初始化，postinspect中释放连接。
    :param context:
    :param dev_sn:
    :param logger:
    :return:
    """

    sqlite_conn_dict = context.get(
        sqlite_config.SQLITE_CONN_DICT.format(dev_sn)
    )
    if not sqlite_conn_dict:
        logger.logInfo("conn dict is none, need init sqlite db")
        sqlite_conn = sqlite_util.ini_sqlite_db_for_dev(context, dev_sn,
                                                        logger)
        return sqlite_conn

    sqlite_conn = sqlite_conn_dict.get(dev_sn, {}).get(
        sqlite_config.SQLITE_CONN)

    if not sqlite_conn:
        logger.logInfo("conn is none, need init sqlite db")
        sqlite_conn = sqlite_util.ini_sqlite_db_for_dev(context, dev_sn,
                                                        logger)
        return sqlite_conn

    if sqlite_conn.isClosed():
        db_path = get_db_path_from_context(context, dev_sn)
        if not db_path:
            logger.logInfo("path is none, need init sqlite db")
            sqlite_conn = sqlite_util.ini_sqlite_db_for_dev(context, dev_sn,
                                                            logger)
        else:
            sqlite_conn = sqlite_util.create_new_conn(db_path)
            set_sqlite_conn_to_context(context, dev_sn, sqlite_conn, db_path)

    return sqlite_conn


def set_sqlite_conn_to_context(context, dev_sn, conn, db_path):
    """
    设置缓存。
    :param context:
    :param dev_sn:
    :param conn:
    :return:
    """

    tmp_dict = context.get(sqlite_config.SQLITE_CONN_DICT.format(dev_sn))
    if not tmp_dict:
        tmp_dict = {}
    dev_dict = tmp_dict.get(dev_sn, {})
    dev_dict[sqlite_config.SQLITE_CONN] = conn
    dev_dict[sqlite_config.SQLITE_DB_CREATED_FLAG] = True
    dev_dict[sqlite_config.SQLITE_CONN_DB_PATH] = db_path
    tmp_dict[dev_sn] = dev_dict
    context.put(sqlite_config.SQLITE_CONN_DICT.format(dev_sn), tmp_dict)


def set_sqlite_db_path_to_context(context, dev_sn, db_path):
    """
    设置缓存。
    :param context:
    :param dev_sn:
    :param db_path:
    :return:
    """
    tmp_dict = context.get(sqlite_config.SQLITE_CONN_DICT.format(dev_sn))
    if not tmp_dict:
        tmp_dict = {}
    dev_dict = tmp_dict.get(dev_sn, {})
    dev_dict[sqlite_config.SQLITE_CONN_DB_PATH] = db_path
    tmp_dict[dev_sn] = dev_dict
    context.put(sqlite_config.SQLITE_CONN_DICT.format(dev_sn), tmp_dict)


def get_db_path_from_context(context, dev_sn):
    """
    用于tear down时删除数据库文件。
    :param context:
    :param dev_sn:
    :return: 文件路径
    """
    sqlite_conn_dict = context.get(
        sqlite_config.SQLITE_CONN_DICT.format(dev_sn)
    )
    if not sqlite_conn_dict:
        return None

    tmp_dict = sqlite_conn_dict.get(dev_sn, {})
    return tmp_dict.get(sqlite_config.SQLITE_CONN_DB_PATH)
