# -*- coding: UTF-8 -*-

#  Copyright (c) Huawei Technologies Co., Ltd. 2019-2021. All rights reserved.

import cbb.frame.base.resource as resource

NEED_NEW_CTRL_CONN = "need_new_ctrl_conn"


def get_vertical_ret(cli_ret):
    from cbb.frame.cli.cliUtil import getVerticalCliRet
    ret = getVerticalCliRet(cli_ret)
    if isinstance(ret, list) and len(ret) > 0:
        return ret[0]
    return {}


def get_horizontal_ret(cli_ret):
    from cbb.frame.cli.cliUtil import getHorizontalCliRet
    return getHorizontalCliRet(cli_ret)


def get_diagnose_desc(logger, lang, diagnose):
    from cbb.frame.base.baseUtil import getPyResource
    logger.info(str(diagnose.error_code))
    error_key = "diagnose.code." + str(diagnose.error_code)
    err_msg = getPyResource(lang, error_key)
    if diagnose.params and len(diagnose.params) > 0:
        err_msg = getPyResource(lang, error_key).format(diagnose.params)
    controller = "[{}]:".format(diagnose.ctrl)
    return controller + err_msg


def get_con(context):
    from cbb.frame.cli.cli_con_mgr import get_ctrl_cli
    cli = context.get('cli')
    return get_ctrl_cli(context, cli)


def exec_cli(context, cmd, lang="zh"):
    sn = get_sn(context)
    result = context.get("offlineCmdService").getCmdRet(sn, cmd)
    if result:
        return True, result
    return False, ""


def exec_developer(context, cmd, lang="zh"):
    sn = get_sn(context)
    result = context.get("offlineCmdService").getCmdRet(sn, cmd)
    if result:
        return True, result
    return False, ""


def exec_diagnose(context, cmd, lang="zh"):
    sn = get_sn(context)
    result = context.get("offlineCmdService").getCmdRet(sn, cmd, context.get('current_exec_node', ''))
    if result:
        return True, result
    return False, ""


def exec_mini_system(context, cmd, lang="zh"):
    sn = get_sn(context)
    result = context.get("offlineCmdService").getCmdRet(sn, cmd, context.get('current_exec_node', ''))
    if result:
        return True, result
    return False, ""


def exec_log_dsl(context, cause_id):
    sn = get_sn(context)
    result = context.get("treeAnalyser").queryAnalyseResult(sn, cause_id)
    if result and result.getMatchLogs():
        return True, [log.getContent() for log in result.getMatchLogs()], result.getVariables()
    return False, "", ""


def exec_rest(context, uri, method):
    from cbb.frame.rest.restUtil import Tlv2Rest
    from cbb.frame.rest import restData
    sn = get_sn(context)
    response = context.get("offlineCmdService").getCmdRet(sn, uri)
    response_dict = Tlv2Rest.convertRecord2Dict(response)
    error_info = Tlv2Rest.getErrInfo(response_dict)
    error_code = Tlv2Rest.getErrorTetail(error_info, restData.ErrorInfo.CODE)
    if error_code == "0":
        data = Tlv2Rest.getData(response_dict)
        if data is None:
            data = []
        return data
    else:
        description = Tlv2Rest.getErrorTetail(error_info, restData.ErrorInfo.DESCRIPTION)
        raise Exception(int(error_code), description)


def get_logger(context):
    return context.get("logger")


def get_lang(context):
    from cbb.frame.context.contextUtil import getLang
    return getLang(context)


def get_dev_type(context):
    return get_dev(context).get("type")


def get_dev_version(context):
    return get_dev(context).get("version")


def save_result(sn, cmd, value, node=""):
    # noinspection PyUnresolvedReferences
    from com.huawei.ism.tool.fdt.cache import DslResultRecordService
    DslResultRecordService.save(sn, cmd, value, node)


def get_result(sn, cmd, node=""):
    # noinspection PyUnresolvedReferences
    from com.huawei.ism.tool.fdt.cache import DslResultRecordService
    return DslResultRecordService.get(sn, cmd, node)


def get_dev(context):
    """获取上下文对象中dev对象

    :param context: 上下文对象
    :return:
    """
    from java.util import Map
    dev_obj = context.get("dev")
    if isinstance(dev_obj, Map):
        return dev_obj
    return context.get('newDev')


def get_sn(context):
    return get_dev(context).get("sn")


def get_msg(lang, msg, args="", resource=resource.MESSAGES_DICT):
    """消息国际化

    :param lang: 语言lang
    :param msg: 消息
    :param args: 消息参数
    :param resource: 消息字典
    :return: 经过国际化处理后的消息
    """
    errMsg = "--"
    # noinspection PyBroadException
    try:
        if msg not in resource.keys():
            return errMsg

        localeDict = resource.get(msg)
        if lang not in localeDict.keys():
            return errMsg

        localeMsg = localeDict.get(lang)
        if "%s" in localeMsg or "%i" in localeMsg:
            return localeMsg % args
        else:
            return localeMsg

    except Exception:
        return errMsg


def exec_on_all(dsl_context):
    from cbb.frame.cli.execute_on_all_controllers import (
        ExeOnAllCtrlContext,
        FuncResult,
        ResultType
    )
    from cbb.frame.cli.cliUtil import getVerticalCliRet, getHorizontalCliRet

    def _fun(exe_context):
        # 从原始context中取出传入的实际参数，包括函数名和函数的入参
        context = exe_context.original_context
        args = context["args"]
        func = args[0]
        params = args[1:]
        dsl_context.context['current_exec_node'] = str(exe_context.cur_ctrl_id)
        try:
            result = func(*params)
            context["ctrl_results"][exe_context.cur_ctrl_id] = result
        except Exception:
            context["ctrl_results"][exe_context.cur_ctrl_id] = None
        finally:
            dsl_context.context['current_exec_node'] = ''
        return FuncResult(ResultType.SUCCESS, need_continue_exe=True)

    dsl_context.context["ctrl_results"] = {}
    dsl_context.context["args"] = dsl_context.args
    exe_context = ExeOnAllCtrlContext(dsl_context.context)
    flag, result = exec_cli(dsl_context.context, "showsysstatus")
    get_logger(dsl_context.context).info("exec_on_all cmd showsysstatus result: {}".format(result))
    node_info_list = getVerticalCliRet(result)
    get_logger(dsl_context.context).info("exec_on_all node_info_list result: {}".format(node_info_list))
    ctrl_list = getHorizontalCliRet(result)
    exec_ctrl = []

    if "target_ctrl" in dsl_context.kwargs:
        target_ctrl = dsl_context.kwargs.get("target_ctrl")
        if isinstance(target_ctrl, list):
            exec_ctrl = (int(node) for node in target_ctrl)
        if "master" == target_ctrl:
            ctrl_list = filter(lambda item: item.get('role') == 'master', ctrl_list)
            exec_ctrl = [int(x.get('id')) for x in ctrl_list]

    node_num = 0
    if node_info_list:
        node_num = int(node_info_list[0].get("node cfg", "1"))
    cur_ctrl_id = 0
    while cur_ctrl_id < node_num:
        if bool(exec_ctrl) and cur_ctrl_id not in exec_ctrl:
            cur_ctrl_id += 1
            continue
        exe_context._cur_ctrl_id = cur_ctrl_id
        _fun(exe_context)
        cur_ctrl_id = cur_ctrl_id + 1
    return dsl_context.context["ctrl_results"]
