# -*- coding: UTF-8 -*-


class FaultNode:
    def __init__(self, node_id, name):
        self.id = node_id
        self.name = name
        self.children = []
        self.parent = None
        self.result = None
        self.running_status = None
        self.init_script = node_id + "_init"
        self.run_script = node_id + "_check"
        self.after_script = node_id + "_after"


class DiagnoseCode:
    def __init__(self, error_code, ctrl="ALL", *args):
        self.error_code = error_code
        self.ctrl = ctrl
        self.params = args


class NodeResult:
    def __init__(self):
        self.id = ""
        self.status = NodeStatus.NO_START
        self.detail = ""
        self.suggestion = ""
        self.origin_info = ""
        self.name = ""
        self.err_code = ""
        self.tables = {}
        self.case = ""

    def keys(self):
        return ("id", "name", "status", "err_code", "detail",
                "suggestion", "origin_info", "tables", "case")

    def __getitem__(self, item):
        return getattr(self, item)


class NodeStatus:
    NO_HIT = "PASS"
    HIT = "FAILED"
    NO_CHECK = "NO_CHECK"
    NO_START = "NO_START"
    SUCCESS = "SUCCESS"
    HUNG = "HUNG"
    WARNING = "WARNING"
    RUNNING = "RUNNING"
