# -*- coding: UTF-8 -*-
#  Copyright (c) Huawei Technologies Co., Ltd. 2022-2023. All rights reserved.
import importlib

from cbb.frame.context import contextUtil
from cbb.frame.base import config
from cbb.business.operate.fru.common import FuncFactory
from cbb.business.operate.fru.common import BaseFactory

ability_map = {
    (tuple(config.OCEAN_STOR_COMPUTING_DEVS), ""):
        {"get_all_port": "get_all_port_for_compute",
         "getUnsupportIntfIdList": "get_unsupport_intf_id_list_for_compute",
         "getLinkedPortsInfo": "get_linked_ports_info_for_compute",
         "powerOff": "power_off_compute_system",
         "queryOnePortInitiators": "query_one_port_initiators_for_compute",
         "_set_id_list_for_ctrl": "_set_id_list_for_compute_ctrl",
         "backUpMgmPortInfo": "backup_manage_port_info_for_compute",
         "backUpFanInfo": "backup_fan_info_for_compute",
         "backUpPowerInfo": "backup_power_info_for_compute",
         "get_online_power": "get_online_power_for_compute",
         "get_running_fans": "get_running_fans_for_compute",
         "get_v6_dev_guide_file_info": "get_compute_guide_file_info",
         "get_enc_name": "get_enc_name_for_compute",
         "getGuideConfFile": "get_guide_conf_file_for_compute",
         "update_linkup_port_num": "update_linkup_port_num_for_compute",
         "get_effect_port_dict": "get_effect_port_dict_for_compute",
         "get_unlinked_port_location_list": "get_unlinked_port_location_list_for_compute"},
    (tuple(config.OCEAN_STOR_MICRO_DEVS), ""):
        {"getLinkedPortsInfo": "get_linked_ports_info_for_micro_dev"},
    (tuple(config.DORADO_2000_AND_PROTECT_X3000 + config.HYBRID_V6_ENTRY_LEVEL_END), ""):
        {"get_v6_dev_guide_file_info": "get_guide_file_info_for_dorado_2000",
         "getGuideConfFile": "get_guide_conf_file_for_dorado_2000"},
}


def ability_mapping(fun):
    def wapper(*args, **kwargs):

        context = args[0]
        BaseFactory.log.info(context, "args={}, kwargs={}".format(args, kwargs))
        product_model = contextUtil.getProductModel(context)
        product_version = FuncFactory.getProductVersion(context)
        BaseFactory.log.info(context, "product_model={}, product_version={}".format(product_model, product_version))
        func = ""
        for product_info, check_method in ability_map.items():
            if product_model not in product_info[0]:
                continue
            if product_info[1] and product_version < product_info[1]:
                continue
            if fun.__name__ in check_method:
                func = check_method.get(fun.__name__)
        BaseFactory.log.info(context, "func={}".format(func))
        if func:
            module = importlib.import_module(fun.__module__)
            BaseFactory.log.info(context, "module={}".format(module))
            check_item_obj = getattr(module, func)

            return check_item_obj(*args, **kwargs)
        else:
            return fun(*args, **kwargs)

    return wapper
