/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.uMate.common.rest.https;

import com.huawei.uMate.common.log.Logger;
import com.huawei.uMate.common.rest.https.CertService;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;

public class HttpsCertManager {
    private static final Logger LOGGER = new Logger(HttpsCertManager.class);
    private static final HttpsCertManager INSTANCE = new HttpsCertManager();
    private static SSLSocketFactory sslServerSocketFactory;
    private CertService certService = new CertService();

    public static HttpsCertManager getInstance() {
        return INSTANCE;
    }

    public SSLContext getSSLContext(String protocol, boolean isVerifyCert) {
        return this.certService.getSSLContext(protocol, isVerifyCert);
    }

    public SSLContext getSSLContext(String protocol) {
        return this.getSSLContext(protocol, false);
    }

    public boolean updateCert(String certPath) {
        return this.certService.updateCert(certPath);
    }

    public SSLSocketFactory getSslSocketFactory() {
        return this.getSslServerSocketFactory();
    }

    public SSLSocketFactory getSslServerSocketFactory() {
        return this.getSslServerSocketFactory(false);
    }

    public SSLSocketFactory getSslServerSocketFactory(boolean isReloadCert) {
        if (sslServerSocketFactory == null || isReloadCert) {
            try {
                sslServerSocketFactory = this.certService.getSSLFactory().get();
                LOGGER.info("getSslServerSocketFactory: success.");
            }
            catch (NoSuchAlgorithmException e) {
                LOGGER.error("getSslServerSocketFactory: NoSuchAlgorithmException");
            }
            catch (KeyStoreException e) {
                LOGGER.error("getSslServerSocketFactory: KeyStoreException");
            }
        }
        return sslServerSocketFactory;
    }
}

