/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.uMate.common.rest.https;

import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import com.huawei.uMate.common.log.Logger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.math.BigInteger;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPublicKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;

public class TrustCertificateService {
    private static final Logger LOGGER = new Logger(TrustCertificateService.class);
    private static final int BIG_INTEGER_SIGNUM_POSITIVE = 1;
    private static final int BIG_INTEGER_TO_STR_RADIO = 16;
    private static final int CERTS_TYPE_DEV = 0;
    private static final int CERTS_TYPE_THIRD_SYSTEM = 1;
    private static TrustCertificateService instance = new TrustCertificateService();
    private Map<Integer, Set<X509Certificate>> trustedCertsMap;
    private Set<String> localServerCertPubKeys;
    private KeyStore trustKeyStore = null;
    private List<String> supportCerts;

    private TrustCertificateService() {
        this.initSupportCerts();
        this.initCertMap();
        this.updateCertsAndKeyStore();
    }

    private void initCertMap() {
        this.trustedCertsMap = new HashMap<Integer, Set<X509Certificate>>();
        this.trustedCertsMap.put(0, new HashSet());
        this.trustedCertsMap.put(1, new HashSet());
    }

    public static TrustCertificateService getInstance() {
        return instance;
    }

    private void updateCertsAndKeyStore() {
        this.loadTrustCerts();
        this.initKeyStore();
    }

    private void initSupportCerts() {
        this.supportCerts = new ArrayList<String>();
        this.supportCerts.add("pem");
        this.supportCerts.add("cer");
        this.supportCerts.add("crt");
        this.supportCerts.add("der");
        this.supportCerts.add("p7b");
    }

    private void initKeyStore() {
        this.updateKeyStore(0);
        this.updateKeyStore(1);
    }

    private boolean updateKeyStore(int certsType) {
        this.trustKeyStore = null;
        try {
            if (this.trustedCertsMap.get(certsType).isEmpty()) {
                return false;
            }
            this.trustKeyStore = KeyStore.getInstance("JKS");
            this.trustKeyStore.load(null, null);
            int count = 1;
            for (Certificate certificate : this.trustedCertsMap.get(certsType)) {
                this.trustKeyStore.setCertificateEntry("TurstCer" + count++, certificate);
            }
        }
        catch (KeyStoreException e) {
            LOGGER.error("initKeyStore by trustedCerts error.", e);
            return false;
        }
        catch (Exception e) {
            LOGGER.error("initKeyStore by trustedCerts error, unknown exception", e);
            return false;
        }
        return true;
    }

    private void loadTrustCerts() {
        String certDirPath = this.getServerCertPath();
        if (StringUtils.isBlank(certDirPath)) {
            return;
        }
        File certDir = FileUtils.getFile(certDirPath);
        File[] certFiles = certDir.listFiles();
        if (certFiles == null) {
            return;
        }
        for (File certItem : certFiles) {
            this.loadCert(certItem, 0);
        }
    }

    public boolean updateCert(String certPath) {
        File certItem;
        if (!this.trustedCertsMap.isEmpty() && !this.trustedCertsMap.get(1).isEmpty()) {
            this.trustedCertsMap.get(1).clear();
        }
        return this.loadCert(certItem = FileUtils.getFile(certPath), 1) && this.updateKeyStore(1);
    }

    public KeyStore getTrustKeyStore() {
        return this.trustKeyStore;
    }

    private boolean loadCert(File certItem, int certsType) {
        this.localServerCertPubKeys = new HashSet<String>();
        try (FileInputStream certFile = FileUtils.openInputStream(certItem);){
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            Collection<? extends Certificate> x509Certs = certificateFactory.generateCertificates(certFile);
            for (X509Certificate x509Certificate : x509Certs) {
                x509Certificate.checkValidity();
                LOGGER.info(String.format(Locale.ROOT, "load crt correct. file name:%s", certItem.getName()));
                this.trustedCertsMap.get(certsType).add(x509Certificate);
            }
        }
        catch (FileNotFoundException e) {
            LOGGER.error("load cert FileNotFoundException error.");
            return false;
        }
        catch (Exception e) {
            LOGGER.error("load cert Exception error.", e);
            return false;
        }
        return true;
    }

    public boolean hasRemoteCerEqualLocal(X509Certificate[] remoteCert) {
        LOGGER.info(String.format(Locale.ROOT, "remoteCert size:%s", remoteCert.length));
        for (X509Certificate certificate : remoteCert) {
            for (String localServerCertPubKey : this.localServerCertPubKeys) {
                if (!this.convertPubKeyToStr(certificate).equalsIgnoreCase(localServerCertPubKey)) continue;
                return true;
            }
        }
        return false;
    }

    private String convertPubKeyToStr(X509Certificate x509Certificate) {
        RSAPublicKey rsaPublicKey = (RSAPublicKey)x509Certificate.getPublicKey();
        return new BigInteger(1, rsaPublicKey.getEncoded()).toString(16);
    }

    private String getServerCertPath() {
        String path = ApplicationContext.getInstance().getWorkPath() + File.separator + "config/certs";
        try {
            String certPath = FileUtils.getFile(path).getCanonicalPath();
            return certPath;
        }
        catch (IOException e) {
            return "";
        }
    }
}

