/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.uMate.common.rest.services;

import com.huawei.uMate.common.log.Logger;
import com.huawei.uMate.common.rest.RedfishConnestion;
import com.huawei.uMate.common.rest.RedfishResult;
import com.huawei.uMate.common.rest.ReqConfig;
import com.huawei.uMate.common.rest.services.IRedfishConnAttrService;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;

public class RedfishConnAttrService
implements IRedfishConnAttrService {
    private static final Logger LOGGER = new Logger(RedfishConnAttrService.class);

    @Override
    public Map<String, String> queryAuthToken(RedfishConnestion redfishConn) {
        String authHeader = redfishConn.getAuthHeader();
        HashMap<String, String> tokenData = new HashMap<String, String>();
        if (StringUtils.isEmpty(authHeader)) {
            LOGGER.error("query device token error.authHeader is empty");
            return tokenData;
        }
        String authInfo = authHeader.replace("Basic ", "");
        String planeInfo = "";
        if (!StringUtils.isBlank(authInfo) && Base64.decodeBase64(authInfo) != null) {
            planeInfo = new String(Base64.decodeBase64(authInfo));
        }
        String[] info = planeInfo.split(":");
        HashMap<String, String> param = new HashMap<String, String>(2);
        param.put("UserName", info[0]);
        param.put("Password", info[1]);
        ReqConfig cfg = new ReqConfig();
        cfg.setTrTryTimes(0);
        RedfishResult result = redfishConn.executePost("/redfish/v1/SessionService/Sessions", param, null, cfg);
        if (result.isSuccess()) {
            tokenData.put("X-Auth-Token", result.getHeaders().get("X-Auth-Token"));
            tokenData.put("Id", result.getResultJSON().getString("Id"));
            return tokenData;
        }
        LOGGER.error(String.format(Locale.ENGLISH, "query device token error,errorcode:%s:%s", result.getErrorCode(), result.getResult()));
        return tokenData;
    }

    @Override
    public void releaseSessionWithToken(RedfishConnestion redfishConn, String tokenId) {
        if (StringUtils.isEmpty(tokenId)) {
            LOGGER.info(String.format(Locale.ENGLISH, "tokenId is empty:%s", tokenId));
            return;
        }
        ReqConfig config = new ReqConfig();
        config.setTrTryTimes(0);
        RedfishResult releaseResult = redfishConn.executeDelete("/redfish/v1/SessionService/Sessions/" + tokenId, config);
        LOGGER.info(String.format(Locale.ENGLISH, "release result:%s", releaseResult.getErrorCode()));
    }
}

