/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.uMate.common.utils;

import com.huawei.ism.thread.AsyncExcutor;
import com.huawei.ism.tool.base.utils.StreamUtils;
import com.huawei.ism.tool.base.utils.executor.CmdExecutor;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.uMate.common.SystemConfig;
import com.huawei.uMate.common.log.Logger;
import com.huawei.uMate.common.utils.CmdResult;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Locale;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;

public class CommandExecutor {
    private static final Logger LOGGER = new Logger(CommandExecutor.class);
    private static final int CONCURRENT_NUMBER = SystemConfig.createSystemConfig().getIntConfigValue("external_exe_concurrent_number", 10);
    private static final Semaphore ASYNC_SEMPHORE = new Semaphore(CONCURRENT_NUMBER);
    private static int ipmiMode = -1;
    private static final int NO_TIME_OUT = -1;

    public static CmdResult execute(String cmd, boolean enableForceExit) {
        return CommandExecutor.execute(cmd, enableForceExit, 120);
    }

    public static CmdResult execute(String cmd, int timeOut) {
        return CommandExecutor.execute(cmd, false, timeOut);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CmdResult execute(String cmdPara, boolean enableForceExit, int timeOut) {
        CmdResult cmdResult = new CmdResult();
        Process pro = null;
        cmdResult.setExitCode(-1);
        ProcessStreamClearCall streamClear = null;
        try {
            ASYNC_SEMPHORE.acquire();
            pro = Runtime.getRuntime().exec(cmdPara);
            streamClear = new ProcessStreamClearCall(pro, enableForceExit);
            Future future = AsyncExcutor.submit((Callable)streamClear);
            future.get(timeOut == -1 ? Integer.MAX_VALUE : (long)timeOut, TimeUnit.SECONDS);
            cmdResult.setExitCode(pro.exitValue());
            cmdResult.setOutPut(streamClear.getOutBuff().toString());
            cmdResult.setErrorPut(streamClear.getErrorBuff().toString());
        }
        catch (RuntimeException e1) {
            cmdResult.setOutPut(streamClear == null ? "execute command error." : streamClear.getOutBuff().toString());
            cmdResult.setErrorPut("cmd execute error.");
            LOGGER.error("error to execute!", e1);
        }
        catch (Exception e1) {
            cmdResult.setOutPut("execute command error.");
            cmdResult.setErrorPut("cmd execute error.");
            LOGGER.error("error!", e1);
        }
        finally {
            ASYNC_SEMPHORE.release();
            CommandExecutor.handleResult(cmdPara, cmdResult, pro, streamClear);
        }
        return cmdResult;
    }

    private static void handleResult(String cmd, CmdResult cmdResult, Process pro, ProcessStreamClearCall streamClear) {
        if (pro != null) {
            StreamUtils.closeResource(null, (Closeable)pro.getInputStream());
            StreamUtils.closeResource(null, (Closeable)pro.getErrorStream());
            StreamUtils.closeResource(null, (Closeable)pro.getOutputStream());
            try {
                pro.destroy();
            }
            catch (Exception e) {
                LOGGER.error("error!", e);
            }
        }
        if (streamClear != null && cmdResult.getExitCode() != 0) {
            LOGGER.info(String.format(Locale.ENGLISH, "ErrorPut:%s OutPut:%s", streamClear.getErrorBuff().toString(), streamClear.getOutBuff().toString()));
        }
        if (cmd.contains("ipmi.exe")) {
            int startIdxOfP = cmd.indexOf("-P") + 1;
            int endIdxOfP = startIdxOfP > 1 ? cmd.substring(startIdxOfP).indexOf(32) : 0;
            String cmdSub = endIdxOfP > 0 ? cmd.substring(endIdxOfP) : null;
            LOGGER.info(String.format(Locale.ENGLISH, "ipmi cmd:[%s] exec result:[%s]" + System.lineSeparator() + "ipmi cmd ret end.", cmdSub, streamClear == null ? "null" : streamClear.getOutBuff().toString()));
        }
    }

    private static void checkRunMode() {
        LOGGER.info(String.format(Locale.ENGLISH, "CONCURRENT_NUMBER:%d", CONCURRENT_NUMBER));
        CmdResult cmdResult = CommandExecutor.execute("tools/ipmitool/ipmitool.exe -test");
        boolean isMonitor = cmdResult.getExitCode() == 0 && cmdResult.getOutPut().contains("test ipmitool");
        ipmiMode = isMonitor ? 1 : 0;
        LOGGER.info(String.format(Locale.ENGLISH, "test result:%s,mode:%d", cmdResult.getOutPut(), ipmiMode));
    }

    public static boolean isRunInTest() {
        return ipmiMode == 1;
    }

    public static CmdResult execute(String cmd) {
        return CommandExecutor.execute(cmd, false);
    }

    public static CmdResult executeNoTimeOut(String cmd) {
        return CommandExecutor.execute(cmd, false, -1);
    }

    static {
        CommandExecutor.checkRunMode();
    }

    private static class ProcessStreamClearCall
    implements Callable<String> {
        private StringBuffer outBuff = new StringBuffer();
        private StringBuffer errorBuff = new StringBuffer();
        private InputStream outInput;
        private InputStream errorInput;
        private OutputStream outOutput;
        private Process process;
        private boolean enableForceExit;

        public ProcessStreamClearCall(Process pro, boolean enableForceExit) {
            this.process = pro;
            this.outInput = pro.getInputStream();
            this.errorInput = pro.getErrorStream();
            this.outOutput = pro.getOutputStream();
            this.enableForceExit = enableForceExit;
        }

        public StringBuffer getOutBuff() {
            return this.outBuff;
        }

        public StringBuffer getErrorBuff() {
            return this.errorBuff;
        }

        @Override
        public String call() {
            try {
                while (true) {
                    Thread.sleep(1000L);
                    this.readData(this.outBuff, this.outInput, true);
                    this.readData(this.errorBuff, this.errorInput, false);
                    try {
                        this.process.exitValue();
                    }
                    catch (IllegalThreadStateException e) {
                        continue;
                    }
                    break;
                }
            }
            catch (RuntimeException e) {
                ToolLoggerFactory.getLogger(CmdExecutor.class).error("error!", e);
            }
            catch (Exception e) {
                ToolLoggerFactory.getLogger(CmdExecutor.class).error("error!", e);
            }
            return this.outBuff.toString();
        }

        private void readData(StringBuffer bwOut, InputStream input, boolean isStdInput) throws IOException {
            try {
                int readed;
                byte[] data;
                String result;
                int aval = input.available();
                if (aval == 0) {
                    if (isStdInput && this.enableForceExit) {
                        this.outOutput.write("\r\n".getBytes());
                        this.outOutput.write("exit".getBytes());
                        this.outOutput.flush();
                    }
                    return;
                }
                if (aval > 0 && !(result = new String(data = new byte[aval], 0, readed = input.read(data), Charset.defaultCharset())).isEmpty()) {
                    bwOut.append(result);
                }
            }
            catch (Exception e) {
                ToolLoggerFactory.getLogger(CmdExecutor.class).error("error to read!", e);
            }
        }
    }
}

