/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.uMate.common.utils;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.huawei.uMate.common.log.Logger;
import com.huawei.uMate.common.rest.RedfishResult;
import com.huawei.uMate.common.utils.ResUtil;
import org.apache.commons.lang3.StringUtils;

public class RedfishUtils {
    public static final String REDFISH_CONNECT_FAIL = "Failed to establish a redfish connection to the host, please check your network.";
    private static final ResUtil RES = ResUtil.getInstance("common");
    private static final Logger LOGGER = new Logger(RedfishUtils.class);
    private static final String NET_DISCONNECT = "-100";
    private static final String KEY_HUAWEI = "Huawei";
    private static final String KEY_PUBLIC = "Public";

    public static boolean hasKeyObject(String objectStr, String ... keys) {
        try {
            JSONObject object = JSONObject.parseObject(objectStr);
            return RedfishUtils.hasKeyObject(object, keys);
        }
        catch (Exception e) {
            LOGGER.error("parse error" + objectStr);
            return false;
        }
    }

    public static boolean hasKeyObject(JSONObject object, String ... keys) {
        if (object == null || keys == null) {
            return false;
        }
        JSONObject iterObj = object;
        try {
            for (int i = 0; i < keys.length; ++i) {
                String key = keys[i];
                if (i == keys.length - 1) {
                    return iterObj.containsKey(key);
                }
                iterObj = iterObj.getJSONObject(key);
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static <T> T getDfttAttr(String objectStr, Class<T> clazz, T defaultVal, String ... keys) {
        T value = RedfishUtils.getObjectAttr(objectStr, clazz, keys);
        return value == null ? defaultVal : value;
    }

    public static <T> T getDfttAttr(JSONObject object, Class<T> clazz, T defaultVal, String ... keys) {
        T value = RedfishUtils.getObjectAttr(object, clazz, keys);
        return value == null ? defaultVal : value;
    }

    public static <T> T getObjectAttr(String objectStr, Class<T> clazz, String ... keys) {
        try {
            JSONObject object = JSONObject.parseObject(objectStr);
            return RedfishUtils.getObjectAttr(object, clazz, keys);
        }
        catch (Exception e) {
            LOGGER.error("error to get value" + objectStr, e);
            return null;
        }
    }

    public static String getStringAttr(String objectStr, String ... keys) {
        return RedfishUtils.getObjectAttr(objectStr, String.class, keys);
    }

    public static <T> T getObjectAttr(JSONObject object, Class<T> clazz, String ... keys) {
        if (keys == null) {
            return (T)object;
        }
        if (object == null) {
            LOGGER.warn("getObjectAttr param invalid..");
            return null;
        }
        JSONObject iterObj = object;
        try {
            for (int i = 0; i < keys.length; ++i) {
                String key = keys[i];
                if (i == keys.length - 1) {
                    if (clazz.equals(String.class)) {
                        return (T)iterObj.getString(key);
                    }
                    if (JSONArray.class.equals(clazz)) {
                        return (T)iterObj.getJSONArray(key);
                    }
                    if (JSONObject.class.equals(clazz)) {
                        return (T)iterObj.getJSONObject(key);
                    }
                    if (Integer.class.equals(clazz)) {
                        return (T)iterObj.getInteger(key);
                    }
                    if (Boolean.class.equals(clazz)) {
                        return (T)iterObj.getBoolean(key);
                    }
                    LOGGER.warn("Class not support in getObjectAttr");
                    continue;
                }
                iterObj = iterObj.getJSONObject(key);
            }
        }
        catch (Exception e) {
            LOGGER.error("error to get value", e);
            return null;
        }
        return null;
    }

    private static JSONObject compativeHuaweiAndPublic(JSONObject object, String key) {
        JSONObject result = object.getJSONObject(key);
        if (result == null && key.equals(KEY_HUAWEI)) {
            result = object.getJSONObject(KEY_PUBLIC);
        }
        return result;
    }

    public static String appendOriginError(String errorTip, RedfishResult result) {
        if (!result.isSuccess() && RedfishUtils.hasKeyObject(result.getResultJSON(), "error", "@Message.ExtendedInfo")) {
            JSONArray attends = RedfishUtils.getObjectAttr(result.getResultJSON(), JSONArray.class, "error", "@Message.ExtendedInfo");
            if (attends == null || attends.isEmpty()) {
                return errorTip;
            }
            JSONObject attendFirst = attends.getJSONObject(0);
            if (RedfishUtils.hasKeyObject(attendFirst, "Message") && RedfishUtils.hasKeyObject(attendFirst, "Resolution")) {
                String msg = attendFirst.getString("Message");
                String resolution = attendFirst.getString("Resolution");
                return RES.getString("common.message.redfish.fail.tip", errorTip, msg, resolution);
            }
        } else {
            if ("-2".equals(result.getErrorCode())) {
                return RES.getString("common.message.redfish.fail.tip", errorTip, result.getErrorMsg(), result.getSoluation());
            }
            return errorTip;
        }
        return errorTip;
    }

    public static String appendAtlasError(String errorTip, RedfishResult result) {
        String message = "";
        if (result.getErrorCode() != null && result.getResultJSON() != null) {
            message = result.getErrorMsg() != null ? result.getErrorMsg() : result.getResultJSON().getString("message");
            return RES.getString("ies.config.redfish.fail.tip", errorTip, result.getErrorCode(), message);
        }
        if (NET_DISCONNECT.equals(result.getErrorCode())) {
            return RES.getString("ies.config.redfish.fail.tip", errorTip, result.getErrorCode(), RES.getString("ies.config.redfish.network.tip"));
        }
        if ("-2".equals(result.getErrorCode())) {
            return RES.getString("ies.config.redfish.fail.tip", errorTip, result.getErrorCode(), result.getErrorMsg());
        }
        if ("-1".equals(result.getErrorCode())) {
            return RES.getString("ies.config.redfish.fail.tip", errorTip, result.getErrorCode(), result.getErrorMsg());
        }
        return errorTip;
    }

    public static String appendAtlasNetError(String errorTip, RedfishResult result) {
        String message = "";
        if (result.getErrorCode() != null && result.getResultJSON() != null) {
            message = result.getErrorMsg() != null ? result.getErrorMsg() : result.getResultJSON().getString("message");
            return RES.getString("ies.config.redfish.fail.tip", errorTip, result.getErrorCode(), message);
        }
        if (NET_DISCONNECT.equals(result.getErrorCode())) {
            return RES.getString("ies.config.redfish.fail.tip", errorTip, result.getErrorCode(), RES.getString("ies.config.redfish.network.tip"));
        }
        if ("-2".equals(result.getErrorCode())) {
            return RES.getString("ies.config.redfish.fail.sug.tip", errorTip, result.getErrorCode(), result.getErrorMsg(), RES.getString("ies.config.redfish.network.tip"));
        }
        if ("-1".equals(result.getErrorCode())) {
            return RES.getString("ies.config.redfish.fail.sug.tip", errorTip, result.getErrorCode(), result.getErrorMsg(), RES.getString("ies.config.redfish.network.tip"));
        }
        return errorTip;
    }

    public static String getErrorMsg(RedfishResult result) {
        String message;
        boolean containsError;
        String resultStr = result.getResult();
        JSONObject resultObj = resultStr == null ? null : JSONObject.parseObject(resultStr);
        boolean bl = containsError = resultObj != null && resultObj.containsKey("error");
        message = containsError ? (StringUtils.isEmpty(message = resultObj.getJSONObject("error").getJSONArray("@Message.ExtendedInfo").getJSONObject(0).getString("Message")) ? REDFISH_CONNECT_FAIL : message) : REDFISH_CONNECT_FAIL;
        return message;
    }
}

