/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.uMate.common.utils;

import com.huawei.ism.tool.base.utils.DateUtil;
import com.huawei.ism.tool.base.utils.HtmlResUtils;
import com.huawei.ism.tool.base.utils.StreamUtils;
import com.huawei.uMate.common.GlobalStaticValue;
import com.huawei.uMate.common.SystemInfo;
import com.huawei.uMate.common.file.FileOperation;
import com.huawei.uMate.common.log.Logger;
import com.huawei.uMate.common.utils.AppContext;
import freemarker.cache.FileTemplateLoader;
import freemarker.cache.MruCacheStorage;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.Flushable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TemplateUtils {
    private static final Logger LOGGER = new Logger(TemplateUtils.class);
    private static final String UTF8ENCODE = "UTF-8";
    private static final Charset APP_CHARSET = StandardCharsets.UTF_8;
    private static final Configuration CONFIGURATION = new Configuration();
    private static final int MAX = 200;
    private static final int NUM_TEN = 20;

    private TemplateUtils() {
    }

    public static void setTemplateLoader(String ftlPath) {
        try {
            FileTemplateLoader fileTemplateLoader = null;
            fileTemplateLoader = new FileTemplateLoader(new File(ftlPath));
            CONFIGURATION.setTemplateLoader(fileTemplateLoader);
        }
        catch (Exception e) {
            LOGGER.error("build TemplateLoader faild. :", e);
        }
    }

    public static void addAppendixInfo(Map data) {
        data.put("OS", System.getProperty("os.name") + "," + System.getProperty("os.version"));
        data.put("user", System.getProperty("user.name"));
        data.put("java", System.getProperty("java.version"));
        data.put("start", SystemInfo.getTimeZoneDateStr(AppContext.START_TOOL_DATE.getTime()));
        data.put("end", SystemInfo.getTimeZoneDateStr(new Date().getTime()));
        data.put("curYear", String.valueOf(DateUtil.getUTCYear((Calendar)Calendar.getInstance())));
    }

    public static void addCoverInfo(Map data) {
        Pattern versionPattern = Pattern.compile("(V[0-9]*)");
        Matcher versionMatcher = versionPattern.matcher(GlobalStaticValue.UMATE_VERSION);
        data.put("uMate", versionMatcher.find() ? versionMatcher.group() : HtmlResUtils.getString((String)"appendix.default"));
        data.put("operateTime", SystemInfo.getTimeZoneDateStr(new Date().getTime()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static boolean processorFtl(String ftlPath, Object data, String outHtmlFilePath) {
        boolean flag;
        block7: {
            flag = false;
            BufferedWriter writer = null;
            try {
                File file = new File(outHtmlFilePath);
                FileOperation.mkdirs(new File(file.getParent()));
                writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outHtmlFilePath), APP_CHARSET));
                Template template = CONFIGURATION.getTemplate(ftlPath, UTF8ENCODE);
                template.process(data, writer);
                flag = true;
                StreamUtils.closeResource((Flushable)writer, (Closeable)writer);
            }
            catch (TemplateException | IOException e) {
                LOGGER.error("build freemarker template faild. path is :" + ftlPath, e);
            }
            catch (Exception e2) {
                LOGGER.error("the file path is null", e2);
                break block7;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                StreamUtils.closeResource(writer, writer);
            }
        }
        return flag;
    }

    static {
        try {
            CONFIGURATION.setCacheStorage(new MruCacheStorage(20, 200));
            CONFIGURATION.setLocale(Locale.getDefault());
            CONFIGURATION.clearEncodingMap();
            CONFIGURATION.setEncoding(Locale.CHINESE, UTF8ENCODE);
        }
        catch (Exception ex) {
            LOGGER.error("build TemplateLoader faild.", ex);
        }
    }
}

