/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.base.context;

import com.huawei.ism.tool.base.utils.ContextUtil;
import com.huawei.ism.tool.base.utils.ProperUtils;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.base.utils.crypto.AesCrypterManager;
import com.huawei.ism.tool.base.utils.crypto.EncryptEnum;
import java.io.File;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Optional;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EncryptContext {
    private static final Logger log = LoggerFactory.getLogger(EncryptContext.class);

    public AesCrypterManager getAnyEncryptManager() {
        AesCrypterManager anyExternal = this.findCanUseManager();
        if (anyExternal != null) {
            return anyExternal;
        }
        log.info("get use default encry manager");
        return this.getDefaultEncryptManager();
    }

    @Nullable
    private AesCrypterManager findCanUseManager() {
        Optional<AesCrypterManager> anyExternal = this.findByAppname();
        if (anyExternal.isPresent()) {
            log.info("found a manager by appname");
            return anyExternal.get();
        }
        anyExternal = Arrays.stream(EncryptEnum.values()).filter(encryptEnum -> encryptEnum != EncryptEnum.DEFAULT_KMC).map(EncryptEnum::getCrypterManager).filter(AesCrypterManager::isInitSuccess).findAny();
        if (anyExternal.isPresent()) {
            log.info("get {} encry manager", (Object)anyExternal.get().getClass().getName());
            return anyExternal.get();
        }
        return null;
    }

    private Optional<AesCrypterManager> findByAppname() {
        String tolBoxSysProp = Paths.get(ContextUtil.getToolBoxPath(), "configuration", "system.properties").toString();
        String appName = ProperUtils.getInstance().getValue(new File(tolBoxSysProp), "app.name");
        if (StringUtils.isNULLStr(appName)) {
            log.info("no app name found");
            return Optional.empty();
        }
        log.info("find manager for {}", (Object)appName);
        return EncryptEnum.of(appName);
    }

    public AesCrypterManager getDefaultEncryptManager() {
        return EncryptEnum.DEFAULT_KMC.getCrypterManager();
    }

    public static EncryptContext getInstance() {
        return EncryptContextHolder.INSTANCE;
    }

    private EncryptContext() {
    }

    private static class EncryptContextHolder {
        private static final EncryptContext INSTANCE = new EncryptContext();

        private EncryptContextHolder() {
        }
    }
}

