/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.base.start;

import com.huawei.ism.tool.base.start.AbstractStartParam;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NeedLoadJar
extends AbstractStartParam<Set<String>> {
    private static final Logger log = LoggerFactory.getLogger(NeedLoadJar.class);

    public NeedLoadJar(String[] args) {
        super(args, "-needLoadJar=");
    }

    @Override
    protected Set<String> parseNeedParam(String needParam) {
        return this.parseNeedLoadJar(needParam);
    }

    private Set<String> parseNeedLoadJar(String needLoadJar) {
        if (StringUtils.isBlank((CharSequence)needLoadJar)) {
            log.warn("need load jar is empty");
            return new HashSet<String>();
        }
        log.info("add need load jar path: {}", (Object)needLoadJar);
        String[] jars = needLoadJar.split(",");
        HashSet<String> result = new HashSet<String>();
        Arrays.stream(jars).filter(StringUtils::isNotBlank).map(String::trim).forEach(result::add);
        return result;
    }
}

