/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.base.utils;

import com.huawei.ism.tool.base.utils.FileUtils;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.base.utils.SystemEnvUtil;
import com.huawei.ism.tool.base.utils.VerifyUtil;
import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilePathUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(FilePathUtils.class);
    private static final String SCENE_FOLDER = "scene";
    private static final String SPACE = " ";
    private static final String UNDERLINE = "_";
    private static final String LINUX_PATH_SEPARATOR = "/";
    private static final String WINDOWS_PATH_SEPARATOR = "\\";

    private FilePathUtils() {
    }

    public static String filterFilePath(String filePath) {
        if (null == filePath) {
            return null;
        }
        return FilePathUtils.getCanonicalPath(new File(filePath));
    }

    public static File checkFile(File file) {
        File newFile;
        String newFilePath;
        String filePath = FilePathUtils.getCanonicalPath(file);
        String path = FilePathUtils.filterFilePath(filePath);
        if (!StringUtils.isNULLStr(path) && filePath.equals(newFilePath = FilePathUtils.getCanonicalPath(newFile = new File(path)))) {
            return newFile;
        }
        return file;
    }

    public static String checkFile(String path) {
        Object tempFile = null;
        if (null != path) {
            return FilePathUtils.filterFilePath(path);
        }
        return "";
    }

    public static String getSafePath(String path) {
        if (StringUtils.isNULLStr(path)) {
            return "";
        }
        return FilePathUtils.getCanonicalPath(new File(path));
    }

    public static String getCanonicalPath(File file) {
        String path = "";
        try {
            path = file.getCanonicalPath();
        }
        catch (IOException e) {
            LOGGER.error("getCanonicalPath has IOException");
        }
        return path;
    }

    public static String getSubSceneFilePath(String fieldId, String sceneId, String xmlName) {
        String subSceneFilePath = ApplicationContext.getInstance().getWorkPath() + File.separator + SCENE_FOLDER + File.separator + fieldId + File.separator + sceneId.replace(SPACE, UNDERLINE) + File.separator + xmlName;
        return subSceneFilePath;
    }

    public static void deleteEmptyLocalScene(String fieldId, String folderName, String fileName) {
        String subSceneFilePath = FilePathUtils.getSubSceneFilePath(fieldId, folderName, fileName);
        File subSceneFile = new File(subSceneFilePath);
        if (subSceneFile.exists() && subSceneFile.isFile() && subSceneFile.length() == 0L) {
            FileUtils.deleteAllInFolder(subSceneFilePath);
        }
    }

    public static List<File> listAllFiles(File entrance, String innerPath, boolean excludeDirectory) {
        if (VerifyUtil.isEmpty(entrance) || !entrance.exists()) {
            LOGGER.error("File does not exist");
            return new ArrayList<File>(1);
        }
        String regularizedInnerPath = FilePathUtils.pathRegularize(innerPath);
        ArrayList<File> filesList = new ArrayList<File>();
        File[] files = entrance.listFiles();
        if (files == null) {
            LOGGER.error("files is null!");
            return filesList;
        }
        filesList.addAll(Arrays.asList(files));
        for (File file2 : files) {
            if (!file2.isDirectory()) continue;
            filesList.addAll(FilePathUtils.listAllFiles(file2, innerPath, excludeDirectory));
        }
        if (excludeDirectory) {
            filesList.removeIf(nextFile -> nextFile.isDirectory());
        }
        filesList.removeIf(file -> !FilePathUtils.pathRegularize(FilePathUtils.getCanonicalPath(file)).contains(regularizedInnerPath));
        return filesList;
    }

    public static String pathRegularize(String originalString) {
        String regularizedPath = originalString.replace(LINUX_PATH_SEPARATOR, File.separator);
        regularizedPath = regularizedPath.replace(WINDOWS_PATH_SEPARATOR, File.separator);
        return regularizedPath;
    }

    public static String pathRestriction(String path) {
        String canonicalizedPath = FilePathUtils.checkFile(path);
        String defaultUserDir = FilePathUtils.pathRegularize(SystemEnvUtil.getDefaultUserDir());
        if (!FilePathUtils.pathRegularize(canonicalizedPath).contains(defaultUserDir)) {
            LOGGER.error("Unrestricted path non-identical to user.dir detected, as possibly a path-manipulation case.");
            return "";
        }
        return canonicalizedPath;
    }

    public static String filterPath(String path, List<String> blackList, List<String> whiteList) {
        if (VerifyUtil.isEmpty(path)) {
            return "";
        }
        String canonicalized = FilePathUtils.checkFile(path);
        String regularized = FilePathUtils.pathRegularize(canonicalized);
        if (!VerifyUtil.isEmpty(blackList) && blackList.stream().anyMatch(filter -> !VerifyUtil.isEmpty(filter) && StringUtils.hasMatchStr(regularized, filter))) {
            LOGGER.error("Path blocked by blacklist");
            return "";
        }
        if (!VerifyUtil.isEmpty(whiteList) && whiteList.stream().anyMatch(filter -> !VerifyUtil.isEmpty(filter) && !StringUtils.hasMatchStr(regularized, filter))) {
            LOGGER.error("Path blocked by whitelist");
            return "";
        }
        return canonicalized;
    }

    public static String filterPath(String path) {
        if (VerifyUtil.isEmpty(path)) {
            return "";
        }
        List<String> blackList = FilePathUtils.buildDefaultBlacklist();
        return FilePathUtils.filterPath(path, blackList, null);
    }

    private static List<String> buildDefaultBlacklist() {
        ArrayList<String> blackList = new ArrayList<String>();
        blackList.add("^C:\\Windows\\System32");
        blackList.add("^C:\\Windows\\boot");
        blackList.add("^/usr/src/kernel");
        blackList.add("^/usr/src/linux");
        return blackList;
    }
}

