/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.base.utils;

import com.huawei.ism.tool.base.utils.FileUtils;
import com.huawei.ism.tool.base.utils.StreamUtils;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.base.utils.UnZipLimit;
import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import com.huawei.ism.tool.framework.pubservice.exception.EncapsulatedRuntimeException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.zip.Adler32;
import java.util.zip.CheckedOutputStream;
import java.util.zip.GZIPInputStream;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Zip;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.bzip2.CBZip2InputStream;
import org.apache.tools.tar.TarEntry;
import org.apache.tools.tar.TarInputStream;
import org.apache.tools.tar.TarOutputStream;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipFile;
import org.apache.tools.zip.ZipOutputStream;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ZipUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ZipUtils.class);
    private static final int BUFF_SIZE = 1024;
    private static final String TAR_APPENDIX = ".tar";
    private static final String CHARSET_GBK = "GBK";

    private ZipUtils() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean checkExistSubObj(File file, String subObjName) throws IOException {
        try (ZipFile zipFile = new ZipFile(file);){
            boolean bl = null != zipFile.getEntry(subObjName);
            return bl;
        }
        catch (Exception e) {
            LOGGER.error("checkExistSubObj error", (Throwable)e);
            return false;
        }
    }

    public static void decompressTarGzFile(File tarfile, String toPath) throws IOException {
        ZipUtils.decompressTarGzFile(tarfile, ZipUtils.filterZipEntryName(toPath), ApplicationContext.getInstance().getMaxUnzipFileSize(), ApplicationContext.getInstance().getMaxUnzipFileNum());
    }

    public static void decompressTarGzFile(File tarfile, String toPath, long maxSize, long maxNum) throws IOException {
        ZipUtils.validateZipFileSize(tarfile);
        ZipUtils.decompressTarGzFile(tarfile, ZipUtils.filterZipEntryName(toPath), new UnZipLimit(maxSize, maxNum));
    }

    private static void decompressTarGzFile(File tarfile, String toPath, UnZipLimit limit) throws IOException {
        try (FileInputStream fis = new FileInputStream(tarfile);
             BufferedInputStream bis = new BufferedInputStream(fis);
             GZIPInputStream gzis = new GZIPInputStream(bis);
             TarInputStream tarIn = new TarInputStream((InputStream)gzis, 1024);){
            FileUtils.createDir(toPath);
            ZipUtils.unZipAndGetEntryNameListFromTarGzFile(tarIn, toPath, limit);
        }
    }

    private static void validateZipFileSize(File file) throws IOException {
        if (!FileUtils.fileSize4GInvalid(file)) {
            throw new IOException("the file size is over 4G. " + file.getName());
        }
    }

    private static void unZipTarGzFile(TarInputStream tarInput, String toPath, long maxSize, long maxNum) throws IOException {
        ZipUtils.unZipAndGetEntryNameListFromTarGzFile(tarInput, toPath, maxSize, maxNum);
    }

    public static List<String> unZipAndGetEntryNameListFromTarGzFile(TarInputStream tarInput, String toPath, long maxSize, long maxNum) throws IOException {
        return ZipUtils.unZipAndGetEntryNameListFromTarGzFile(tarInput, ZipUtils.filterZipEntryName(toPath), new UnZipLimit(maxSize, maxNum));
    }

    private static List<String> unZipAndGetEntryNameListFromTarGzFile(TarInputStream tarInput, String toPath, UnZipLimit limit) throws IOException {
        TarEntry entry;
        ArrayList<String> fileList = new ArrayList<String>();
        while ((entry = tarInput.getNextEntry()) != null) {
            String name = ZipUtils.filterZipEntryName(entry.getName());
            fileList.add(name);
            limit.increaseOneFileNum();
            ZipUtils.checkUnzipLimit(limit, toPath);
            if (entry.isDirectory()) {
                FileUtils.createDir(toPath + File.separator + name);
                continue;
            }
            File tmpFile = new File(toPath + File.separator + name);
            File parentDir = tmpFile.getParentFile();
            if (!parentDir.exists()) {
                boolean makeDirSuccess = parentDir.mkdirs();
                LOGGER.info("Make dirs for {} result {}.", (Object)parentDir.getCanonicalPath(), (Object)makeDirSuccess);
            }
            ZipUtils.outputTarFile(tarInput, tmpFile, toPath, limit);
        }
        return fileList;
    }

    private static void outputTarFile(TarInputStream tarInput, File tmpFile, String toPath, UnZipLimit limit) throws IOException {
        try (FileOutputStream output = new FileOutputStream(tmpFile);){
            int length;
            byte[] buffer = new byte[1024];
            while ((length = tarInput.read(buffer)) != -1) {
                ((OutputStream)output).write(buffer, 0, length);
                limit.increaseFileSize(length);
                ZipUtils.checkUnzipLimit(limit, toPath);
            }
        }
    }

    public static boolean decompressTarFile(File tarFile, String toPath) {
        return ZipUtils.decompressTarFile(tarFile, ZipUtils.filterZipEntryName(toPath), new UnZipLimit());
    }

    /*
     * Exception decompiling
     */
    private static boolean decompressTarFile(File tarFile, String toPath, UnZipLimit limit) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void decompressFile(File file, String toPath) throws IOException {
        ZipUtils.decompressInnerFiles(file, ZipUtils.filterZipEntryName(toPath), "");
    }

    public static void decompressInnerFiles(File zFile, String toPath, String innerPath) throws IOException {
        String actualToPath = ZipUtils.filterZipEntryName(toPath);
        if (!FileUtils.fileSize4GInvalid(zFile)) {
            throw new IllegalArgumentException("the file too big" + zFile);
        }
        UnZipLimit limit = new UnZipLimit();
        try (ZipFile zipFile = new ZipFile(zFile);){
            Enumeration zEnumeration = zipFile.getEntries();
            while (zEnumeration.hasMoreElements()) {
                boolean delete;
                File tf;
                ZipEntry zipEntry = (ZipEntry)zEnumeration.nextElement();
                limit.increaseOneFileNum();
                ZipUtils.checkUnzipLimit(limit, actualToPath);
                String fileName = ZipUtils.filterZipEntryName(zipEntry.getName());
                if (!fileName.contains(innerPath)) continue;
                if (zipEntry.isDirectory()) {
                    FileUtils.createDir(actualToPath + File.separator + fileName);
                    continue;
                }
                ZipUtils.unZipFile(zipEntry, zipFile, actualToPath, limit);
                fileName = Normalizer.normalize(fileName, Normalizer.Form.NFKC);
                if (fileName.endsWith(TAR_APPENDIX)) {
                    tf = new File(actualToPath, fileName);
                    ZipUtils.decompressTarFile(tf, actualToPath, limit);
                    delete = tf.delete();
                    LOGGER.info("{} , delete = {}", (Object)tf.getCanonicalPath(), (Object)delete);
                    continue;
                }
                if (!fileName.endsWith(".tgz")) continue;
                tf = new File(actualToPath, fileName);
                ZipUtils.decompressTarGzFile(tf, actualToPath, limit);
                delete = tf.delete();
                LOGGER.info("{} , delete = {}", (Object)tf.getCanonicalPath(), (Object)delete);
            }
        }
    }

    public static void decompressFileForWindows(File file, String toPath) throws IOException {
        if (ApplicationContext.getInstance().isWindowsOS()) {
            ZipUtils.decompressInnerFilesForWindows(file, ZipUtils.filterZipEntryNameForWindows(toPath), "");
        } else {
            ZipUtils.decompressInnerFiles(file, ZipUtils.filterZipEntryName(toPath), "");
        }
    }

    public static void decompressInnerFilesForWindows(File zFile, String toPathString, String innerPath) throws IOException {
        String toPath = ZipUtils.filterZipEntryNameForWindows(toPathString);
        if (!FileUtils.fileSize4GInvalid(zFile)) {
            throw new IllegalArgumentException("the file too big" + zFile);
        }
        UnZipLimit limit = new UnZipLimit();
        try (ZipFile zipFile = new ZipFile(zFile);){
            Enumeration zEnumeration = zipFile.getEntries();
            while (zEnumeration.hasMoreElements()) {
                boolean delete;
                File tf;
                ZipEntry zipEntry = (ZipEntry)zEnumeration.nextElement();
                limit.increaseOneFileNum();
                ZipUtils.checkUnzipLimit(limit, toPath);
                String fileName = ZipUtils.filterZipEntryNameForWindows(zipEntry.getName());
                if (!fileName.contains(innerPath)) continue;
                if (zipEntry.isDirectory()) {
                    FileUtils.createDir(toPath + File.separator + fileName);
                    continue;
                }
                ZipUtils.unZipFileForWindows(zipEntry, zipFile, toPath, limit);
                fileName = Normalizer.normalize(fileName, Normalizer.Form.NFKC);
                if (fileName.endsWith(TAR_APPENDIX)) {
                    tf = new File(toPath, fileName);
                    ZipUtils.decompressTarFile(tf, toPath, limit);
                    delete = tf.delete();
                    LOGGER.info("{} , delete = {}", (Object)tf.getCanonicalPath(), (Object)delete);
                    continue;
                }
                if (!fileName.endsWith(".tgz")) continue;
                tf = new File(toPath, fileName);
                ZipUtils.decompressTarGzFile(tf, toPath, limit);
                delete = tf.delete();
                LOGGER.info("{} , delete = {}", (Object)tf.getCanonicalPath(), (Object)delete);
            }
        }
    }

    public static void decompressInnerFilesWithExThrow(File zFile, String toPath, String innerPath) throws IOException {
        ZipUtils.decompressInnerFilesWithExThrowAndTarIgnoreUnzip(zFile, toPath, innerPath, true);
    }

    public static void decompressInnerFilesWithExThrowAndTarIgnoreUnzip(File zFile, String toPath, String innerPath, boolean needUnzipTar) throws IOException {
        String actualToPath = ZipUtils.filterZipEntryName(toPath);
        if (!FileUtils.fileSize4GInvalid(zFile)) {
            throw new IllegalArgumentException("the file too big" + zFile);
        }
        UnZipLimit limit = new UnZipLimit();
        try (ZipFile zipFile = new ZipFile(zFile);){
            Enumeration zEnumeration = zipFile.getEntries();
            while (zEnumeration.hasMoreElements()) {
                limit.increaseOneFileNum();
                ZipUtils.checkUnzipLimit(limit, actualToPath);
                ZipEntry zipEntry = (ZipEntry)zEnumeration.nextElement();
                if (!zipEntry.getName().contains(innerPath)) continue;
                ZipUtils.decompressFromInnerPath(actualToPath, zipFile, zipEntry, limit, needUnzipTar);
            }
        }
        catch (IOException e) {
            throw new IOException("Failed to decompress from inner files.");
        }
    }

    private static void checkUnzipLimit(UnZipLimit limit, String toPath) throws IOException {
        if (limit.isFileNumOverLimit()) {
            String msg = "Unzip file num more than limit " + limit.getMaxNum();
            LOGGER.error(msg);
            FileUtils.clearDir(toPath);
            throw new IOException(msg);
        }
        if (limit.isFileSizeOverLimit()) {
            FileUtils.clearDir(toPath);
            LOGGER.error("Current file unzip size  is too larger than limit {} mb.", (Object)(limit.getMaxSize() / 1024L / 1024L));
            throw new IOException("File too larger.");
        }
    }

    private static void decompressFromInnerPath(String toPath, ZipFile zipFile, ZipEntry zipEntry, UnZipLimit limit, boolean needUnzipTar) throws IOException {
        String fileName = ZipUtils.filterZipEntryName(zipEntry.getName());
        if (zipEntry.isDirectory()) {
            FileUtils.createDir(toPath + File.separator + fileName);
            return;
        }
        ZipUtils.unZipFile(zipEntry, zipFile, toPath, limit);
        fileName = Normalizer.normalize(fileName, Normalizer.Form.NFKC);
        if (needUnzipTar && fileName.endsWith(TAR_APPENDIX)) {
            File tf = new File(toPath, fileName);
            if (!ZipUtils.decompressTarFile(tf, toPath, limit)) {
                throw new IOException("Failed to decompress tar file");
            }
            boolean delete = tf.delete();
            LOGGER.info("{} , delete = {}", (Object)tf.getCanonicalPath(), (Object)delete);
        }
    }

    public static void decompressFilesUnlimite(File zFile, String toPath, String innerPath) throws IOException {
        String actualToPath = ZipUtils.filterZipEntryName(toPath);
        try (ZipFile zipFile = new ZipFile(zFile);){
            Enumeration zEnumeration = zipFile.getEntries();
            while (zEnumeration.hasMoreElements()) {
                ZipEntry zipEntry = (ZipEntry)zEnumeration.nextElement();
                String name = ZipUtils.filterZipEntryName(zipEntry.getName());
                if (!Normalizer.normalize(zipEntry.getName(), Normalizer.Form.NFKC).contains(innerPath)) continue;
                if (zipEntry.isDirectory()) {
                    FileUtils.createDir(actualToPath + File.separator + name);
                    continue;
                }
                ZipUtils.unZipFile(zipEntry, zipFile, actualToPath);
            }
        }
    }

    public static void decompressZipFile(String source, String toPath) {
        try {
            ZipUtils.decompressFile(new File(source), ZipUtils.filterZipEntryName(toPath));
        }
        catch (Exception e) {
            throw new EncapsulatedRuntimeException("decompress file " + source + " error.", e);
        }
    }

    /*
     * Exception decompiling
     */
    public static String readTxtFileOnZip(File zipFilePath, String pathAndName) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 20[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static Optional<InputStream> getStreamFileOnZip(File zipFilePath, String pathAndName) throws IOException {
        try (ZipFile zipFile = new ZipFile(zipFilePath);){
            Enumeration zEnumeration = zipFile.getEntries();
            ZipEntry zipEntry = null;
            while (zEnumeration.hasMoreElements()) {
                zipEntry = (ZipEntry)zEnumeration.nextElement();
                String fileName = ZipUtils.filterZipEntryName(zipEntry.getName());
                if (!(fileName = Normalizer.normalize(fileName, Normalizer.Form.NFKC)).equals(pathAndName)) continue;
                break;
            }
            if (zipEntry != null) {
                Optional<InputStream> optional = Optional.ofNullable(zipFile.getInputStream(zipEntry));
                return optional;
            }
        }
        return Optional.empty();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String readAllFromTar(InputStream in, String findFileName, UnZipLimit unZipLimit) {
        try (TarInputStream tarInput = new TarInputStream(in);){
            TarEntry te;
            do {
                if ((te = tarInput.getNextEntry()) == null) return null;
            } while (!te.getName().equals(findFileName));
            String string = StreamUtils.readStringFormInputStreamWithLimit((InputStream)tarInput, unZipLimit);
            return string;
        }
        catch (Exception e) {
            LOGGER.error("readAllFromTar file error .", (Throwable)e);
        }
        return null;
    }

    public static List<String> getListFiles(File zipFilePath) throws IOException {
        if (null == zipFilePath) {
            return new ArrayList<String>(0);
        }
        ArrayList<String> files = new ArrayList<String>();
        try (ZipFile zipFile = new ZipFile(zipFilePath);){
            Enumeration zEnumeration = zipFile.getEntries();
            while (zEnumeration.hasMoreElements()) {
                ZipEntry zipEntry = (ZipEntry)zEnumeration.nextElement();
                String fileName = zipEntry.getName();
                files.add(fileName);
            }
            ArrayList<String> arrayList = files;
            return arrayList;
        }
    }

    public static List<String> getListFiles(File zipFilePath, boolean excludeDirectory) throws IOException {
        if (null == zipFilePath) {
            return new ArrayList<String>(0);
        }
        ArrayList<String> files = new ArrayList<String>();
        try (ZipFile zipFile = new ZipFile(zipFilePath);){
            Enumeration zEnumeration = zipFile.getEntries();
            while (zEnumeration.hasMoreElements()) {
                ZipEntry zipEntry = (ZipEntry)zEnumeration.nextElement();
                if (excludeDirectory && zipEntry.isDirectory()) continue;
                String fileName = zipEntry.getName();
                files.add(fileName);
            }
            ArrayList<String> arrayList = files;
            return arrayList;
        }
    }

    public static List<String> getInnerListFiles(File zipFilePath, String innerPath, boolean excludeDirectory) throws IOException {
        if (null == zipFilePath) {
            return new ArrayList<String>(0);
        }
        ArrayList<String> files = new ArrayList<String>();
        try (ZipFile zipFile = new ZipFile(zipFilePath);){
            Enumeration zEnumeration = zipFile.getEntries();
            while (zEnumeration.hasMoreElements()) {
                String fileName;
                ZipEntry zipEntry = (ZipEntry)zEnumeration.nextElement();
                if (excludeDirectory && zipEntry.isDirectory() || !(fileName = zipEntry.getName()).contains(innerPath)) continue;
                files.add(fileName);
            }
            ArrayList<String> arrayList = files;
            return arrayList;
        }
    }

    private static void unZipFile(ZipEntry zipEntry, ZipFile zipFile, String toPath) throws IOException {
        ZipUtils.unZipFile(zipEntry, zipFile, toPath, 0L);
    }

    private static void unZipFile(ZipEntry zipEntry, ZipFile zipFile, String toPath, long maxSize) throws IOException {
        ZipUtils.unZipFile(zipEntry, zipFile, toPath, new UnZipLimit(maxSize, 0L));
    }

    private static void unZipFile(ZipEntry zipEntry, ZipFile zipFile, String toPath, UnZipLimit limit) throws IOException {
        byte[] buf = new byte[1024];
        File file = new File(toPath + File.separator + ZipUtils.filterZipEntryName(zipEntry.getName()));
        File parentFile = file.getParentFile();
        if (null != parentFile) {
            FileUtils.createDir(parentFile.getCanonicalPath());
        }
        try (BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(file.getCanonicalFile()));
             BufferedInputStream is = new BufferedInputStream(zipFile.getInputStream(zipEntry));){
            int readLen;
            while ((readLen = ((InputStream)is).read(buf, 0, 1024)) != -1) {
                ((OutputStream)os).write(buf, 0, readLen);
                limit.increaseFileSize(readLen);
                ZipUtils.checkUnzipLimit(limit, toPath);
            }
        }
    }

    private static void unZipFileForWindows(ZipEntry zipEntry, ZipFile zipFile, String toPath, UnZipLimit limit) throws IOException {
        byte[] buf = new byte[1024];
        File file = new File(toPath + File.separator + ZipUtils.filterZipEntryNameForWindows(zipEntry.getName()));
        File parentFile = file.getParentFile();
        if (parentFile != null) {
            FileUtils.createDir(parentFile.getCanonicalPath());
        }
        try (BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(file.getCanonicalFile()));
             BufferedInputStream is = new BufferedInputStream(zipFile.getInputStream(zipEntry));){
            int readLen;
            while ((readLen = ((InputStream)is).read(buf, 0, 1024)) != -1) {
                ((OutputStream)os).write(buf, 0, readLen);
                limit.increaseFileSize(readLen);
                ZipUtils.checkUnzipLimit(limit, toPath);
            }
        }
    }

    public static boolean compressFile(String copressFilePath, String srcFilePath) {
        return ZipUtils.compressFile(copressFilePath, srcFilePath, new File[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean compressFile(String copressFilePath, String srcFilePath, File ... excludeFiles) {
        boolean bl;
        ZipOutputStream out = null;
        FileOutputStream outputStream = null;
        CheckedOutputStream csum = null;
        try {
            outputStream = new FileOutputStream(copressFilePath);
            csum = new CheckedOutputStream(outputStream, new Adler32());
            out = new ZipOutputStream((OutputStream)new BufferedOutputStream(csum));
            out.setComment("ZIP Compressed.");
            out.setEncoding(CHARSET_GBK);
            File srcDir = new File(srcFilePath);
            ZipUtils.zipFile(out, srcDir, "", excludeFiles);
            LOGGER.info("Compress File success: {} ", (Object)srcFilePath);
            bl = true;
        }
        catch (Exception e) {
            boolean bl2;
            try {
                LOGGER.error("compress file error .", (Throwable)e);
                bl2 = false;
            }
            catch (Throwable throwable) {
                StreamUtils.closeStream(out, null);
                StreamUtils.closeStream(csum, null);
                StreamUtils.closeStream(outputStream, null);
                throw throwable;
            }
            StreamUtils.closeStream(out, null);
            StreamUtils.closeStream(csum, null);
            StreamUtils.closeStream(outputStream, null);
            return bl2;
        }
        StreamUtils.closeStream((OutputStream)out, null);
        StreamUtils.closeStream(csum, null);
        StreamUtils.closeStream(outputStream, null);
        return bl;
    }

    private static boolean needExclude(File tmpFile, File[] excludeFiles) {
        if (null == excludeFiles || excludeFiles.length < 1) {
            return false;
        }
        for (File file : excludeFiles) {
            if (!file.equals(tmpFile)) continue;
            return true;
        }
        return false;
    }

    private static void handleFileCompress(ZipOutputStream out, String filePath, File file) {
        try (BufferedInputStream bis = new BufferedInputStream(new FileInputStream(file));){
            int length;
            String entryPath = ZipUtils.getFilePath(filePath, file);
            out.putNextEntry(new ZipEntry(entryPath));
            byte[] bytes = new byte[1024];
            int off = 0;
            while ((length = bis.read(bytes, off, 1024)) != -1) {
                out.write(bytes, 0, length);
            }
        }
        catch (Exception e) {
            LOGGER.error("write zipEntry error.", (Throwable)e);
        }
    }

    private static void zipFile(ZipOutputStream out, File srcDir, String filePath, File[] excludeFiles) throws IOException {
        if (srcDir.isFile()) {
            ZipUtils.handleFileCompress(out, filePath, srcDir);
            return;
        }
        if (ZipUtils.zipEmptyDir(out, srcDir, filePath)) {
            return;
        }
        File[] fileList = srcDir.listFiles();
        if (null == fileList) {
            return;
        }
        for (File file : fileList) {
            if (ZipUtils.needExclude(file, excludeFiles)) continue;
            if (file.isDirectory()) {
                String filePathName = ZipUtils.getFilePath(filePath, file);
                ZipUtils.zipFile(out, file, filePathName, excludeFiles);
                continue;
            }
            ZipUtils.handleFileCompress(out, filePath, file);
        }
    }

    private static String getFilePath(String filePath, File file) {
        String filePathName = file.getName();
        if (!StringUtils.isNULLStr(filePath)) {
            filePathName = filePath + File.separator + file.getName();
        }
        return filePathName;
    }

    private static boolean zipEmptyDir(ZipOutputStream out, File srcDir, String filePath) throws IOException {
        File[] subFiles = srcDir.listFiles();
        if (subFiles == null || subFiles.length == 0) {
            if (StringUtils.isNULLStr(filePath)) {
                return true;
            }
            out.putNextEntry(new ZipEntry(filePath + "/"));
            out.closeEntry();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void tarHandleFileCompress(TarOutputStream out, String filePath, File file) throws IOException {
        BufferedInputStream bis = new BufferedInputStream(new FileInputStream(file));
        try {
            int length;
            String entryPath = ZipUtils.getFilePath(filePath, file);
            TarEntry entry = new TarEntry(entryPath);
            entry.setSize(file.length());
            out.putNextEntry(entry);
            byte[] bytes = new byte[1024];
            int off = 0;
            while ((length = bis.read(bytes, off, 1024)) > -1) {
                out.write(bytes, 0, length);
            }
        }
        catch (Exception e) {
            LOGGER.error("write tarEntry error.", (Throwable)e);
        }
        finally {
            try {
                bis.close();
                out.closeEntry();
            }
            catch (IOException e) {
                LOGGER.error("close inputStream error.", (Throwable)e);
            }
        }
    }

    private static boolean tarEmptyDir(TarOutputStream out, File srcDir, String filePath) throws IOException {
        File[] subFiles = srcDir.listFiles();
        if (subFiles == null || subFiles.length == 0) {
            if (StringUtils.isNULLStr(filePath)) {
                return true;
            }
            out.putNextEntry(new TarEntry(filePath + "/"));
            out.closeEntry();
            return true;
        }
        return false;
    }

    private static void tarFile(TarOutputStream out, File srcDir, String filePath, File[] excludeFiles) throws IOException {
        if (ZipUtils.tarEmptyDir(out, srcDir, filePath)) {
            return;
        }
        File[] fileList = srcDir.listFiles();
        if (null == fileList) {
            return;
        }
        for (File file : fileList) {
            if (ZipUtils.needExclude(file, excludeFiles)) continue;
            if (file.isDirectory()) {
                String filePathName = ZipUtils.getFilePath(filePath, file);
                ZipUtils.tarFile(out, file, filePathName, excludeFiles);
                continue;
            }
            ZipUtils.tarHandleFileCompress(out, filePath, file);
        }
    }

    public static boolean tarCompressFile(String copressFilePath, String srcFilePath) {
        return ZipUtils.tarCompressFile(copressFilePath, srcFilePath, new File[0]);
    }

    /*
     * Exception decompiling
     */
    public static boolean tarCompressFile(String copressFilePath, String srcFilePath, File ... excludeFiles) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static int countFromTar(File tarFile, String match) {
        int cnt = 0;
        if (null == tarFile || !tarFile.exists()) {
            LOGGER.error("The countFromTar file is valid.");
            return cnt;
        }
        try (TarInputStream tarIn = new TarInputStream((InputStream)new FileInputStream(tarFile));){
            TarEntry tarEntry = tarIn.getNextEntry();
            while (tarEntry != null) {
                if (tarEntry.getName().matches(match)) {
                    ++cnt;
                }
                tarEntry = tarIn.getNextEntry();
            }
        }
        catch (Exception e) {
            LOGGER.error("countFromTar file error .", (Throwable)e);
        }
        return cnt;
    }

    public static List<String> decompressFileAndGetFileNames(File file, String toPath, long maxSize, long maxNum) throws IOException {
        ZipUtils.validateZipFileSize(file);
        ArrayList<String> fileList = new ArrayList<String>();
        UnZipLimit limit = new UnZipLimit(maxSize, maxNum);
        try (ZipFile zipFile = new ZipFile(file);){
            Enumeration zEnumeration = zipFile.getEntries();
            while (zEnumeration.hasMoreElements()) {
                ZipEntry zipEntry = (ZipEntry)zEnumeration.nextElement();
                limit.increaseOneFileNum();
                ZipUtils.checkUnzipLimit(limit, toPath);
                String name = ZipUtils.filterZipEntryName(zipEntry.getName());
                fileList.add(name);
                if (zipEntry.isDirectory()) {
                    FileUtils.createDir(toPath + File.separator + name);
                    continue;
                }
                ZipUtils.unZipFile(zipEntry, zipFile, toPath, maxSize);
            }
        }
        return fileList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean decompressTarBz2File(File bz2File, String toPath, long maxSize, long maxNum) {
        boolean bl;
        if (!FileUtils.fileSize2GInvalid(bz2File)) {
            LOGGER.warn("the file size is over 2G. {}", (Object)bz2File.getName());
            return false;
        }
        TarInputStream tarInput = null;
        FileInputStream fis = null;
        BufferedInputStream bis = null;
        CBZip2InputStream cbZip2InputStream = null;
        try {
            fis = new FileInputStream(bz2File);
            bis = new BufferedInputStream(fis);
            bis.skip(2L);
            cbZip2InputStream = new CBZip2InputStream((InputStream)bis);
            tarInput = new TarInputStream((InputStream)cbZip2InputStream);
            FileUtils.createDir(toPath);
            ZipUtils.unZipTarGzFile(tarInput, toPath, maxSize, maxNum);
            bl = true;
        }
        catch (Exception e1) {
            boolean bl2;
            try {
                LOGGER.error("compress TarBz2File error", (Throwable)e1);
                bl2 = false;
            }
            catch (Throwable throwable) {
                StreamUtils.closeStream(null, cbZip2InputStream);
                StreamUtils.closeStream(null, bis);
                StreamUtils.closeStream(null, fis);
                StreamUtils.closeStream(null, tarInput);
                throw throwable;
            }
            StreamUtils.closeStream(null, cbZip2InputStream);
            StreamUtils.closeStream(null, bis);
            StreamUtils.closeStream(null, fis);
            StreamUtils.closeStream(null, tarInput);
            return bl2;
        }
        StreamUtils.closeStream(null, (InputStream)cbZip2InputStream);
        StreamUtils.closeStream(null, bis);
        StreamUtils.closeStream(null, fis);
        StreamUtils.closeStream(null, (InputStream)tarInput);
        return bl;
    }

    public static List<String> decompressTarGzFileAndGetFileNames(File tarfile, String toPath, long maxSize, long maxNum) throws IOException {
        ZipUtils.validateZipFileSize(tarfile);
        ArrayList<String> fileList = new ArrayList<String>();
        try (FileInputStream fis = new FileInputStream(tarfile);
             BufferedInputStream bis = new BufferedInputStream(fis);
             GZIPInputStream gzis = new GZIPInputStream(bis);
             TarInputStream tarIn = new TarInputStream((InputStream)gzis, 1024);){
            FileUtils.createDir(toPath);
            fileList.addAll(ZipUtils.unZipAndGetEntryNameListFromTarGzFile(tarIn, toPath, maxSize, maxNum));
        }
        return fileList;
    }

    public static String filterZipEntryName(String name) {
        if (name.contains("../") || name.contains("..\\")) {
            LOGGER.warn("Unsafe file name {}.", (Object)name);
            return name.replaceAll("\\.\\./", "").replaceAll("\\.\\.\\\\", "");
        }
        return name;
    }

    public static String filterZipEntryNameForWindows(String originName) {
        String name = originName.indexOf(":") == 1 ? originName.replaceAll("[:*?<>|\"]", "_").replaceFirst("_", ":") : originName.replaceAll("[:*?<>|\"]", "_");
        if (name.contains("../") || name.contains("..\\")) {
            LOGGER.warn("Unsafe file name {}.", (Object)name);
            return name.replaceAll("\\.\\./", "").replaceAll("\\.\\.\\\\", "");
        }
        return name;
    }

    public static void compressByAnt(String baseDir, String destName, Set<String> needFileFilter) {
        File src = new File(ZipUtils.filterZipEntryName(baseDir));
        if (!src.exists()) {
            LOGGER.error("filter path error {} not exits", (Object)baseDir);
            return;
        }
        File destFile = new File(ZipUtils.filterZipEntryName(baseDir + File.separator + destName));
        Zip zip = ZipUtils.generateZipObj(destFile, needFileFilter, src);
        zip.execute();
    }

    @NotNull
    private static Zip generateZipObj(File destFile, Set<String> needFileFilter, File src) {
        Zip zip = new Zip();
        zip.setDestFile(destFile);
        zip.setProject(ZipUtils.generateProject(src));
        if (needFileFilter != null) {
            needFileFilter.stream().map(filter -> ZipUtils.generateFileSet(src, zip.getProject(), filter)).forEach(arg_0 -> ((Zip)zip).addFileset(arg_0));
        }
        return zip;
    }

    @NotNull
    private static Project generateProject(File src) {
        Project project = new Project();
        project.setBaseDir(src);
        return project;
    }

    @NotNull
    private static FileSet generateFileSet(File src, Project project, String filter) {
        FileSet fileSet = new FileSet();
        fileSet.setProject(project);
        fileSet.setDir(src);
        fileSet.setIncludes(filter);
        return fileSet;
    }

    public static void checkUnzipLimit(UnZipLimit limit) throws IOException {
        ZipUtils.checkUnzipLimit(limit, "");
    }

    public static void checkUnzipRules(UnZipLimit limit, String tartgetfile) throws IOException {
        ZipUtils.checkUnzipFileRules(limit, tartgetfile);
    }

    private static void checkUnzipFileRules(UnZipLimit limit, String toPath) throws IOException {
        if (limit.isFileNumOverLimit()) {
            String msg = "Unzip file num more than limit " + limit.getMaxNum();
            LOGGER.error(msg);
            FileUtils.clearDir(toPath);
            throw new IOException(msg);
        }
        if (limit.isFileSizeOverLimit()) {
            FileUtils.clearDir(toPath);
            LOGGER.error("Current file unzip size  is too larger than limit {} mb.", (Object)(limit.getMaxSize() / 1024L / 1024L));
            throw new IOException("File too larger.");
        }
        if (limit.isTargetFileUsableSizeOverFileSize(new File(toPath))) {
            FileUtils.clearDir(toPath);
            LOGGER.error("The space occupied by the current file is greater than the disk space..");
            throw new IOException("insufficient disk space");
        }
    }
}

