/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.framework.platform.pubservice;

import com.huawei.ism.tool.base.utils.XmlUtils;
import com.huawei.ism.tool.base.utils.XmlWriter;
import com.huawei.ism.tool.framework.platform.common.data.FeatureData;
import com.huawei.ism.tool.framework.platform.exception.ToolException;
import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import com.huawei.ism.tool.framework.platform.util.UserOpDataSaveUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public final class StmTemporaryFileUtils {
    private static final Logger log = LoggerFactory.getLogger(StmTemporaryFileUtils.class);
    private static final String STM_RECORD_FILE_DIRECTORY = String.join((CharSequence)File.separator, "temp", "stmFeatureRecord");
    private static final String STM_RECORD_FILE_PUBLIC_PATH = String.join((CharSequence)File.separator, STM_RECORD_FILE_DIRECTORY, "stmRecord.xml");
    private static final String SUB_TOOLS_MAKE_DIR_PATH = String.join((CharSequence)File.separator, UserOpDataSaveUtil.getToolBoxPath(), STM_RECORD_FILE_DIRECTORY);
    private static final String SAVE_PATH = String.join((CharSequence)File.separator, UserOpDataSaveUtil.getToolBoxPath(), STM_RECORD_FILE_PUBLIC_PATH);
    private static final String READ_PATH = String.join((CharSequence)File.separator, ApplicationContext.getInstance().getWorkPath(), STM_RECORD_FILE_PUBLIC_PATH);
    private static final String XML_VER = "1.0";

    public static void saveStmRecord() {
        StmTemporaryFileUtils.makeSaveDir();
        Optional<Document> docOptional = StmTemporaryFileUtils.buildXmlDoc();
        if (docOptional.isPresent()) {
            Document doc = docOptional.get();
            StmTemporaryFileUtils.writeXmlFile(doc);
        } else {
            log.error("Failed to build XML document.");
        }
    }

    private static Document initDoc() {
        Document document = null;
        try {
            document = XmlUtils.newDocumentBuilder().newDocument();
            document.setXmlVersion(XML_VER);
        }
        catch (ParserConfigurationException e) {
            log.error("parse cfg error.");
        }
        return document;
    }

    private static void makeSaveDir() {
        try {
            Files.createDirectories(Paths.get(SUB_TOOLS_MAKE_DIR_PATH, new String[0]), new FileAttribute[0]);
        }
        catch (IOException e) {
            log.error("Failed to create directory: {}", (Object)SUB_TOOLS_MAKE_DIR_PATH, (Object)e);
        }
    }

    private static Optional<Document> buildXmlDoc() {
        Document doc = StmTemporaryFileUtils.initDoc();
        if (doc == null) {
            log.info("create document failed ");
            return Optional.empty();
        }
        Element root = doc.createElement("stm-record");
        if (root == null) {
            log.error("get root error.");
            return Optional.empty();
        }
        doc.appendChild(root);
        FeatureData featureData = FeatureData.getInstance();
        Element featureIdElement = doc.createElement("featureId");
        featureIdElement.appendChild(doc.createCDATASection(featureData.getFeatureId()));
        root.appendChild(featureIdElement);
        Element serviceVolumeElement = doc.createElement("serviceVolume");
        serviceVolumeElement.appendChild(doc.createCDATASection(String.valueOf(featureData.getServiceVolume())));
        root.appendChild(serviceVolumeElement);
        return Optional.of(doc);
    }

    private static Boolean writeXmlFile(Document doc) {
        try {
            File xmlFile = new File(SAVE_PATH);
            if (xmlFile.exists()) {
                xmlFile.delete();
                log.info("delete STM record file before write new record");
            }
            XmlWriter.writeDomToXmlFile(doc, SAVE_PATH, true);
            log.info("save STM record file success");
            return true;
        }
        catch (ToolException e) {
            log.error("write STM record file error", (Throwable)e);
            return false;
        }
    }

    public static Optional<FeatureData> readStmRecordFile() {
        log.info("start read stm record file");
        FeatureData featureData = FeatureData.getInstance();
        try {
            NodeList serviceVolumeList;
            File xmlFile = new File(READ_PATH);
            if (!xmlFile.exists()) {
                log.error("STM record file not exist");
                return Optional.empty();
            }
            DocumentBuilder documentBuilder = XmlUtils.newDocumentBuilder();
            Document doc = documentBuilder.parse(xmlFile);
            doc.getDocumentElement().normalize();
            NodeList featureIdList = doc.getElementsByTagName("featureId");
            if (featureIdList.getLength() > 0) {
                featureData.setFeatureId(featureIdList.item(0).getTextContent());
            }
            if ((serviceVolumeList = doc.getElementsByTagName("serviceVolume")).getLength() > 0) {
                featureData.setServiceVolume(Integer.parseInt(serviceVolumeList.item(0).getTextContent()));
            }
            xmlFile.delete();
            log.info("delete STM record file");
            return Optional.of(featureData);
        }
        catch (FileNotFoundException e) {
            log.error("stmRecord.xml not exist");
        }
        catch (Exception e) {
            log.error("read Stm record file failed", (Throwable)e);
        }
        return Optional.empty();
    }

    private StmTemporaryFileUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

