/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.framework.platform.runtime;

import com.huawei.ism.tool.base.utils.StreamUtils;
import com.huawei.ism.tool.framework.platform.common.data.DataType;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.Properties;
import java.util.ResourceBundle;

public final class SystemProperties {
    private static final String CFG_IN_CLASSPATH = "config.system";
    private static final String CFG_IN_WORK_PAHT = DataType.applicationCfg.getDirName() + File.separator + "system.properties";
    private static final String UTF_8 = "utf-8";
    private Properties config = new Properties();
    private ResourceBundle resource = ResourceBundle.getBundle("config.system");
    public static final String SYSTEM_PROPERTIES = "system.properties";
    public static final String TOOLS_DIR = "tools";
    public static final String TOOL_INI = "tool.ini";
    public static final String ESERVICE = "eService";
    public static final String FILETYPE_PROPERTIES = DataType.config.getDirName() + File.separator + "filetypes.xml";

    public String getValue(String key) {
        String value = this.config.getProperty(key);
        if (null == value && null != this.resource) {
            value = this.resource.getString(key);
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SystemProperties(String workPath) {
        if (null == workPath || "".equals(workPath)) {
            ToolLoggerFactory.getLogger(this.getClass()).error("The file is empty.");
            return;
        }
        String cfgFile = workPath + File.separator + CFG_IN_WORK_PAHT;
        if (!new File(cfgFile).exists()) {
            ToolLoggerFactory.getLogger(this.getClass()).error("The file is is not exists.");
            return;
        }
        FileInputStream in = null;
        InputStreamReader reader = null;
        try {
            in = new FileInputStream(cfgFile);
            reader = new InputStreamReader((InputStream)in, Charset.forName(UTF_8));
            this.config.load(reader);
        }
        catch (IOException e) {
            try {
                ToolLoggerFactory.getLogger(this.getClass()).error("load workPath prop error.", (Throwable)e);
            }
            catch (Throwable throwable) {
                StreamUtils.closeResource(null, reader);
                StreamUtils.closeResource(null, in);
                throw throwable;
            }
            StreamUtils.closeResource(null, reader);
            StreamUtils.closeResource(null, in);
        }
        StreamUtils.closeResource(null, reader);
        StreamUtils.closeResource(null, in);
    }
}

