/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.framework.platform.util;

import com.huawei.ism.tool.base.utils.FilePathUtils;
import com.huawei.ism.tool.base.utils.ProperUtils;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.framework.platform.PlatformAppContext;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import java.io.File;
import java.io.IOException;
import java.util.Locale;
import org.slf4j.Logger;

public class LanguageConfigKeeper {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(LanguageConfigKeeper.class);
    private static final String CHINA_VERSION = "toolkit.app.zh_or_en.version";
    private static final String LANGUAGE_CONFIG_FILE = ApplicationContext.getInstance().getUserDataPath() + File.separator + "language.config";
    private static final String RUNTIME_DATA_PATH = "app.user.data.path";

    public final Locale getCurrentLocale() {
        boolean isChinaVersion = PlatformAppContext.getInstance().getFunctionBooleanByKey(CHINA_VERSION);
        if (!isChinaVersion) {
            return Locale.CHINA;
        }
        return this.readLocale();
    }

    public final void saveCurrentLocale(Locale locale) {
        this.saveLocale(locale);
    }

    private String getLanguageConfigPath() {
        String result = FilePathUtils.getSafePath(this.getRuntimePath() + File.separator + LANGUAGE_CONFIG_FILE);
        return result;
    }

    private String getRuntimePath() {
        String runtimePath = this.getRuntimePathByConfig();
        if (runtimePath == null || runtimePath.equals("")) {
            return ApplicationContext.getInstance().getWorkPath();
        }
        return runtimePath;
    }

    private String getRuntimePathByConfig() {
        String runtimeDataPath = ApplicationContext.getInstance().getAppConfig(RUNTIME_DATA_PATH);
        if (runtimeDataPath == null || runtimeDataPath.trim().equals("")) {
            return "";
        }
        File runtimeFile = new File(runtimeDataPath);
        if (runtimeFile.exists() && !runtimeFile.isDirectory()) {
            return "";
        }
        if (!runtimeFile.exists() && !runtimeFile.mkdirs()) {
            return "";
        }
        try {
            return runtimeFile.getCanonicalPath();
        }
        catch (IOException e) {
            LOGGER.error("get RuntimePath error.", (Throwable)e);
            return "";
        }
    }

    private synchronized Locale saveLocale(Locale locale) {
        String filepath = this.getLanguageConfigPath();
        File file = new File(filepath);
        if (!file.exists()) {
            LOGGER.info("lauguage config file is not exist,read the default locale.");
        }
        String localeStr = locale.toString().toLowerCase(Locale.ENGLISH).trim();
        Locale language = null;
        language = localeStr.startsWith("zh") ? Locale.SIMPLIFIED_CHINESE : Locale.ENGLISH;
        try {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("saveLocale::filepath=" + file.getCanonicalPath() + ",language=" + language.toString());
            }
        }
        catch (IOException e) {
            LOGGER.error("saveLocale error.", (Throwable)e);
        }
        ProperUtils.getInstance().putValue(file, "language", language.toString());
        return language;
    }

    private synchronized Locale readLocale() {
        String filepath = this.getLanguageConfigPath();
        File file = new File(filepath);
        if (!file.exists()) {
            LOGGER.info("lauguage config file is not exist,read the default locale.");
            Locale language = this.saveLocale(Locale.getDefault());
            return language;
        }
        String language = ProperUtils.getInstance().getValue(file, "language");
        if (!StringUtils.isNULLStr(language)) {
            String lanstr = language.toLowerCase(Locale.ENGLISH).trim();
            if (lanstr.startsWith("zh")) {
                return Locale.SIMPLIFIED_CHINESE;
            }
            if (lanstr.equals("default")) {
                String lantem = Locale.getDefault().toString().toLowerCase(Locale.ENGLISH).trim();
                if (lantem.startsWith("zh")) {
                    return Locale.SIMPLIFIED_CHINESE;
                }
                return Locale.ENGLISH;
            }
            return Locale.ENGLISH;
        }
        return Locale.getDefault();
    }
}

