/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.framework.platform.worktaker;

import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.framework.platform.worktaker.AbstractWorktaker;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;

public abstract class AbstractWorktakerFactory {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(AbstractWorktakerFactory.class);
    private Map<String, Class<? extends AbstractWorktaker>> worktakerMap = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractWorktakerFactory(String wktkCfg, ClassLoader cl) {
        InputStream wktkCfgIn = cl.getResourceAsStream(wktkCfg);
        if (null == wktkCfgIn) {
            return;
        }
        Properties config = new Properties();
        try {
            config.load(wktkCfgIn);
        }
        catch (IOException e) {
            LOGGER.error("Load worktaker config error.", (Throwable)e);
            return;
        }
        finally {
            try {
                wktkCfgIn.close();
            }
            catch (IOException e) {
                LOGGER.error("Close worktaker config error.", (Throwable)e);
            }
        }
        this.worktakerMap = new HashMap<String, Class<? extends AbstractWorktaker>>();
        for (Object key : config.keySet()) {
            String name = (String)key;
            String impl = config.getProperty(name);
            try {
                Class<AbstractWorktaker> implClazz = cl.loadClass(impl).asSubclass(AbstractWorktaker.class);
                this.worktakerMap.put(name, implClazz);
            }
            catch (ClassNotFoundException e) {
                LOGGER.error("Load worktaker implements class error.", (Throwable)e);
            }
            catch (ClassCastException e2) {
                LOGGER.error("Load worktaker implements class error.", (Throwable)e2);
            }
        }
    }

    public abstract <T> T getWorktaker(Class<T> var1);

    protected <T> T getWorktakerFromMap(Class<T> clazz) {
        Class<? extends AbstractWorktaker> implClazz = this.worktakerMap.get(clazz.getName());
        if (null == implClazz) {
            return null;
        }
        try {
            AbstractWorktaker wktk = implClazz.newInstance();
            return (T)wktk;
        }
        catch (InstantiationException e) {
            LOGGER.error("Instantiate worktaker error.", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            LOGGER.error("Instantiate worktaker error.", (Throwable)e);
        }
        return null;
    }
}

