/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.framework.pubservice.hardware;

import com.huawei.ism.tool.framework.pubservice.hardware.IHardwareInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HardwareDetail {
    private IHardwareInfo info;
    private List<String> subTypeList = new ArrayList<String>();
    private Map<String, List<HardwareDetail>> subModulesMap = new HashMap<String, List<HardwareDetail>>();

    public HardwareDetail(IHardwareInfo info) {
        this.info = info;
    }

    public IHardwareInfo getInfo() {
        return this.info;
    }

    public void setInfo(IHardwareInfo info) {
        this.info = info;
    }

    public List<String> getSubTypeList() {
        return new ArrayList<String>(this.subTypeList);
    }

    public List<HardwareDetail> getSubModules(String typeName) {
        return this.subModulesMap.get(typeName);
    }

    public List<HardwareDetail> getSubModules() {
        ArrayList<HardwareDetail> subModules = new ArrayList<HardwareDetail>();
        for (List<HardwareDetail> modules : this.subModulesMap.values()) {
            subModules.addAll(modules);
        }
        return subModules;
    }

    public void addSubModule(HardwareDetail module) {
        List<HardwareDetail> modules;
        String type = module.getInfo().getTypeName();
        if (!this.subTypeList.contains(type)) {
            this.subTypeList.add(type);
        }
        if (null == (modules = this.subModulesMap.get(type))) {
            modules = new ArrayList<HardwareDetail>();
            this.subModulesMap.put(type, modules);
        }
        modules.add(module);
    }
}

