/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.framework.pubservice.scenedata;

import com.huawei.ism.tool.base.utils.AESEncrypt;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import com.huawei.ism.tool.framework.pubservice.entity.DevNode;
import com.huawei.ism.tool.framework.pubservice.entity.MultiRouteNode;
import com.huawei.ism.tool.framework.pubservice.exception.EncapsulatedRuntimeException;
import com.huawei.ism.tool.framework.pubservice.scenedata.SceneXmlData;
import com.huawei.json.JSONArray;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;

public class SceneDeviceData {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(SceneDeviceData.class);

    public static List<Map<String, String>> injectDeviceData(List<DevNode> devs) {
        if (devs == null) {
            return null;
        }
        ArrayList<Map<String, String>> listMap = new ArrayList<Map<String, String>>();
        for (DevNode dev : devs) {
            HashMap<String, String> map = new HashMap<String, String>();
            SceneDeviceData.putSimpleParams(dev, map);
            map.put("storageDeviceType", dev.getStorageDeviceType().getName());
            SceneDeviceData.putProcessedParams(listMap, dev, map);
        }
        return listMap;
    }

    public static List<Map<String, String>> injectDeviceDataBySubTool(List<DevNode> devs) {
        ArrayList<Map<String, String>> listMap = new ArrayList<Map<String, String>>();
        if (devs == null) {
            return listMap;
        }
        for (DevNode dev : devs) {
            HashMap<String, String> map = new HashMap<String, String>();
            SceneDeviceData.putSimpleParams(dev, map, true);
            map.put("storageDeviceType", dev.getStorageDeviceType().getName());
            SceneDeviceData.putProcessedParams(listMap, dev, map);
        }
        return listMap;
    }

    private static void putProcessedParams(List<Map<String, String>> listMap, DevNode dev, Map<String, String> map) {
        String path = ApplicationContext.getInstance().getWorkPath();
        if (null == path) {
            throw new EncapsulatedRuntimeException("Path is null");
        }
        path = Normalizer.normalize(path, Normalizer.Form.NFKC);
        int index = path.lastIndexOf("\\");
        String toolTypeName = path.substring(index + 1, path.length());
        map.put("toolLog", toolTypeName);
        if (dev.getComputeStorageDevNode() != null) {
            map.put("computeStorageInfoFcvOpenApiUserName", dev.getComputeStorageDevNode().getOpenapiUser().getUserName());
            map.put("computeStorageInfoFcvOpenApiUserPwd", AESEncrypt.encrypt(dev.getComputeStorageDevNode().getOpenapiUser().getPassword()));
            map.put("computeStorageInfoFcvIp", dev.getComputeStorageDevNode().getFcvIp());
            map.put("computeStorageInfoFcvPort", String.valueOf(dev.getComputeStorageDevNode().getFcvPort()));
            map.put("computeStorageInfoFcvDeviceId", String.valueOf(dev.getComputeStorageDevNode().getComputeStorageFcvDeviceId()));
            map.put("computeStorageInfoChassisNum", dev.getComputeStorageDevNode().getChassisNum());
            map.put("computeStorageInfoList", new JSONArray(dev.getComputeStorageDevNode().getStorageNodesInfo()).toString());
        }
        map.put("domainName", dev.getLoginUser().getDomainName());
        if (null != dev.getAdminUser()) {
            map.put("adminName", dev.getAdminUser().getUserName());
            map.put("adminPassword", AESEncrypt.encrypt(dev.getAdminUser().getPassword()));
        }
        map.put("status", "");
        map.put("developerPwd", AESEncrypt.encrypt(dev.getDeveloperPwd()));
        if (dev.getRootUser() != null) {
            map.put("rootPassword", AESEncrypt.encrypt(dev.getRootUser().getPassword()));
        }
        map.put("createTime", String.valueOf(dev.getCreateTime()));
        map.put("port", String.valueOf(dev.getPort()));
        map.put("ipListAreInnerIp", String.valueOf(dev.isIpListAreInnerIp()));
        map.put("tlvPort", String.valueOf(dev.getTlvPort()));
        if (null != dev.getRemoteSNs()) {
            map.put("remoteSNs", dev.getRemoteSNs().toString());
        }
        map.put("hostAssociatedRemoteSN", dev.getHostAssociatedRemoteSN().toString());
        map.put("canEnterDiagnose", String.valueOf(dev.canEnterDiagnose()));
        listMap.add(map);
        LOGGER.info("scene device data add finished");
    }

    private static void putSimpleParams(DevNode dev, Map<String, String> map) {
        SceneDeviceData.putSimpleParams(dev, map, false);
    }

    private static void putSimpleParams(DevNode dev, Map<String, String> map, boolean isSubTool) {
        map.put("toolId", "");
        map.put("SN", dev.getDeviceSerialNumber());
        map.put("deviceName", dev.getDeviceName());
        map.put("itDeviceType", dev.getItDeviceType().getName());
        map.put("IP", dev.getIp());
        map.put("userName", dev.getLoginUser().getUserName());
        map.put("password", AESEncrypt.encrypt(dev.getLoginUser().getPassword()));
        if (dev.isFusionCube() && Objects.nonNull(dev.getFusionCubeLoginUser())) {
            map.put("scenarioInfo", dev.getScenarioInfo());
            map.put("sshUsername", dev.getFusionCubeLoginUser().getUserName());
            map.put("sshPassword", AESEncrypt.encrypt(dev.getFusionCubeLoginUser().getPassword()));
        }
        map.put("productVersion", dev.getProductVersion());
        map.put("hotpatchversion", dev.getHotPatchVersion());
        map.put("deviceType", String.valueOf(dev.getDeviceType()));
        map.put("devTypeLevel2", String.valueOf(dev.getDevTypeLevel2()));
        map.put("dbName", dev.getDbName());
        map.put("useJdbc", dev.isUseJdbc() ? "true" : "false");
        map.put("socks5Proxy", null == dev.getSocks5Proxy() ? "" : dev.getSocks5Proxy().toJasonString());
        map.put("sshForwardList", dev.getSshForwardList().stream().map(MultiRouteNode::toJsonStr).collect(Collectors.toList()).toString());
        map.put("ipList", dev.getIpList().toString());
        map.put("tlvSocketType", dev.getTlvSocketType());
        map.put("peerIp", dev.getPeerIp());
        map.put("PriKeyInfo", null == dev.getPriKey() ? "" : dev.getPriKey().toJasonString());
        map.put("hostISCSILauncherWwns", dev.getHostISCSILauncherWwns().toString());
        map.put("hostFCLauncherWwns", dev.getHostFCLauncherWwns().toString());
        map.put("hostIbLauncherWwns", dev.getHostIbLauncherWwns().toString());
        map.put("hostNvmeLauncherWwns", dev.getHostNvmeLauncherWwns().toString());
        map.put("highDevSVPModuleInfo", dev.getHighDevSVPModuleInfo());
        map.put("devInfoPkgPath", dev.getDevInfoPkgPath());
        map.put("isHyperMetroHost", Boolean.toString(dev.isHyperMetroHost()));
        map.put("nodeAddType", dev.getNodeAddType().toString());
        map.put("isVerifyCertificate", Boolean.toString(dev.isVerifyCertificate()));
        map.put("selectNodeIps", String.join((CharSequence)",", dev.getSelectedNodeIps()));
        LOGGER.info("highDevSVPModuleInfo:" + dev.getHighDevSVPModuleInfo());
    }

    public List<DevNode> refreshDeviceNodes(List<DevNode> devs) {
        List<DevNode> devNodes = SceneXmlData.getInstance().loadSceneFromFile();
        if (null == devNodes) {
            return null;
        }
        for (DevNode devNode : devNodes) {
            for (DevNode dev : devs) {
                if (!devNode.getDevKey().equals(dev.getDevKey())) continue;
                devNode.setProductVersion(dev.getProductVersion());
                devNode.setHotPatchVersion(dev.getHotPatchVersion());
                devNode.setDeviceType(dev.getDeviceType());
            }
        }
        return devNodes;
    }
}

